/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.apache.commons.lang3.reflect.FieldUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.MethodWriter;
import org.objectweb.asm.SymbolTable;
import org.objectweb.asm.tree.MethodNode;

public class AsmBridge {
    public static MethodVisitor searchMethodWriter(MethodVisitor mv) {
        while (mv != null && !(mv instanceof MethodWriter)) {
            mv = mv.mv;
        }
        return mv;
    }

    public static int sizeOfMethodWriter(MethodVisitor mv) {
        MethodWriter mw = (MethodWriter)mv;
        return mw.computeMethodInfoSize();
    }

    private static void removeMethodWriter(MethodWriter mw, ClassWriter cw) {
        MethodWriter p = AsmBridge.getFirstMethod(cw);
        if (p == mw) {
            AsmBridge.setFirstMethod(cw, null);
            if (AsmBridge.getLastMethod(cw) == mw) {
                AsmBridge.setLastMethod(cw, null);
            }
        } else {
            while (p != null) {
                if (p.mv == mw) {
                    p.mv = mw.mv;
                    if (AsmBridge.getLastMethod(cw) != mw) break;
                    AsmBridge.setLastMethod(cw, p);
                    break;
                }
                p = (MethodWriter)p.mv;
            }
        }
    }

    private static MethodWriter getFirstMethod(ClassWriter cw) {
        MethodWriter mw = null;
        try {
            mw = (MethodWriter)FieldUtils.readField(cw, "firstMethod", true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return mw;
    }

    private static void setFirstMethod(ClassWriter cw, Object value) {
        try {
            FieldUtils.writeField(cw, "firstMethod", value, true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static MethodWriter getLastMethod(ClassWriter cw) {
        MethodWriter mw = null;
        try {
            mw = (MethodWriter)FieldUtils.readField(cw, "lastMethod", true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return mw;
    }

    private static void setLastMethod(ClassWriter cw, Object value) {
        try {
            FieldUtils.writeField(cw, "lastMethod", value, true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void replaceMethodWriter(MethodVisitor mv, MethodNode mn) {
        MethodWriter mw = (MethodWriter)mv;
        ClassWriter cw = AsmBridge.getClassWriter(mw);
        mn.accept(cw);
        AsmBridge.removeMethodWriter(mw, cw);
    }

    private static ClassWriter getClassWriter(MethodWriter mw) {
        ClassWriter cw = null;
        SymbolTable symbolTable = null;
        try {
            symbolTable = (SymbolTable)FieldUtils.readField(mw, "symbolTable", true);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        cw = symbolTable.classWriter;
        return cw;
    }
}

