/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.DominanceFinder;

public class DominanceTree {
    private List<BasicBlock<?>> blocks;
    private Map<BasicBlock<?>, Integer> blockToIdx;
    private List<Integer>[] children;
    private int[] parents;

    public DominanceTree(@Nonnull DominanceFinder dominanceFinder) {
        int i;
        this.blocks = dominanceFinder.getIdxToBlock();
        this.blockToIdx = dominanceFinder.getBlockToIdx();
        int[] iDoms = dominanceFinder.getImmediateDominators();
        int treeSize = iDoms.length;
        this.children = new ArrayList[treeSize];
        this.parents = new int[treeSize];
        for (i = 0; i < treeSize; ++i) {
            this.children[i] = new ArrayList<Integer>();
            this.parents[i] = -1;
        }
        for (i = 0; i < treeSize; ++i) {
            if (iDoms[i] == i) continue;
            this.parents[i] = iDoms[i];
            this.children[iDoms[i]].add(i);
        }
    }

    @Nonnull
    public List<BasicBlock<?>> getChildren(@Nonnull BasicBlock<?> block) {
        ArrayList childList = new ArrayList();
        int idx = this.blockToIdx.get(block);
        for (int i : this.children[idx]) {
            childList.add(this.blocks.get(i));
        }
        return childList;
    }

    @Nullable
    public BasicBlock<?> getParent(@Nonnull BasicBlock<?> block) {
        int idx = this.blockToIdx.get(block);
        if (this.parents[idx] == -1) {
            return null;
        }
        return this.blocks.get(this.parents[idx]);
    }

    @Nonnull
    public BasicBlock<?> getRoot() {
        return this.blocks.get(0);
    }

    public void replaceNode(@Nonnull BasicBlock<?> oldBlock, @Nonnull BasicBlock<?> newBlock) {
        if (!this.blockToIdx.containsKey(oldBlock)) {
            throw new RuntimeException("The given replaced block " + oldBlock + "is not in the DominanceTree");
        }
        int idx = this.blockToIdx.get(oldBlock);
        this.blocks.set(idx, newBlock);
        this.blockToIdx.remove(oldBlock);
        this.blockToIdx.put(newBlock, idx);
    }

    @Nonnull
    public List<BasicBlock<?>> getAllNodesDFS() {
        ArrayList blocks = new ArrayList();
        ArrayDeque queue = new ArrayDeque();
        queue.add(this.getRoot());
        while (!queue.isEmpty()) {
            BasicBlock fb = (BasicBlock)queue.removeFirst();
            blocks.add(fb);
            if (this.getChildren(fb).isEmpty()) continue;
            List<BasicBlock<?>> children = this.getChildren(fb);
            for (int i = children.size() - 1; i >= 0; --i) {
                queue.addFirst(children.get(i));
            }
        }
        return blocks;
    }
}

