/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.graph.iterator;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JReturnVoidStmt;
import sootup.core.jimple.common.stmt.Stmt;

public class StmtGraphBlockIterator
implements Iterator<Stmt> {
    @Nonnull
    private final StmtGraph<?> graph;
    @Nonnull
    private final List<Trap> traps;
    private int trapIdx = 0;
    @Nonnull
    private final ArrayDeque<Stmt> currentUnbranchedBlock = new ArrayDeque();
    @Nonnull
    private final ArrayDeque<Stmt> nestedBlocks = new ArrayDeque();
    @Nonnull
    private final ArrayDeque<Stmt> otherBlocks = new ArrayDeque();
    @Nullable
    private Stmt cachedNextStmt;
    @Nonnull
    private final Set<Stmt> returnedNodes;

    public StmtGraphBlockIterator(@Nonnull StmtGraph graph, @Nonnull List<Trap> traps) {
        this.graph = graph;
        this.returnedNodes = new HashSet<Stmt>(graph.nodes().size(), 1.0f);
        Stmt startingStmt = graph.getStartingStmt();
        if (startingStmt != null) {
            this.returnedNodes.add(startingStmt);
        }
        this.cachedNextStmt = startingStmt;
        this.traps = traps;
    }

    @Nullable
    private Stmt retrieveNextStmt() {
        Stmt stmt;
        do {
            if (!this.currentUnbranchedBlock.isEmpty()) {
                stmt = this.currentUnbranchedBlock.pollFirst();
                continue;
            }
            if (!this.nestedBlocks.isEmpty()) {
                stmt = this.nestedBlocks.pollFirst();
                continue;
            }
            if (this.trapIdx < this.traps.size()) {
                stmt = this.traps.get(this.trapIdx++).getHandlerStmt();
                continue;
            }
            if (!this.otherBlocks.isEmpty()) {
                stmt = this.otherBlocks.pollFirst();
                continue;
            }
            return null;
        } while (this.returnedNodes.contains(stmt));
        this.returnedNodes.add(stmt);
        return stmt;
    }

    @Override
    @Nonnull
    public Stmt next() {
        Trap nextTrap;
        Stmt stmt = this.cachedNextStmt;
        if (stmt == null) {
            throw new NoSuchElementException("Iterator has no more Stmts.");
        }
        if (this.trapIdx < this.traps.size() && stmt == (nextTrap = this.traps.get(this.trapIdx)).getEndStmt()) {
            this.currentUnbranchedBlock.addFirst(nextTrap.getHandlerStmt());
            ++this.trapIdx;
        }
        List<Stmt> successors = this.graph.successors(stmt);
        for (int i = successors.size() - 1; i >= 0; --i) {
            boolean flag;
            Stmt succ = successors.get(i);
            if (i == 0 && stmt.fallsThrough()) {
                this.currentUnbranchedBlock.addFirst(succ);
                continue;
            }
            Stmt leaderStmt = succ;
            block1: do {
                flag = true;
                List<Stmt> itPreds = this.graph.predecessors(leaderStmt);
                for (Stmt pred : itPreds) {
                    if (!pred.fallsThrough() || this.graph.successors(pred).get(0) != leaderStmt) continue;
                    leaderStmt = pred;
                    flag = false;
                    continue block1;
                }
            } while (!flag);
            boolean isReturnBlock = false;
            Stmt itReturnStmt = succ;
            while (itReturnStmt.fallsThrough()) {
                itReturnStmt = this.graph.successors(itReturnStmt).get(0);
            }
            if (itReturnStmt instanceof JReturnVoidStmt || itReturnStmt instanceof JReturnStmt) {
                isReturnBlock = true;
            }
            if (stmt instanceof JGotoStmt) {
                if (isReturnBlock) {
                    this.nestedBlocks.removeFirstOccurrence(leaderStmt);
                    this.otherBlocks.addLast(leaderStmt);
                    continue;
                }
                this.otherBlocks.addFirst(leaderStmt);
                continue;
            }
            if (this.nestedBlocks.contains(leaderStmt)) continue;
            if (isReturnBlock) {
                this.nestedBlocks.addLast(leaderStmt);
                continue;
            }
            this.nestedBlocks.addFirst(leaderStmt);
        }
        this.cachedNextStmt = this.retrieveNextStmt();
        return stmt;
    }

    @Override
    public boolean hasNext() {
        boolean hasIteratorMoreElements = this.cachedNextStmt != null;
        int returnedSize = this.returnedNodes.size();
        int actualSize = this.graph.nodes().size();
        if (!hasIteratorMoreElements && returnedSize != actualSize) {
            String info = this.graph.nodes().stream().filter(n -> !this.returnedNodes.contains(n)).collect(Collectors.toList()).toString();
            throw new RuntimeException("There are " + (actualSize - returnedSize) + " stmts that are not iterated! StmtGraph is not connected from startingStmt!" + info);
        }
        return hasIteratorMoreElements;
    }
}

