/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.visitor.Acceptor;
import sootup.core.jimple.visitor.ImmediateVisitor;
import sootup.core.model.Position;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public class Local
implements Immediate,
Copyable,
Acceptor<ImmediateVisitor> {
    @Nonnull
    private final String name;
    @Nonnull
    private final Type type;
    @Nonnull
    private final Position position;

    public Local(@Nonnull String name, @Nonnull Type type) {
        this(name, type, NoPositionInformation.getInstance());
    }

    public Local(@Nonnull String name, @Nonnull Type type, @Nonnull Position position) {
        this.name = name;
        this.type = type;
        this.position = position;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Local)) {
            return false;
        }
        return this.name.equals(((Local)o).getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    @Override
    public boolean equivTo(@Nonnull Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseLocal(this, o);
    }

    @Override
    public int equivHashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        up.local(this);
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        return Collections.emptyList();
    }

    @Nonnull
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void accept(@Nonnull ImmediateVisitor v) {
        v.caseLocal(this);
    }

    @Nonnull
    public Local withName(@Nonnull String name) {
        return new Local(name, this.type);
    }

    @Nonnull
    public Local withType(@Nonnull Type type) {
        return new Local(this.name, type);
    }
}

