/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.constant;

import javax.annotation.Nonnull;
import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.RealConstant;
import sootup.core.jimple.visitor.ConstantVisitor;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;

public class DoubleConstant
implements RealConstant<DoubleConstant> {
    private final double value;

    private DoubleConstant(@Nonnull double value) {
        this.value = value;
    }

    public static DoubleConstant getInstance(@Nonnull double value) {
        return new DoubleConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof DoubleConstant && Double.compare(((DoubleConstant)c).value, this.value) == 0;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    @Override
    @Nonnull
    public DoubleConstant add(@Nonnull DoubleConstant c) {
        return DoubleConstant.getInstance(this.value + c.value);
    }

    @Override
    @Nonnull
    public DoubleConstant subtract(@Nonnull DoubleConstant c) {
        return DoubleConstant.getInstance(this.value - c.value);
    }

    @Override
    @Nonnull
    public DoubleConstant multiply(@Nonnull DoubleConstant c) {
        return DoubleConstant.getInstance(this.value * c.value);
    }

    @Override
    @Nonnull
    public DoubleConstant divide(@Nonnull DoubleConstant c) {
        return DoubleConstant.getInstance(this.value / c.value);
    }

    @Override
    @Nonnull
    public DoubleConstant remainder(@Nonnull DoubleConstant c) {
        return DoubleConstant.getInstance(this.value % c.value);
    }

    @Override
    @Nonnull
    public BooleanConstant equalEqual(@Nonnull DoubleConstant c) {
        return BooleanConstant.getInstance(Double.compare(this.value, c.value) == 0);
    }

    @Override
    @Nonnull
    public BooleanConstant notEqual(@Nonnull DoubleConstant c) {
        return BooleanConstant.getInstance(Double.compare(this.value, c.value) != 0);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThan(@Nonnull DoubleConstant c) {
        return BooleanConstant.getInstance(Double.compare(this.value, c.value) < 0);
    }

    @Override
    @Nonnull
    public BooleanConstant lessThanOrEqual(@Nonnull DoubleConstant c) {
        return BooleanConstant.getInstance(Double.compare(this.value, c.value) <= 0);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThan(@Nonnull DoubleConstant c) {
        return BooleanConstant.getInstance(Double.compare(this.value, c.value) > 0);
    }

    @Override
    @Nonnull
    public BooleanConstant greaterThanOrEqual(@Nonnull DoubleConstant c) {
        return BooleanConstant.getInstance(Double.compare(this.value, c.value) >= 0);
    }

    @Override
    @Nonnull
    public IntConstant cmpg(@Nonnull DoubleConstant constant) {
        double cValue = constant.value;
        if (this.value < cValue) {
            return IntConstant.getInstance(-1);
        }
        if (this.value == cValue) {
            return IntConstant.getInstance(0);
        }
        return IntConstant.getInstance(1);
    }

    @Override
    @Nonnull
    public IntConstant cmpl(@Nonnull DoubleConstant constant) {
        double cValue = constant.value;
        if (this.value > cValue) {
            return IntConstant.getInstance(1);
        }
        if (this.value == cValue) {
            return IntConstant.getInstance(0);
        }
        return IntConstant.getInstance(-1);
    }

    @Override
    @Nonnull
    public DoubleConstant negate() {
        return DoubleConstant.getInstance(-this.value);
    }

    public String toString() {
        String doubleString = Double.toString(this.value);
        if (doubleString.equals("NaN") || doubleString.equals("Infinity") || doubleString.equals("-Infinity")) {
            return "#" + doubleString;
        }
        return doubleString;
    }

    @Override
    @Nonnull
    public Type getType() {
        return PrimitiveType.getDouble();
    }

    @Override
    public void accept(@Nonnull ConstantVisitor v) {
        v.caseDoubleConstant(this);
    }

    private void assertInstanceOf(Constant constant) {
        if (!(constant instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
    }

    public double getValue() {
        return this.value;
    }
}

