/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.Type;
import sootup.core.util.printer.StmtPrinter;

public abstract class AbstractInvokeExpr
implements Expr {
    @Nonnull
    private final MethodSignature methodSignature;
    @Nonnull
    private final Immediate[] args;

    protected AbstractInvokeExpr(@Nonnull MethodSignature method, @Nonnull Immediate[] args) {
        this.methodSignature = method;
        for (Immediate arg : args) {
            if (arg != null) continue;
            throw new IllegalArgumentException("arg may not be null");
        }
        this.args = args;
    }

    @Nonnull
    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public Value getArg(int index) {
        return this.args[index];
    }

    public List<Immediate> getArgs() {
        return Collections.unmodifiableList(Arrays.asList(this.args));
    }

    public int getArgCount() {
        return this.args.length;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.methodSignature.getType();
    }

    @Override
    @Nonnull
    public List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>(this.getArgCount());
        Collections.addAll(list, this.args);
        for (Immediate arg : this.args) {
            list.addAll(arg.getUses());
        }
        return list;
    }

    protected void argsToString(@Nonnull StringBuilder builder) {
        int len = this.getArgCount();
        if (0 < len) {
            builder.append(this.args[0].toString());
            for (int i = 1; i < len; ++i) {
                builder.append(", ");
                builder.append(this.args[i].toString());
            }
        }
    }

    protected void argsToPrinter(@Nonnull StmtPrinter up) {
        int len = this.getArgCount();
        if (0 < len) {
            this.args[0].toString(up);
            for (int i = 1; i < len; ++i) {
                up.literal(", ");
                this.args[i].toString(up);
            }
        }
    }
}

