/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.expr;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.visitor.ExprVisitor;
import sootup.core.types.ArrayType;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JNewMultiArrayExpr
implements Expr,
Copyable {
    private final ArrayType baseType;
    private final List<Immediate> sizes;

    public JNewMultiArrayExpr(@Nonnull ArrayType type, @Nonnull List<Immediate> sizes) {
        this.baseType = type;
        this.sizes = sizes;
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseNewMultiArrayExpr(this, o);
    }

    @Override
    public int equivHashCode() {
        return this.baseType.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Type t = this.baseType.getBaseType();
        builder.append("newmultiarray (").append(t.toString()).append(")");
        for (Value value : this.sizes) {
            builder.append("[").append(value.toString()).append("]");
        }
        for (int i = 0; i < this.baseType.getDimension() - this.sizes.size(); ++i) {
            builder.append("[]");
        }
        return builder.toString();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        Type t = this.baseType.getBaseType();
        up.literal("newmultiarray");
        up.literal(" (");
        up.typeSignature(t);
        up.literal(")");
        for (Value value : this.sizes) {
            up.literal("[");
            value.toString(up);
            up.literal("]");
        }
        for (int i = 0; i < this.baseType.getDimension() - this.sizes.size(); ++i) {
            up.literal("[]");
        }
    }

    public ArrayType getBaseType() {
        return this.baseType;
    }

    public Value getSize(@Nonnull int index) {
        return this.sizes.get(index);
    }

    public int getSizeCount() {
        return this.sizes.size();
    }

    public List<Immediate> getSizes() {
        return this.sizes;
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>();
        list.addAll(this.sizes);
        for (Value value : this.sizes) {
            list.addAll(value.getUses());
        }
        return list;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.baseType;
    }

    @Override
    public void accept(@Nonnull ExprVisitor v) {
        v.caseNewMultiArrayExpr(this);
    }

    @Nonnull
    public JNewMultiArrayExpr withBaseType(@Nonnull ArrayType baseType) {
        return new JNewMultiArrayExpr(baseType, this.getSizes());
    }

    @Nonnull
    public JNewMultiArrayExpr withSizes(@Nonnull List<Immediate> sizes) {
        return new JNewMultiArrayExpr(this.baseType, sizes);
    }
}

