/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.stmt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.types.Type;

public abstract class AbstractDefinitionStmt<L extends Value, R extends Value>
extends Stmt {
    @Nonnull
    private final L leftOp;
    @Nonnull
    private final R rightOp;

    AbstractDefinitionStmt(@Nonnull L leftOp, @Nonnull R rightOp, @Nonnull StmtPositionInfo positionInfo) {
        super(positionInfo);
        this.leftOp = leftOp;
        this.rightOp = rightOp;
    }

    @Nonnull
    public final L getLeftOp() {
        return this.leftOp;
    }

    @Nonnull
    public R getRightOp() {
        return this.rightOp;
    }

    @Nonnull
    public Type getType() {
        return this.getLeftOp().getType();
    }

    @Override
    @Nonnull
    public List<Value> getDefs() {
        return Collections.singletonList(this.leftOp);
    }

    @Override
    @Nonnull
    public final List<Value> getUses() {
        ArrayList<Value> list = new ArrayList<Value>(this.leftOp.getUses());
        list.add((Value)this.rightOp);
        list.addAll(this.rightOp.getUses());
        return list;
    }

    @Override
    public boolean fallsThrough() {
        return true;
    }

    @Override
    public boolean branches() {
        return false;
    }
}

