/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.common.stmt;

import javax.annotation.Nonnull;
import sootup.core.jimple.basic.JimpleComparator;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.visitor.StmtVisitor;
import sootup.core.util.Copyable;
import sootup.core.util.printer.StmtPrinter;

public final class JIdentityStmt<T extends IdentityRef>
extends AbstractDefinitionStmt<Local, T>
implements Copyable {
    public JIdentityStmt(@Nonnull Local local, @Nonnull T identityValue, @Nonnull StmtPositionInfo positionInfo) {
        super(local, identityValue, positionInfo);
    }

    public String toString() {
        return this.getLeftOp() + " := " + this.getRightOp();
    }

    @Override
    public void toString(@Nonnull StmtPrinter up) {
        ((Local)this.getLeftOp()).toString(up);
        up.literal(" := ");
        ((IdentityRef)this.getRightOp()).toString(up);
    }

    @Override
    public void accept(@Nonnull StmtVisitor sw) {
        sw.caseIdentityStmt(this);
    }

    @Override
    public boolean equivTo(Object o, @Nonnull JimpleComparator comparator) {
        return comparator.caseIdentityStmt(this, o);
    }

    @Override
    public int equivHashCode() {
        return ((Local)this.getLeftOp()).equivHashCode() + 31 * ((IdentityRef)this.getRightOp()).equivHashCode();
    }

    @Nonnull
    public JIdentityStmt<T> withLocal(@Nonnull Local local) {
        return new JIdentityStmt<IdentityRef>(local, (IdentityRef)this.getRightOp(), this.getPositionInfo());
    }

    @Nonnull
    public <N extends IdentityRef> JIdentityStmt<N> withIdentityValue(@Nonnull N identityValue) {
        return new JIdentityStmt<N>((Local)this.getLeftOp(), identityValue, this.getPositionInfo());
    }

    @Nonnull
    public JIdentityStmt<T> withPositionInfo(@Nonnull StmtPositionInfo positionInfo) {
        return new JIdentityStmt<IdentityRef>((Local)this.getLeftOp(), (IdentityRef)this.getRightOp(), positionInfo);
    }
}

