/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.jimple.visitor;

import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.ref.Ref;
import sootup.core.jimple.visitor.AbstractRefVisitor;

public class ReplaceUseRefVisitor
extends AbstractRefVisitor<Ref> {
    private Value oldUse;
    private Value newUse;

    public void init(@Nonnull Value oldUse, @Nonnull Value newUse) {
        this.oldUse = oldUse;
        this.newUse = newUse;
    }

    @Override
    public void caseInstanceFieldRef(@Nonnull JInstanceFieldRef ref) {
        if (ref.getBase() == this.oldUse) {
            this.setResult(ref.withBase((Local)this.newUse));
        } else {
            this.errorHandler(ref);
        }
    }

    @Override
    public void caseArrayRef(@Nonnull JArrayRef ref) {
        if (ref.getBase() == this.oldUse) {
            this.setResult(ref.withBase((Local)this.newUse));
        } else if (ref.getIndex() == this.oldUse) {
            this.setResult(ref.withIndex((Immediate)this.newUse));
        } else {
            this.errorHandler(ref);
        }
    }

    @Override
    public void defaultCaseRef(@Nonnull Ref ref) {
        this.setResult(ref);
    }

    public void errorHandler(@Nonnull Ref ref) {
        throw new IllegalArgumentException("The given oldUse which should be replaced is not a current use of " + ref + "!");
    }
}

