/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.MutableBlockStmtGraph;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.LocalGenerator;
import sootup.core.jimple.basic.NoPositionInformation;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.Type;
import sootup.core.util.Copyable;
import sootup.core.util.EscapedWriter;
import sootup.core.util.ImmutableUtils;
import sootup.core.util.printer.JimplePrinter;
import sootup.core.validation.BodyValidator;
import sootup.core.validation.CheckEscapingValidator;
import sootup.core.validation.CheckInitValidator;
import sootup.core.validation.CheckTypesValidator;
import sootup.core.validation.CheckVoidLocalesValidator;
import sootup.core.validation.IdentityStatementsValidator;
import sootup.core.validation.LocalsValidator;
import sootup.core.validation.StmtsValidator;
import sootup.core.validation.TrapsValidator;
import sootup.core.validation.UsesValidator;
import sootup.core.validation.ValidationException;
import sootup.core.validation.ValuesValidator;

public class Body
implements Copyable {
    private final Set<Local> locals;
    @Nonnull
    private final StmtGraph<?> graph;
    @Nonnull
    private final Position position;
    @Nonnull
    private final MethodSignature methodSignature;
    @Nonnull
    private static final List<BodyValidator> validators = ImmutableUtils.immutableList(new LocalsValidator(), new TrapsValidator(), new StmtsValidator(), new UsesValidator(), new ValuesValidator(), new CheckInitValidator(), new CheckTypesValidator(), new CheckVoidLocalesValidator(), new CheckEscapingValidator());

    private Body(@Nonnull MethodSignature methodSignature, @Nonnull Set<Local> locals, @Nonnull StmtGraph<?> stmtGraph, @Nonnull Position position) {
        this.methodSignature = methodSignature;
        this.locals = Collections.unmodifiableSet(locals);
        this.graph = new MutableBlockStmtGraph(stmtGraph).unmodifiableStmtGraph();
        this.position = position;
        this.checkInit();
    }

    public static Local getThisLocal(StmtGraph<?> stmtGraph) {
        for (Stmt stmt : stmtGraph.nodes()) {
            if (!(stmt instanceof JIdentityStmt) || !(((JIdentityStmt)stmt).getRightOp() instanceof JThisRef)) continue;
            return (Local)((JIdentityStmt)stmt).getLeftOp();
        }
        throw new RuntimeException("couldn't find *this* assignment");
    }

    @Nonnull
    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    public int getLocalCount() {
        return this.locals.size();
    }

    private void runValidation(BodyValidator validator) {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        validator.validate(this, exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    public void validateValues() {
        this.runValidation(new ValuesValidator());
    }

    public void validateLocals() {
        this.runValidation(new LocalsValidator());
    }

    public void validateUses() {
        this.runValidation(new UsesValidator());
    }

    public Set<Local> getLocals() {
        return this.locals;
    }

    @Nonnull
    public List<Trap> getTraps() {
        return this.graph.getTraps();
    }

    @Nullable
    public Stmt getThisStmt() {
        for (Stmt u : this.getStmts()) {
            if (!(u instanceof JIdentityStmt) || !(((JIdentityStmt)u).getRightOp() instanceof JThisRef)) continue;
            return u;
        }
        return null;
    }

    @Nullable
    public Local getThisLocal() {
        JIdentityStmt thisStmt = (JIdentityStmt)this.getThisStmt();
        if (thisStmt == null) {
            return null;
        }
        return (Local)thisStmt.getLeftOp();
    }

    @Nullable
    public Local getParameterLocal(int i) {
        for (Stmt s2 : this.getStmts()) {
            JIdentityStmt idStmt;
            JParameterRef pr;
            if (!(s2 instanceof JIdentityStmt) || !(((JIdentityStmt)s2).getRightOp() instanceof JParameterRef) || (pr = (JParameterRef)(idStmt = (JIdentityStmt)s2).getRightOp()).getIndex() != i) continue;
            return (Local)idStmt.getLeftOp();
        }
        return null;
    }

    @Nonnull
    public Collection<Local> getParameterLocals() {
        ArrayList retVal = new ArrayList();
        for (Stmt u : this.graph.nodes()) {
            JIdentityStmt idStmt;
            if (!(u instanceof JIdentityStmt) || !((idStmt = (JIdentityStmt)u).getRightOp() instanceof JParameterRef)) continue;
            JParameterRef pr = (JParameterRef)idStmt.getRightOp();
            retVal.add(pr.getIndex(), idStmt.getLeftOp());
        }
        return Collections.unmodifiableCollection(retVal);
    }

    @Nonnull
    public List<Stmt> getStmts() {
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(this.graph.nodes().size());
        for (Stmt stmt : this.graph) {
            stmts.add(stmt);
        }
        return stmts;
    }

    @Nonnull
    public StmtGraph<?> getStmtGraph() {
        return this.graph;
    }

    private void checkInit() {
        this.runValidation(new CheckInitValidator());
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try (PrintWriter writerOut = new PrintWriter(new EscapedWriter(writer));){
            new JimplePrinter(new JimplePrinter.Option[0]).printTo(this, writerOut);
        }
        return writer.toString();
    }

    @Nonnull
    public Position getPosition() {
        return this.position;
    }

    @Nonnull
    public List<Stmt> getBranchTargetsOf(@Nonnull BranchingStmt fromStmt) {
        return this.getStmtGraph().getBranchTargetsOf(fromStmt);
    }

    public boolean isStmtBranchTarget(@Nonnull Stmt targetStmt) {
        return this.getStmtGraph().isStmtBranchTarget(targetStmt);
    }

    public void validateIdentityStatements() {
        this.runValidation(new IdentityStatementsValidator());
    }

    @Nonnull
    public Stmt getFirstNonIdentityStmt() {
        Iterator<Stmt> it = this.getStmts().iterator();
        Stmt o = null;
        while (it.hasNext() && (o = it.next()) instanceof JIdentityStmt) {
        }
        if (o == null) {
            throw new RuntimeException("no non-id statements!");
        }
        return o;
    }

    public Collection<Value> getUses() {
        ArrayList<Value> useList = new ArrayList<Value>();
        for (Stmt stmt : this.graph.nodes()) {
            useList.addAll(stmt.getUses());
        }
        return useList;
    }

    public Collection<Value> getDefs() {
        ArrayList<Value> defList = new ArrayList<Value>();
        for (Stmt stmt : this.graph.nodes()) {
            defList.addAll(stmt.getDefs());
        }
        return defList;
    }

    @Nonnull
    public Body withLocals(@Nonnull Set<Local> locals) {
        return new Body(this.getMethodSignature(), locals, this.getStmtGraph(), this.getPosition());
    }

    public static BodyBuilder builder() {
        return new BodyBuilder();
    }

    public static BodyBuilder builder(@Nonnull MutableStmtGraph graph) {
        return new BodyBuilder(graph);
    }

    public static BodyBuilder builder(@Nonnull Body body, Set<Modifier> modifiers) {
        return new BodyBuilder(body, modifiers);
    }

    public static class BodyBuilder {
        @Nonnull
        private Set<Local> locals = new LinkedHashSet<Local>();
        @Nonnull
        private final LocalGenerator localGen = new LocalGenerator(this.locals);
        @Nonnull
        private Set<Modifier> modifiers = Collections.emptySet();
        @Nullable
        private Position position = null;
        @Nonnull
        private final MutableStmtGraph graph;
        @Nullable
        private MethodSignature methodSig = null;
        @Nullable
        private List<Stmt> cachedLinearizedStmts = null;

        BodyBuilder() {
            this.graph = new MutableBlockStmtGraph();
        }

        BodyBuilder(@Nonnull MutableStmtGraph graph) {
            this.graph = graph;
        }

        BodyBuilder(@Nonnull Body body, @Nonnull Set<Modifier> modifiers) {
            this.setModifiers(modifiers);
            this.setMethodSignature(body.getMethodSignature());
            this.setLocals(body.getLocals());
            this.setPosition(body.getPosition());
            this.graph = new MutableBlockStmtGraph(body.getStmtGraph());
        }

        @Nonnull
        public MutableStmtGraph getStmtGraph() {
            return this.graph;
        }

        @Nonnull
        public List<Stmt> getStmts() {
            this.cachedLinearizedStmts = Lists.newArrayList(this.graph);
            return this.cachedLinearizedStmts;
        }

        @Nonnull
        public Set<Local> getLocals() {
            return Collections.unmodifiableSet(this.locals);
        }

        @Nonnull
        public BodyBuilder setStartingStmt(@Nonnull Stmt startingStmt) {
            this.graph.setStartingStmt(startingStmt);
            return this;
        }

        @Nonnull
        public BodyBuilder setLocals(@Nonnull Set<Local> locals) {
            this.locals = locals;
            return this;
        }

        @Nonnull
        public BodyBuilder addLocal(@Nonnull String name, Type type) {
            this.locals.add(this.localGen.generateLocal(type));
            return this;
        }

        @Nonnull
        public BodyBuilder addLocal(@Nonnull Local local) {
            this.locals.add(local);
            return this;
        }

        @Nonnull
        public BodyBuilder replaceStmt(@Nonnull Stmt oldStmt, @Nonnull Stmt newStmt) {
            this.graph.replaceNode(oldStmt, newStmt);
            return this;
        }

        @Nonnull
        public BodyBuilder removeStmt(@Nonnull Stmt stmt) {
            this.graph.removeNode(stmt);
            this.cachedLinearizedStmts = null;
            return this;
        }

        @Nonnull
        public BodyBuilder clearExceptionEdgesOf(@Nonnull Stmt stmt) {
            this.graph.clearExceptionalEdges(stmt);
            return this;
        }

        @Nonnull
        @Deprecated
        public List<Trap> getTraps() {
            return this.graph.getTraps();
        }

        @Nonnull
        public BodyBuilder addFlow(@Nonnull Stmt fromStmt, @Nonnull Stmt toStmt) {
            this.graph.putEdge(fromStmt, toStmt);
            this.cachedLinearizedStmts = null;
            return this;
        }

        @Nonnull
        public BodyBuilder removeFlow(@Nonnull Stmt fromStmt, @Nonnull Stmt toStmt) {
            this.graph.removeEdge(fromStmt, toStmt);
            this.cachedLinearizedStmts = null;
            return this;
        }

        public BodyBuilder setModifiers(@Nonnull Set<Modifier> modifiers) {
            this.modifiers = modifiers;
            return this;
        }

        @Nonnull
        public BodyBuilder setPosition(@Nonnull Position position) {
            this.position = position;
            return this;
        }

        public BodyBuilder setMethodSignature(MethodSignature methodSig) {
            this.methodSig = methodSig;
            return this;
        }

        @Nonnull
        public Body build() {
            if (this.methodSig == null) {
                throw new RuntimeException("There is no MethodSignature set.");
            }
            if (this.position == null) {
                this.setPosition(NoPositionInformation.getInstance());
            }
            Stmt startingStmt = this.graph.getStartingStmt();
            Collection<Stmt> nodes = this.graph.nodes();
            if (nodes.size() > 0 && !nodes.contains(startingStmt)) {
                throw new IllegalStateException(this.methodSig + ": The given startingStmt '" + startingStmt + "' does not exist in the StmtGraph.");
            }
            try {
                this.graph.validateStmtConnectionsInGraph();
            }
            catch (Exception e) {
                throw new RuntimeException("StmtGraph of " + this.methodSig + " is invalid.", e);
            }
            return new Body(this.methodSig, this.locals, this.graph, this.position);
        }

        @Nonnull
        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        public String toString() {
            if (this.methodSig != null) {
                return "BodyBuilder for " + this.methodSig;
            }
            return super.toString();
        }
    }
}

