/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BuilderException
extends IllegalStateException {
    @Nonnull
    private final Class<?> _builderClass;
    @Nonnull
    private final Class<?> _buildableClass;

    public BuilderException(@Nonnull Class<?> builderClass, @Nonnull Class<?> buildableClass) {
        this(builderClass, buildableClass, null);
    }

    public BuilderException(@Nonnull Class<?> builderClass, @Nonnull Class<?> buildableClass, @Nullable Throwable cause) {
        super(BuilderException.makeMessage(builderClass, buildableClass, cause), cause);
        this._builderClass = builderClass;
        this._buildableClass = buildableClass;
    }

    @Nonnull
    public Class<?> getBuilderClass() {
        return this._builderClass;
    }

    @Nonnull
    public Class<?> getBuildableClass() {
        return this._buildableClass;
    }

    @Nonnull
    private static String makeMessage(@Nonnull Class<?> builderClass, @Nonnull Class<?> buildableClass, @Nullable Throwable cause) {
        return "A builder exception occurred" + (cause != null ? ":\n\n" + cause.getMessage() : ".") + "\n\nBuilder class:   " + builderClass.getName() + "\nBuildable class: " + buildableClass.getName();
    }
}

