/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public enum Modifier {
    PUBLIC(1),
    PRIVATE(2),
    PROTECTED(4),
    ABSTRACT(1024),
    STATIC(8),
    FINAL(16),
    SYNCHRONIZED(32),
    NATIVE(256),
    TRANSIENT(128),
    VOLATILE(64),
    STRICTFP(2048),
    ANNOTATION(8192),
    ENUM(16384),
    INTERFACE(512),
    MODULE(32768),
    SYNTHETIC(4096),
    CONSTRUCTOR(65536),
    DECLARED_SYNCHRONIZED(131072);

    private final int bytecode;

    private Modifier(int i) {
        this.bytecode = i;
    }

    public static boolean isAbstract(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)ABSTRACT);
    }

    public static boolean isFinal(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)FINAL);
    }

    public static boolean isInterface(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)INTERFACE);
    }

    public static boolean isNative(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)NATIVE);
    }

    public static boolean isPrivate(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)PRIVATE);
    }

    public static boolean isProtected(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)PROTECTED);
    }

    public static boolean isPublic(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)PUBLIC);
    }

    public static boolean isStatic(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)STATIC);
    }

    public static boolean isSynchronized(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)SYNCHRONIZED);
    }

    public static boolean isTransient(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)TRANSIENT);
    }

    public static boolean isVolatile(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)VOLATILE);
    }

    public static boolean isStrictFP(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)STRICTFP);
    }

    public static boolean isAnnotation(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)ANNOTATION);
    }

    public static boolean isEnum(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)ENUM);
    }

    public static boolean isSynthetic(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)SYNTHETIC);
    }

    public static boolean isConstructor(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)CONSTRUCTOR);
    }

    public static boolean isDeclaredSynchronized(@Nonnull Set<Modifier> m3) {
        return m3.contains((Object)DECLARED_SYNCHRONIZED);
    }

    @Nonnull
    public static String toString(@Nonnull Set<Modifier> m3) {
        int lastCharPos;
        StringBuilder builder = new StringBuilder();
        if (Modifier.isPublic(m3)) {
            builder.append("public ");
        } else if (Modifier.isPrivate(m3)) {
            builder.append("private ");
        } else if (Modifier.isProtected(m3)) {
            builder.append("protected ");
        }
        if (Modifier.isAbstract(m3)) {
            builder.append("abstract ");
        }
        if (Modifier.isStatic(m3)) {
            builder.append("static ");
        }
        if (Modifier.isFinal(m3)) {
            builder.append("final ");
        }
        if (Modifier.isSynchronized(m3)) {
            builder.append("synchronized ");
        }
        if (Modifier.isNative(m3)) {
            builder.append("native ");
        }
        if (Modifier.isTransient(m3)) {
            builder.append("transient ");
        }
        if (Modifier.isVolatile(m3)) {
            builder.append("volatile ");
        }
        if (Modifier.isStrictFP(m3)) {
            builder.append("strictfp ");
        }
        if (Modifier.isAnnotation(m3)) {
            builder.append("annotation ");
        }
        if (Modifier.isEnum(m3)) {
            builder.append("enum ");
        }
        if (Modifier.isInterface(m3)) {
            builder.append("interface ");
        }
        if ((lastCharPos = builder.length() - 1) > 0) {
            builder.setLength(lastCharPos);
        }
        return builder.toString();
    }

    @Nonnull
    public static String toString(@Nonnull EnumSet<Modifier> m3) {
        return m3.stream().map(mod -> mod.name().toLowerCase()).collect(Collectors.joining(" "));
    }

    public int getBytecode() {
        return this.bytecode;
    }
}

