/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.model;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.signatures.SootClassMemberSignature;
import sootup.core.types.ClassType;
import sootup.core.util.ImmutableUtils;

public abstract class SootClassMember<S extends SootClassMemberSignature> {
    @Nonnull
    private final S signature;
    @Nonnull
    private final ImmutableSet<Modifier> modifiers;
    @Nonnull
    private final Position position;

    SootClassMember(@Nonnull S signature, @Nonnull Iterable<Modifier> modifiers, @Nonnull Position position) {
        this.signature = signature;
        this.modifiers = ImmutableUtils.immutableEnumSetOf(modifiers);
        this.position = position;
    }

    @Nonnull
    public ClassType getDeclaringClassType() {
        return ((SootClassMemberSignature)this.signature).getDeclClassType();
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Nonnull
    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public int equivHashCode() {
        return Objects.hash(this.modifiers, this.signature);
    }

    @Nonnull
    public String toString() {
        return ((SootClassMemberSignature)this.signature).toString();
    }

    @Nonnull
    public S getSignature() {
        return this.signature;
    }

    @Nonnull
    public String getName() {
        return ((SootClassMemberSignature)this.signature).getName();
    }

    @Nonnull
    public Position getPosition() {
        return this.position;
    }
}

