/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.signatures;

import com.google.common.base.Objects;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.jimple.Jimple;
import sootup.core.types.Type;
import sootup.core.util.printer.StmtPrinter;

public abstract class SootClassMemberSubSignature {
    @Nonnull
    private final String name;
    @Nonnull
    private final Type type;
    private final Supplier<String> _cachedToString = Suppliers.memoize(() -> String.format("%s %s", Jimple.escape(this.getType().toString()), Jimple.escape(this.getName())));

    protected SootClassMemberSubSignature(@Nonnull String name, @Nonnull Type type) {
        this.name = name;
        this.type = type;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SootClassMemberSubSignature that = (SootClassMemberSubSignature)o;
        return Objects.equal(this.getName(), that.getName()) && Objects.equal(this.getType(), that.getType());
    }

    public int hashCode() {
        return Objects.hashCode(this.getName(), this.getType());
    }

    protected int compareTo(@Nonnull SootClassMemberSubSignature o) {
        int r = this.getName().compareTo(o.getName());
        if (r != 0) {
            return r;
        }
        return this.getType().toString().compareTo(o.getType().toString());
    }

    @Nonnull
    public String toString() {
        return this._cachedToString.get();
    }

    public abstract void toString(StmtPrinter var1);
}

