/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util.printer;

import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.ref.JParameterRef;
import sootup.core.jimple.common.ref.JThisRef;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.util.printer.LabeledStmtPrinter;

public class BriefStmtPrinter
extends LabeledStmtPrinter {
    private boolean eatSpace = false;

    @Override
    public void method(SootMethod m3) {
        this.handleIndent();
        if (m3.isStatic()) {
            this.output.append(m3.getDeclaringClassType().getFullyQualifiedName());
            this.output.append(".");
        }
        this.output.append(((MethodSignature)m3.getSignature()).getName());
    }

    @Override
    public void field(SootField f) {
        this.handleIndent();
        if (f.isStatic()) {
            this.output.append(f.getDeclaringClassType().getFullyQualifiedName());
            this.output.append(".");
        }
        this.output.append(((FieldSignature)f.getSignature()).getName());
    }

    @Override
    public void identityRef(IdentityRef r) {
        this.handleIndent();
        if (r instanceof JThisRef) {
            this.output.append("@this");
        } else if (r instanceof JParameterRef) {
            JParameterRef pr = (JParameterRef)r;
            this.output.append("@parameter").append(pr.getIndex());
        } else if (r instanceof JCaughtExceptionRef) {
            this.output.append("@caughtexception");
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public void literal(String s2) {
        if (this.eatSpace && s2.equals(" ")) {
            this.eatSpace = false;
            return;
        }
        this.eatSpace = false;
        if (s2.equals("staticinvoke") || s2.equals("virtualinvoke") || s2.equals("interfaceinvoke")) {
            this.eatSpace = true;
            return;
        }
        this.output.append(s2);
    }
}

