/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.validation;

import java.util.List;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.model.Body;
import sootup.core.validation.BodyValidator;
import sootup.core.validation.ValidationException;

public class LocalsValidator
implements BodyValidator {
    @Override
    public void validate(Body body, List<ValidationException> exception) {
        for (Value v : body.getUses()) {
            this.validateLocal(body, v, exception);
        }
        for (Value v : body.getDefs()) {
            this.validateLocal(body, v, exception);
        }
    }

    private void validateLocal(Body body, Value v, List<ValidationException> exception) {
        Value value = v;
        if (value instanceof Local && !body.getLocals().contains(value)) {
            exception.add(new ValidationException(value, "Local not in chain : " + value + " in " + body.getMethodSignature()));
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

