/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import sootup.core.frontend.ResolveException;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.model.Modifier;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.VoidType;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.ConstantUtil;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.ModuleModifier;
import sootup.java.core.language.JavaJimple;
import sootup.java.core.types.AnnotationType;
import sootup.java.core.types.JavaClassType;

public final class AsmUtil {
    public static final int SUPPORTED_ASM_OPCODE = 589824;

    private AsmUtil() {
    }

    protected static void initAsmClassSource(@Nonnull Path classSource, @Nonnull ClassVisitor classNode) throws IOException {
        try (InputStream sourceFileInputStream = Files.newInputStream(classSource, new OpenOption[0]);){
            ClassReader clsr = new ClassReader(sourceFileInputStream);
            clsr.accept(classNode, 4);
        }
    }

    public static boolean isDWord(@Nonnull Type type) {
        return type == PrimitiveType.getLong() || type == PrimitiveType.getDouble();
    }

    public static String toQualifiedName(@Nonnull String str) {
        int endpos = str.length() - 1;
        if (endpos > 2 && str.charAt(endpos) == ';' && str.charAt(0) == 'L') {
            str = str.substring(1, endpos);
        }
        return str.replace('/', '.');
    }

    public static EnumSet<Modifier> getModifiers(int access) {
        EnumSet<Modifier> modifierEnumSet = EnumSet.noneOf(Modifier.class);
        for (Modifier modifier : Modifier.values()) {
            if ((access & modifier.getBytecode()) == 0) continue;
            modifierEnumSet.add(modifier);
        }
        return modifierEnumSet;
    }

    public static EnumSet<ModuleModifier> getModuleModifiers(int access) {
        EnumSet<ModuleModifier> modifierEnumSet = EnumSet.noneOf(ModuleModifier.class);
        for (ModuleModifier modifier : ModuleModifier.values()) {
            if ((access & modifier.getBytecode()) == 0) continue;
            modifierEnumSet.add(modifier);
        }
        return modifierEnumSet;
    }

    @Nonnull
    public static Collection<JavaClassType> asmIdToSignature(@Nullable Iterable<String> asmClassNames) {
        if (asmClassNames == null) {
            return Collections.emptyList();
        }
        return StreamSupport.stream(asmClassNames.spliterator(), false).map(AsmUtil::toJimpleClassType).collect(Collectors.toList());
    }

    @Nonnull
    public static JavaClassType toJimpleClassType(@Nonnull String asmClassName) {
        return JavaIdentifierFactory.getInstance().getClassType(AsmUtil.toQualifiedName(asmClassName));
    }

    public static Type toJimpleSignature(@Nonnull String desc) {
        return desc.charAt(0) == '[' ? AsmUtil.toJimpleType(desc) : JavaIdentifierFactory.getInstance().getClassType(AsmUtil.toQualifiedName(desc));
    }

    @Nonnull
    public static Type toJimpleType(@Nonnull String desc) {
        Type baseType;
        int idx = desc.lastIndexOf(91);
        int nrDims = idx + 1;
        if (nrDims > 0) {
            if (desc.charAt(0) != '[') {
                throw new AssertionError((Object)("Invalid array descriptor: " + desc));
            }
            desc = desc.substring(idx + 1);
        }
        switch (desc.charAt(0)) {
            case 'Z': {
                baseType = PrimitiveType.getBoolean();
                break;
            }
            case 'B': {
                baseType = PrimitiveType.getByte();
                break;
            }
            case 'C': {
                baseType = PrimitiveType.getChar();
                break;
            }
            case 'S': {
                baseType = PrimitiveType.getShort();
                break;
            }
            case 'I': {
                baseType = PrimitiveType.getInt();
                break;
            }
            case 'F': {
                baseType = PrimitiveType.getFloat();
                break;
            }
            case 'J': {
                baseType = PrimitiveType.getLong();
                break;
            }
            case 'D': {
                baseType = PrimitiveType.getDouble();
                break;
            }
            case 'V': {
                baseType = VoidType.getInstance();
                break;
            }
            case 'L': {
                if (desc.charAt(desc.length() - 1) != ';') {
                    throw new AssertionError((Object)("Invalid reference descriptor: " + desc));
                }
                String name = desc.substring(1, desc.length() - 1);
                name = AsmUtil.toQualifiedName(name);
                baseType = JavaIdentifierFactory.getInstance().getType(AsmUtil.toQualifiedName(name));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown descriptor: " + desc));
            }
        }
        if (!(baseType instanceof JavaClassType) && desc.length() > 1) {
            throw new AssertionError((Object)("Invalid primitive type descriptor: " + desc));
        }
        return nrDims > 0 ? JavaIdentifierFactory.getInstance().getArrayType(baseType, nrDims) : baseType;
    }

    @Nonnull
    public static List<Type> toJimpleSignatureDesc(@Nonnull String desc) {
        ArrayList<Type> types = new ArrayList<Type>(1);
        int len = desc.length();
        int idx = 0;
        block14: while (idx != len) {
            int nrDims = 0;
            Type baseType = null;
            block15: while (idx != len) {
                char c = desc.charAt(idx++);
                switch (c) {
                    case '(': 
                    case ')': {
                        continue block14;
                    }
                    case '[': {
                        ++nrDims;
                        continue block15;
                    }
                    case 'Z': {
                        baseType = PrimitiveType.getBoolean();
                        break block15;
                    }
                    case 'B': {
                        baseType = PrimitiveType.getByte();
                        break block15;
                    }
                    case 'C': {
                        baseType = PrimitiveType.getChar();
                        break block15;
                    }
                    case 'S': {
                        baseType = PrimitiveType.getShort();
                        break block15;
                    }
                    case 'I': {
                        baseType = PrimitiveType.getInt();
                        break block15;
                    }
                    case 'F': {
                        baseType = PrimitiveType.getFloat();
                        break block15;
                    }
                    case 'J': {
                        baseType = PrimitiveType.getLong();
                        break block15;
                    }
                    case 'D': {
                        baseType = PrimitiveType.getDouble();
                        break block15;
                    }
                    case 'V': {
                        baseType = VoidType.getInstance();
                        break block15;
                    }
                    case 'L': {
                        int begin = idx;
                        idx = desc.indexOf(59, begin);
                        String cls = desc.substring(begin, idx++);
                        baseType = JavaIdentifierFactory.getInstance().getType(AsmUtil.toQualifiedName(cls));
                        break block15;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown type: '" + c + "' in '" + desc + "'."));
                    }
                }
            }
            if (baseType != null && nrDims > 0) {
                types.add(JavaIdentifierFactory.getInstance().getArrayType(baseType, nrDims));
                continue;
            }
            types.add(baseType);
        }
        return types;
    }

    public static String toString(AbstractInsnNode insn) {
        Textifier printer = new Textifier();
        TraceMethodVisitor mp = new TraceMethodVisitor(printer);
        insn.accept(mp);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        return Arrays.stream(sw.toString().split("\n")).filter(line -> !line.trim().isEmpty()).reduce("", String::concat);
    }

    public static Iterable<AnnotationUsage> createAnnotationUsage(List<AnnotationNode> invisibleParameterAnnotation) {
        if (invisibleParameterAnnotation == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationUsage> annotationUsages = new ArrayList<AnnotationUsage>();
        for (AnnotationNode e : invisibleParameterAnnotation) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (e.values != null) {
                for (int j = 0; j < e.values.size(); ++j) {
                    Object annotationValue;
                    String annotationName = (String)e.values.get(j);
                    if ((annotationValue = e.values.get(++j)) instanceof ArrayList && !((ArrayList)annotationValue).isEmpty() && ((ArrayList)annotationValue).get(0) instanceof AnnotationNode) {
                        ArrayList annotationValueList = (ArrayList)annotationValue;
                        paramMap.put(annotationName, AsmUtil.createAnnotationUsage(annotationValueList));
                        continue;
                    }
                    if (annotationValue instanceof ArrayList) {
                        paramMap.put(annotationName, ((ArrayList)annotationValue).stream().map(AsmUtil::convertAnnotationValue).collect(Collectors.toList()));
                        continue;
                    }
                    paramMap.put(annotationName, AsmUtil.convertAnnotationValue(annotationValue));
                }
            }
            AnnotationType at = JavaIdentifierFactory.getInstance().getAnnotationType(AsmUtil.toQualifiedName(e.desc));
            annotationUsages.add(new AnnotationUsage(at, paramMap));
        }
        return annotationUsages;
    }

    public static Object convertAnnotationValue(Object annotationValue) {
        if (annotationValue instanceof String[]) {
            String[] enumData = (String[])annotationValue;
            enumData[0] = AsmUtil.toQualifiedName(enumData[0]);
            return ConstantUtil.fromObject(enumData);
        }
        if (annotationValue instanceof org.objectweb.asm.Type) {
            ClassConstant classConstant = JavaJimple.getInstance().newClassConstant(((org.objectweb.asm.Type)annotationValue).toString());
            return ConstantUtil.fromObject(classConstant);
        }
        return ConstantUtil.fromObject(annotationValue);
    }

    @Nonnull
    public static ClassNode getModuleDescriptor(Path moduleInfoFile) {
        ClassNode moduleDescriptor;
        try (InputStream sourceFileInputStream = Files.newInputStream(moduleInfoFile, new OpenOption[0]);){
            ClassReader clsr = new ClassReader(sourceFileInputStream);
            moduleDescriptor = new ClassNode(589824);
            clsr.accept(moduleDescriptor, 4);
        }
        catch (IOException e) {
            throw new ResolveException("Error loading the module-descriptor", moduleInfoFile, e);
        }
        return moduleDescriptor;
    }
}

