/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ReplaceUseStmtVisitor;
import sootup.java.bytecode.frontend.AsmMethodSource;

class Operand {
    static final Operand DWORD_DUMMY = new Operand(null, null, null);
    @Nonnull
    protected final AbstractInsnNode insn;
    @Nonnull
    protected final Value value;
    @Nullable
    protected Local stackLocal;
    @Nonnull
    private final AsmMethodSource methodSource;
    @Nonnull
    private final List<Stmt> usedByStmts = new ArrayList<Stmt>();
    @Nonnull
    private final List<Expr> usedByExpr = new ArrayList<Expr>();

    Operand(@Nonnull AbstractInsnNode insn, @Nonnull Value value, @Nonnull AsmMethodSource methodSource) {
        this.insn = insn;
        this.value = value;
        this.methodSource = methodSource;
    }

    void addUsageInStmt(@Nonnull Stmt stmt) {
        this.usedByStmts.add(stmt);
    }

    void addUsageInExpr(@Nonnull Expr expr) {
        this.usedByExpr.add(expr);
    }

    void updateUsages() {
        for (Expr exprUsage : this.usedByExpr) {
            this.methodSource.getStmtsThatUse(exprUsage).map(this.methodSource::getLatestVersionOfStmt).filter(stmt -> !this.usedByStmts.contains(stmt)).forEach(this.usedByStmts::add);
        }
        if (this.value == this.stackOrValue()) {
            return;
        }
        ReplaceUseStmtVisitor replaceStmtVisitor = new ReplaceUseStmtVisitor(this.value, this.stackOrValue());
        ArrayList stmtsToDelete = new ArrayList();
        for (int i = 0; i < this.usedByStmts.size(); ++i) {
            Stmt oldUsage = this.usedByStmts.get(i);
            oldUsage = this.methodSource.getLatestVersionOfStmt(oldUsage);
            oldUsage.accept(replaceStmtVisitor);
            Stmt newUsage = (Stmt)replaceStmtVisitor.getResult();
            if (oldUsage == newUsage) continue;
            this.methodSource.replaceStmt(oldUsage, newUsage);
            this.usedByStmts.set(i, newUsage);
        }
        this.usedByStmts.removeAll(stmtsToDelete);
    }

    @Nonnull
    Value stackOrValue() {
        return this.stackLocal == null ? this.value : this.stackLocal;
    }

    boolean equivTo(@Nonnull Operand other) {
        return this == other || this == DWORD_DUMMY == (other == DWORD_DUMMY) && this.stackOrValue().equivTo(other.stackOrValue());
    }

    public String toString() {
        return "Operand{insn=" + this.insn + ", value=" + this.value + ", stack=" + this.stackLocal + '}';
    }

    @Nonnull
    public AbstractInsnNode getInsn() {
        return this.insn;
    }

    @Nonnull
    public Value getValue() {
        return this.value;
    }

    @Nullable
    public Local getStackLocal() {
        return this.stackLocal;
    }

    public boolean equals(Object other) {
        return other instanceof Operand && this.equivTo((Operand)other);
    }
}

