/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;

public class CastAndReturnInliner
implements BodyInterceptor {
    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        MutableStmtGraph originalGraph = builder.getStmtGraph();
        for (Stmt stmt : Lists.newArrayList(originalGraph.nodes())) {
            JReturnStmt retStmt;
            Stmt nextStmt;
            JAssignStmt assign;
            JGotoStmt gotoStmt;
            Stmt successorOfGoto;
            if (!(stmt instanceof JGotoStmt) || !((successorOfGoto = originalGraph.successors(gotoStmt = (JGotoStmt)stmt).get(0)) instanceof JAssignStmt) || !((assign = (JAssignStmt)successorOfGoto).getRightOp() instanceof JCastExpr) || !((nextStmt = originalGraph.successors(assign).get(0)) instanceof JReturnStmt) || (retStmt = (JReturnStmt)nextStmt).getOp() != assign.getLeftOp()) continue;
            JCastExpr ce = (JCastExpr)assign.getRightOp();
            JReturnStmt newStmt = retStmt.withReturnValue(ce.getOp());
            builder.replaceStmt(gotoStmt, newStmt);
            builder.removeStmt(assign);
            builder.removeStmt(retStmt);
        }
    }
}

