/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.java.bytecode.interceptors.Evaluator;

public class ConditionalBranchFolder
implements BodyInterceptor {
    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        for (Stmt stmt : Lists.newArrayList(stmtGraph.nodes())) {
            Stmt neverReachedSucessor;
            Stmt tautologicSuccessor;
            JIfStmt ifStmt;
            Constant evaluatedCondition;
            if (!(stmt instanceof JIfStmt) || (evaluatedCondition = Evaluator.getConstantValueOf((ifStmt = (JIfStmt)stmt).getCondition())) == null) continue;
            List<Stmt> ifSuccessors = stmtGraph.successors(ifStmt);
            if (((IntConstant)evaluatedCondition).getValue() == 1) {
                tautologicSuccessor = ifSuccessors.get(0);
                neverReachedSucessor = ifSuccessors.get(1);
            } else {
                if (((IntConstant)evaluatedCondition).getValue() != 0) continue;
                tautologicSuccessor = ifSuccessors.get(1);
                neverReachedSucessor = ifSuccessors.get(0);
            }
            for (Stmt predecessor : stmtGraph.predecessors(ifStmt)) {
                builder.removeFlow(predecessor, ifStmt);
                builder.addFlow(predecessor, tautologicSuccessor);
            }
            builder.removeFlow(ifStmt, tautologicSuccessor);
            builder.removeFlow(ifStmt, neverReachedSucessor);
            builder.removeStmt(ifStmt);
            this.pruneExclusivelyReachableStmts(stmtGraph, neverReachedSucessor);
        }
    }

    private void pruneExclusivelyReachableStmts(@Nonnull MutableStmtGraph stmtGraph, @Nonnull Stmt fallsThroughStmt) {
        Stmt itStmt;
        HashSet<Stmt> reachedBranchingStmts = new HashSet<Stmt>();
        ArrayDeque<Stmt> q = new ArrayDeque<Stmt>();
        q.addFirst(fallsThroughStmt);
        while (!q.isEmpty()) {
            List<Stmt> predecessors;
            itStmt = (Stmt)q.pollFirst();
            if (itStmt.branches()) {
                reachedBranchingStmts.add(itStmt);
            }
            if (!stmtGraph.containsNode(itStmt) || (predecessors = stmtGraph.predecessors(itStmt)).size() > 1) continue;
            q.addAll(stmtGraph.successors(itStmt));
        }
        q.addFirst(fallsThroughStmt);
        while (!q.isEmpty()) {
            itStmt = (Stmt)q.pollFirst();
            if (!stmtGraph.containsNode(itStmt) || !this.isExclusivelyReachable(stmtGraph, itStmt, reachedBranchingStmts)) continue;
            q.addAll(stmtGraph.successors(itStmt));
            stmtGraph.removeNode(itStmt);
        }
    }

    private boolean isExclusivelyReachable(@Nonnull StmtGraph<?> graph, @Nonnull Stmt stmt, @Nonnull Set<Stmt> reachedStmts) {
        int predecessorSize;
        List<Stmt> predecessors = graph.predecessors(stmt);
        int amount = predecessorSize = predecessors.size();
        if (predecessorSize <= 1) {
            return true;
        }
        for (Stmt predecessor : predecessors) {
            if (predecessor.fallsThrough()) {
                if (predecessor instanceof JIfStmt) {
                    List<Stmt> predsSuccessors = graph.successors(predecessor);
                    if (predsSuccessors.size() > 0 && predsSuccessors.get(0) == stmt) {
                        --amount;
                        continue;
                    }
                } else {
                    --amount;
                    continue;
                }
            }
            if (!reachedStmts.contains(predecessor)) continue;
            --amount;
        }
        return amount == 0;
    }
}

