/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.BodyUtils;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ReferenceType;

public class CopyPropagator
implements BodyInterceptor {
    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        for (Stmt stmt : Lists.newArrayList(stmtGraph)) {
            for (Value use : stmt.getUses()) {
                List<Stmt> defsOfUse;
                if (!(use instanceof Local) || !this.isPropagable(defsOfUse = BodyUtils.getDefsForLocalUse(stmtGraph, (Local)use, stmt))) continue;
                AbstractDefinitionStmt defStmt = (AbstractDefinitionStmt)defsOfUse.get(0);
                Object rhs = defStmt.getRightOp();
                if (rhs instanceof Constant) {
                    this.replaceUse(builder, stmt, use, (Value)rhs);
                    continue;
                }
                if (rhs instanceof JCastExpr && rhs.getType() instanceof ReferenceType) {
                    Immediate op = ((JCastExpr)rhs).getOp();
                    if ((!(op instanceof IntConstant) || !op.equals(IntConstant.getInstance(0))) && (!(op instanceof LongConstant) || !op.equals(LongConstant.getInstance(0L)))) continue;
                    this.replaceUse(builder, stmt, use, NullConstant.getInstance());
                    continue;
                }
                if (!(rhs instanceof Local) || rhs.equivTo(use)) continue;
                this.replaceUse(builder, stmt, use, (Value)rhs);
            }
        }
    }

    private void replaceUse(@Nonnull Body.BodyBuilder builder, @Nonnull Stmt stmt, Value use, Value rhs) {
        Stmt newStmt = BodyUtils.withNewUse(stmt, use, rhs);
        if (!stmt.equivTo(newStmt)) {
            builder.replaceStmt(stmt, newStmt);
        }
    }

    private boolean isPropagable(List<Stmt> defsOfUse) {
        boolean isPropagateable = false;
        if (defsOfUse.size() == 1) {
            isPropagateable = true;
        } else if (defsOfUse.size() > 1) {
            Constant con = null;
            for (Stmt defStmt : defsOfUse) {
                if (defStmt instanceof JAssignStmt && ((JAssignStmt)defStmt).getRightOp() instanceof Constant) {
                    Constant rhs = (Constant)((JAssignStmt)defStmt).getRightOp();
                    if (con == null) {
                        con = rhs;
                        continue;
                    }
                    if (rhs.equals(con)) {
                        isPropagateable = true;
                        continue;
                    }
                    isPropagateable = false;
                    break;
                }
                isPropagateable = false;
                break;
            }
        }
        return isPropagateable;
    }
}

