/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JDivExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JRemExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.BodyUtils;
import sootup.core.model.Modifier;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;

public class DeadAssignmentEliminator
implements BodyInterceptor {
    boolean eliminateOnlyStackLocals;
    Map<Local, List<Stmt>> allDefs = new HashMap<Local, List<Stmt>>();
    Map<Local, List<Stmt>> allUses = new HashMap<Local, List<Stmt>>();

    public DeadAssignmentEliminator() {
        this(false);
    }

    public DeadAssignmentEliminator(boolean eliminateOnlyStackLocals) {
        this.eliminateOnlyStackLocals = eliminateOnlyStackLocals;
    }

    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        JAssignStmt assignStmt;
        Stmt stmt;
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        List<Stmt> stmts = builder.getStmts();
        ArrayDeque<Stmt> deque = new ArrayDeque<Stmt>(stmts.size());
        boolean isStatic = Modifier.isStatic(builder.getModifiers());
        boolean allEssential = true;
        boolean containsInvoke = false;
        Local thisLocal = null;
        Iterator<Stmt> iterator = stmtGraph.nodes().iterator();
        while (iterator.hasNext()) {
            stmt = iterator.next();
            boolean isEssential = true;
            if (stmt instanceof JAssignStmt) {
                Object rhs;
                assignStmt = (JAssignStmt)stmt;
                Object lhs = assignStmt.getLeftOp();
                if (lhs == (rhs = assignStmt.getRightOp()) && lhs instanceof Local) {
                    iterator.remove();
                    continue;
                }
                if (lhs instanceof Local && (!this.eliminateOnlyStackLocals || ((Local)lhs).getName().startsWith("$") || lhs.getType() instanceof NullType)) {
                    isEssential = false;
                    if (!containsInvoke) {
                        containsInvoke = assignStmt.containsInvokeExpr();
                    }
                    if (rhs instanceof JCastExpr) {
                        JCastExpr castExpr = (JCastExpr)rhs;
                        Type type = castExpr.getType();
                        Immediate value = castExpr.getOp();
                        isEssential = !(value instanceof NullConstant) && type instanceof ReferenceType;
                    } else if (rhs instanceof AbstractInvokeExpr || rhs instanceof JArrayRef || rhs instanceof JNewExpr || rhs instanceof JNewArrayExpr || rhs instanceof JNewMultiArrayExpr) {
                        isEssential = true;
                    } else if (rhs instanceof JFieldRef) {
                        isEssential = true;
                        if (rhs instanceof JInstanceFieldRef) {
                            JInstanceFieldRef instanceFieldRef = (JInstanceFieldRef)rhs;
                            if (!isStatic && thisLocal == null) {
                                thisLocal = Body.getThisLocal(stmtGraph);
                            }
                            isEssential = isStatic || thisLocal != instanceFieldRef.getBase();
                        }
                    } else if (rhs instanceof JDivExpr || rhs instanceof JRemExpr) {
                        AbstractBinopExpr expr = (AbstractBinopExpr)rhs;
                        Type type1 = expr.getOp1().getType();
                        Type type2 = expr.getOp2().getType();
                        boolean type2Int = type2 instanceof PrimitiveType && type2.equals(PrimitiveType.getInt());
                        boolean bl = isEssential = type2Int || type1 instanceof PrimitiveType && (type1.equals(PrimitiveType.getInt()) || type1.equals(PrimitiveType.getLong())) || type2 instanceof PrimitiveType && type2.equals(PrimitiveType.getLong()) || type1 instanceof UnknownType || type2 instanceof UnknownType;
                        if (isEssential && type2Int) {
                            IntConstant intConstant;
                            Immediate value = expr.getOp2();
                            isEssential = value instanceof IntConstant ? (intConstant = (IntConstant)value).getValue() == 0 : true;
                        }
                    }
                }
            }
            if (isEssential) {
                deque.addFirst(stmt);
            }
            allEssential &= isEssential;
        }
        if (containsInvoke || !allEssential) {
            this.allDefs = BodyUtils.collectDefs(builder.getStmts());
            if (!allEssential) {
                HashSet<Stmt> essentialStmts = new HashSet<Stmt>(stmts.size());
                while (!deque.isEmpty()) {
                    stmt = (Stmt)deque.removeFirst();
                    if (!essentialStmts.add(stmt)) continue;
                    for (Value value : stmt.getUses()) {
                        Local local;
                        List<Stmt> defs;
                        if (!(value instanceof Local) || (defs = this.allDefs.get(local = (Local)value)) == null) continue;
                        deque.addAll(defs);
                    }
                }
                for (Stmt stmt2 : stmts) {
                    if (essentialStmts.contains(stmt2)) continue;
                    builder.removeStmt(stmt2);
                }
            }
            if (containsInvoke) {
                this.allUses = BodyUtils.collectUses(builder.getStmts());
                ArrayList<JAssignStmt> postProcess = new ArrayList<JAssignStmt>();
                for (Stmt stmt3 : stmts) {
                    if (!(stmt3 instanceof JAssignStmt) || !(assignStmt = (JAssignStmt)stmt3).containsInvokeExpr()) continue;
                    boolean deadAssignment = true;
                    Local local = (Local)assignStmt.getRightOp();
                    for (Stmt use : this.allUses.get(local)) {
                        if (!builder.getStmts().contains(use)) continue;
                        deadAssignment = false;
                        break;
                    }
                    if (!deadAssignment) continue;
                    postProcess.add(assignStmt);
                }
                for (JAssignStmt assignStmt2 : postProcess) {
                    JInvokeStmt newInvoke = Jimple.newInvokeStmt(assignStmt2.getInvokeExpr(), assignStmt2.getPositionInfo());
                    builder.replaceStmt(assignStmt2, newInvoke);
                }
            }
        }
    }
}

