/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.BodyUtils;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;

public class LocalSplitter
implements BodyInterceptor {
    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        List<Stmt> stmts = builder.getStmts();
        LinkedHashSet<Local> visitedLocals = new LinkedHashSet<Local>();
        LinkedHashSet<Local> toSplitLocals = new LinkedHashSet<Local>();
        for (Stmt stmt : stmts) {
            Value def;
            List<Value> defs = stmt.getDefs();
            if (defs.isEmpty() || !((def = defs.get(0)) instanceof Local)) continue;
            if (visitedLocals.contains(def)) {
                toSplitLocals.add((Local)def);
            }
            visitedLocals.add((Local)def);
        }
        MutableStmtGraph graph = builder.getStmtGraph();
        LinkedHashSet<Local> newLocals = new LinkedHashSet<Local>(builder.getLocals());
        int localIndex = 1;
        while (!stmts.isEmpty()) {
            Stmt currentStmt = stmts.remove(0);
            if (!currentStmt.getDefs().isEmpty() && currentStmt.getDefs().get(0) instanceof Local && toSplitLocals.contains(currentStmt.getDefs().get(0))) {
                Local oriLocal = (Local)currentStmt.getDefs().get(0);
                Local newLocal = oriLocal.withName(oriLocal.getName() + "#" + localIndex);
                newLocals.add(newLocal);
                ++localIndex;
                Stmt newStmt = BodyUtils.withNewDef(currentStmt, newLocal);
                this.replaceStmtInBuilder(builder, stmts, currentStmt, newStmt);
                ArrayDeque<Stmt> forwardsQueue = new ArrayDeque<Stmt>(graph.successors(newStmt));
                HashSet visitedStmts = new HashSet();
                while (!forwardsQueue.isEmpty()) {
                    Stmt stmt = (Stmt)forwardsQueue.remove();
                    visitedStmts.add(stmt);
                    if (stmt.getUses().contains(oriLocal)) {
                        Stmt newHead = BodyUtils.withNewUse(stmt, oriLocal, newLocal);
                        this.replaceStmtInBuilder(builder, stmts, stmt, newHead);
                        if (!newHead.getDefs().isEmpty() && newHead.getDefs().get(0).equivTo(oriLocal)) continue;
                        for (Stmt succ : graph.successors(newHead)) {
                            if (visitedStmts.contains(succ) || forwardsQueue.contains(succ)) continue;
                            forwardsQueue.addLast(succ);
                        }
                        continue;
                    }
                    if (this.hasModifiedUse(stmt, oriLocal)) {
                        Local modifiedLocal = this.getModifiedUse(stmt, oriLocal);
                        if (modifiedLocal == null) {
                            throw new IllegalStateException("Modified Use is not found.");
                        }
                        if (modifiedLocal.getName().equals(newLocal.getName())) continue;
                        --localIndex;
                        ArrayDeque<Stmt> backwardsQueue = new ArrayDeque<Stmt>(graph.predecessors(stmt));
                        while (!backwardsQueue.isEmpty()) {
                            Stmt backStmt = (Stmt)backwardsQueue.remove();
                            if (this.hasModifiedDef(backStmt, oriLocal)) {
                                if (!this.hasHigherLocalName((Local)backStmt.getDefs().get(0), modifiedLocal)) continue;
                                Stmt newBackStmt = BodyUtils.withNewDef(backStmt, modifiedLocal);
                                this.replaceStmtInBuilder(builder, stmts, backStmt, newBackStmt);
                                newLocals.remove(newLocal);
                                continue;
                            }
                            if (this.hasModifiedUse(backStmt, oriLocal)) {
                                Local modifiedUse = this.getModifiedUse(backStmt, oriLocal);
                                if (!this.hasHigherLocalName(modifiedUse, modifiedLocal)) continue;
                                Stmt newBackStmt = BodyUtils.withNewUse(backStmt, modifiedUse, modifiedLocal);
                                this.replaceStmtInBuilder(builder, stmts, backStmt, newBackStmt);
                                backwardsQueue.addAll(graph.predecessors(newBackStmt));
                                continue;
                            }
                            backwardsQueue.addAll(graph.predecessors(backStmt));
                        }
                        continue;
                    }
                    if (!stmt.getDefs().isEmpty() && stmt.getDefs().get(0).equivTo(oriLocal)) continue;
                    for (Stmt succ : graph.successors(stmt)) {
                        if (visitedStmts.contains(succ) || forwardsQueue.contains(succ)) continue;
                        forwardsQueue.addLast(succ);
                    }
                }
                continue;
            }
            for (Local oriLocal : toSplitLocals) {
                if (!currentStmt.getUses().contains(oriLocal)) continue;
                Set<Stmt> handlerStmts = this.traceHandlerStmts(graph, currentStmt);
                HashSet<Stmt> stmtsWithDests = new HashSet<Stmt>();
                for (Stmt stmt : handlerStmts) {
                    for (Stmt exceptionalPred : graph.predecessors(stmt)) {
                        Map<ClassType, Stmt> dests = graph.exceptionalSuccessors(exceptionalPred);
                        ArrayList destHandlerStmts = new ArrayList();
                        dests.forEach((key, dest) -> destHandlerStmts.add(dest));
                        if (!destHandlerStmts.contains(stmt)) continue;
                        stmtsWithDests.add(exceptionalPred);
                    }
                }
                Local lastChange = null;
                for (Stmt stmt : stmtsWithDests) {
                    if (!this.hasModifiedDef(stmt, oriLocal)) continue;
                    Local modifiedLocal = (Local)stmt.getDefs().get(0);
                    if (lastChange != null && !this.hasHigherLocalName(modifiedLocal, lastChange)) continue;
                    lastChange = modifiedLocal;
                }
                if (lastChange == null) continue;
                Stmt stmt = BodyUtils.withNewUse(currentStmt, oriLocal, lastChange);
                this.replaceStmtInBuilder(builder, stmts, currentStmt, stmt);
            }
        }
        builder.setLocals(newLocals);
    }

    private void replaceStmtInBuilder(@Nonnull Body.BodyBuilder builder, @Nonnull List<Stmt> stmtIterationList, @Nonnull Stmt oldStmt, @Nonnull Stmt newStmt) {
        builder.replaceStmt(oldStmt, newStmt);
        int index = stmtIterationList.indexOf(oldStmt);
        if (index > -1) {
            stmtIterationList.set(index, newStmt);
        }
    }

    private boolean hasModifiedUse(@Nonnull Stmt stmt, @Nonnull Local oriLocal) {
        Iterator<Value> iterator;
        if (!stmt.getUses().isEmpty() && (iterator = stmt.getUses().iterator()).hasNext()) {
            Value use = iterator.next();
            return this.isLocalFromSameOrigin(oriLocal, use);
        }
        return false;
    }

    @Nullable
    private Local getModifiedUse(@Nonnull Stmt stmt, @Nonnull Local oriLocal) {
        List<Value> useList;
        if (this.hasModifiedUse(stmt, oriLocal) && !(useList = stmt.getUses()).isEmpty()) {
            for (Value use : useList) {
                if (!this.isLocalFromSameOrigin(oriLocal, use)) continue;
                return (Local)use;
            }
        }
        return null;
    }

    private boolean isLocalFromSameOrigin(@Nonnull Local oriLocal, Value local) {
        if (local instanceof Local) {
            String name = ((Local)local).getName();
            String origName = oriLocal.getName();
            int origLength = origName.length();
            return name.length() > origLength && name.startsWith(origName) && name.charAt(origLength) == '#';
        }
        return false;
    }

    private boolean hasModifiedDef(@Nonnull Stmt stmt, @Nonnull Local oriLocal) {
        List<Value> defs = stmt.getDefs();
        if (!defs.isEmpty() && defs.get(0) instanceof Local) {
            return this.isLocalFromSameOrigin(oriLocal, defs.get(0));
        }
        return false;
    }

    private boolean hasHigherLocalName(@Nonnull Local leftLocal, @Nonnull Local rightLocal) {
        int rightNum;
        String leftName = leftLocal.getName();
        String rightName = rightLocal.getName();
        int lIdx = leftName.lastIndexOf(35);
        int rIdx = rightName.lastIndexOf(35);
        int leftNum = Integer.parseInt(leftName.substring(lIdx + 1));
        return leftNum > (rightNum = Integer.parseInt(rightName.substring(rIdx + 1)));
    }

    @Nonnull
    private Set<Stmt> traceHandlerStmts(@Nonnull StmtGraph<?> graph, @Nonnull Stmt entryStmt) {
        HashSet<Stmt> handlerStmts = new HashSet<Stmt>();
        ArrayDeque<Stmt> queue = new ArrayDeque<Stmt>();
        queue.add(entryStmt);
        while (!queue.isEmpty()) {
            Stmt stmt = (Stmt)queue.removeFirst();
            if (stmt instanceof JIdentityStmt && ((JIdentityStmt)stmt).getRightOp() instanceof JCaughtExceptionRef) {
                handlerStmts.add(stmt);
                continue;
            }
            List<Stmt> predecessors = graph.predecessors(stmt);
            queue.addAll(predecessors);
        }
        return handlerStmts;
    }
}

