/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.DominanceFinder;
import sootup.core.graph.DominanceTree;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.JPhiExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.BodyUtils;
import sootup.core.transform.BodyInterceptor;

public class StaticSingleAssignmentFormer
implements BodyInterceptor {
    /*
     * WARNING - void declaration
     */
    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
        LinkedHashSet<Local> newLocals = new LinkedHashSet<Local>(builder.getLocals());
        int nextFreeIdx = 0;
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        HashMap blockToDefs = new HashMap();
        HashMap localToBlocks = new HashMap();
        for (BasicBlock<?> block : stmtGraph.getBlocks()) {
            HashSet<Local> defs = new HashSet<Local>();
            for (Stmt stmt : block.getStmts()) {
                if (stmt.getDefs().isEmpty() || !(stmt.getDefs().get(0) instanceof Local)) continue;
                Local local = (Local)stmt.getDefs().get(0);
                defs.add(local);
                if (localToBlocks.containsKey(local)) {
                    ((Set)localToBlocks.get(local)).add(block);
                    continue;
                }
                HashSet bs = new HashSet();
                bs.add(block);
                localToBlocks.put(local, bs);
            }
            blockToDefs.put(block, defs);
        }
        DominanceFinder dominanceFinder = new DominanceFinder(stmtGraph);
        Map<BasicBlock<?>, Set<Stmt>> blockToPhiStmts = this.decideBlockToPhiStmts(builder, dominanceFinder, blockToDefs, localToBlocks);
        this.addPhiStmts(blockToPhiStmts, stmtGraph, blockToDefs);
        DominanceTree tree = new DominanceTree(dominanceFinder);
        HashMap localToNameStack = new HashMap();
        for (Local local : builder.getLocals()) {
            localToNameStack.put(local, new Stack());
        }
        List<BasicBlock<?>> list = tree.getAllNodesDFS();
        ArrayList blockStack = new ArrayList();
        HashSet visited = new HashSet();
        block3: for (BasicBlock<?> block : list) {
            HashSet<Object> newPhiStmts = new HashSet();
            for (Stmt stmt : block.getStmts()) {
                List<Value> defs;
                Stmt newStmt;
                void var18_23;
                List<Value> uses = stmt.getUses();
                if (!uses.isEmpty() && !this.constainsPhiExpr(stmt)) {
                    for (Value use : uses) {
                        if (!(use instanceof Local)) continue;
                        Local newUse = (Local)((Stack)localToNameStack.get(use)).peek();
                        newStmt = BodyUtils.withNewUse((Stmt)var18_23, use, newUse);
                        stmtGraph.replaceNode((Stmt)var18_23, newStmt);
                        Stmt stmt2 = newStmt;
                    }
                }
                if ((defs = var18_23.getDefs()).isEmpty() || !(defs.get(0) instanceof Local)) continue;
                Local def = (Local)defs.get(0);
                Local newDef = def.withName(def.getName() + "#" + nextFreeIdx);
                newLocals.add(newDef);
                ++nextFreeIdx;
                ((Stack)localToNameStack.get(def)).push(newDef);
                newStmt = BodyUtils.withNewDef((Stmt)var18_23, newDef);
                stmtGraph.replaceNode((Stmt)var18_23, newStmt);
                if (!this.constainsPhiExpr(newStmt)) continue;
                newPhiStmts.add(newStmt);
            }
            visited.add(block);
            blockStack.add(block);
            if (blockToPhiStmts.containsKey(block)) {
                blockToPhiStmts.put(block, newPhiStmts);
            }
            ArrayList succs = new ArrayList(block.getSuccessors());
            succs.addAll(block.getExceptionalSuccessors().values());
            for (BasicBlock succ : succs) {
                if (!blockToPhiStmts.containsKey(succ)) continue;
                Set<Stmt> phiStmts = blockToPhiStmts.get(succ);
                newPhiStmts = new HashSet<Stmt>(phiStmts);
                for (Stmt phiStmt : phiStmts) {
                    Local def = (Local)phiStmt.getDefs().get(0);
                    Local oriDef = this.getOriginalLocal(def, localToNameStack.keySet());
                    if (((Stack)localToNameStack.get(oriDef)).isEmpty()) continue;
                    Local arg = (Local)((Stack)localToNameStack.get(oriDef)).peek();
                    Stmt newPhiStmt = this.addNewArgToPhi(phiStmt, arg, block);
                    newPhiStmts.remove(phiStmt);
                    newPhiStmts.add(newPhiStmt);
                    stmtGraph.replaceNode(phiStmt, newPhiStmt);
                }
                blockToPhiStmts.put(succ, newPhiStmts);
            }
            BasicBlock basicBlock = (BasicBlock)blockStack.get(blockStack.size() - 1);
            List<BasicBlock<?>> children = tree.getChildren(basicBlock);
            while (this.containsAllChildren(visited, children)) {
                void var18_20;
                blockStack.remove(blockStack.size() - 1);
                for (Stmt stmt3 : var18_20.getStmts()) {
                    Local def;
                    Local oriDef;
                    if (stmt3.getDefs().isEmpty() || !(stmt3.getDefs().get(0) instanceof Local) || ((Stack)localToNameStack.get(oriDef = this.getOriginalLocal(def = (Local)stmt3.getDefs().get(0), localToNameStack.keySet()))).isEmpty()) continue;
                    ((Stack)localToNameStack.get(oriDef)).pop();
                }
                if (blockStack.isEmpty()) continue block3;
                BasicBlock basicBlock2 = (BasicBlock)blockStack.get(blockStack.size() - 1);
                children = tree.getChildren(basicBlock2);
            }
        }
        builder.setLocals(newLocals);
    }

    private Map<BasicBlock<?>, Set<Stmt>> decideBlockToPhiStmts(Body.BodyBuilder builder, DominanceFinder dominanceFinder, Map<BasicBlock<?>, Set<Local>> blockToDefs, Map<Local, Set<BasicBlock<?>>> localToBlocks) {
        HashMap blockToPhiStmts = new HashMap();
        HashMap blockToPhiLocals = new HashMap();
        HashMap localToPhiBlocks = new HashMap();
        for (Local local : builder.getLocals()) {
            localToPhiBlocks.put(local, new HashSet());
            ArrayDeque blocks = new ArrayDeque((Collection)localToBlocks.get(local));
            while (!blocks.isEmpty()) {
                BasicBlock block = (BasicBlock)blocks.removeFirst();
                Set<BasicBlock<?>> dfs = dominanceFinder.getDominanceFrontiers(block);
                for (BasicBlock<?> df : dfs) {
                    Set basicBlocks = (Set)localToPhiBlocks.get(local);
                    if (basicBlocks.contains(df)) continue;
                    basicBlocks.add(df);
                    JAssignStmt<?, ?> phiStmt = this.createEmptyPhiStmt(local);
                    if (blockToPhiStmts.containsKey(df)) {
                        ((Set)blockToPhiStmts.get(df)).add(phiStmt);
                        ((Set)blockToPhiLocals.get(df)).add(local);
                    } else {
                        LinkedHashSet phiStmts = new LinkedHashSet();
                        phiStmts.add(phiStmt);
                        blockToPhiStmts.put(df, phiStmts);
                        HashSet<Local> phiLocals = new HashSet<Local>();
                        phiLocals.add(local);
                        blockToPhiLocals.put(df, phiLocals);
                    }
                    if (blockToDefs.get(df).contains(local)) continue;
                    blocks.add(df);
                }
            }
        }
        for (BasicBlock block : blockToPhiLocals.keySet()) {
            blockToDefs.get(block).addAll((Collection)blockToPhiLocals.get(block));
        }
        return blockToPhiStmts;
    }

    private void addPhiStmts(Map<BasicBlock<?>, Set<Stmt>> blockToPhiStmts, MutableStmtGraph blockGraph, Map<BasicBlock<?>, Set<Local>> blockToDefs) {
        HashMap<Stmt, Integer> phiToNum = new HashMap<Stmt, Integer>();
        for (BasicBlock<?> block : blockGraph.getBlocks()) {
            ArrayList succs = new ArrayList(block.getSuccessors());
            succs.addAll(block.getExceptionalSuccessors().values());
            for (BasicBlock succ : succs) {
                if (!blockToPhiStmts.containsKey(succ)) continue;
                for (Stmt phi : blockToPhiStmts.get(succ)) {
                    Local local = (Local)phi.getDefs().get(0);
                    if (!blockToDefs.get(block).contains(local)) continue;
                    if (phiToNum.containsKey(phi)) {
                        int num = (Integer)phiToNum.get(phi);
                        phiToNum.replace(phi, num + 1);
                        continue;
                    }
                    phiToNum.put(phi, 1);
                }
            }
        }
        for (BasicBlock<?> block : blockToPhiStmts.keySet()) {
            Set<Stmt> phis = blockToPhiStmts.get(block);
            HashSet checkedPhis = new HashSet(blockToPhiStmts.get(block));
            for (Stmt cphi : checkedPhis) {
                if ((Integer)phiToNum.get(cphi) >= 2) continue;
                phis.remove(cphi);
            }
            for (Stmt phi : phis) {
                blockGraph.insertBefore(block.getHead(), phi);
            }
        }
    }

    private boolean containsAllChildren(Set<BasicBlock<?>> blockSet, List<BasicBlock<?>> children) {
        for (BasicBlock<?> child : children) {
            if (blockSet.contains(child)) continue;
            return false;
        }
        return true;
    }

    private boolean constainsPhiExpr(Stmt stmt) {
        if (stmt instanceof JAssignStmt && !stmt.getUses().isEmpty()) {
            for (Value use : stmt.getUses()) {
                if (!(use instanceof JPhiExpr)) continue;
                return true;
            }
        }
        return false;
    }

    private JAssignStmt<?, ?> createEmptyPhiStmt(Local local) {
        JPhiExpr phi = new JPhiExpr(Collections.emptyList(), Collections.emptyMap());
        return new JAssignStmt<Local, JPhiExpr>(local, phi, StmtPositionInfo.createNoStmtPositionInfo());
    }

    private Local getOriginalLocal(Local local, Set<Local> oriLocals) {
        if (oriLocals.contains(local)) {
            return local;
        }
        int hashPos = local.getName().indexOf(35);
        String oriName = local.getName().substring(0, hashPos);
        for (Local oriLocal : oriLocals) {
            if (!oriLocal.getName().equals(oriName)) continue;
            return oriLocal;
        }
        throw new RuntimeException(local + " has no original local!");
    }

    private Stmt addNewArgToPhi(Stmt phiStmt, Local arg, BasicBlock<?> block) {
        JAssignStmt newPhiStmt = null;
        for (Value use : phiStmt.getUses()) {
            if (!(use instanceof JPhiExpr)) continue;
            JPhiExpr newPhiExpr = (JPhiExpr)use;
            List<Local> args = ((JPhiExpr)use).getArgs();
            Map<Local, BasicBlock<?>> argToBlock = ((JPhiExpr)use).getArgToBlockMap();
            args.add(arg);
            argToBlock.put(arg, block);
            newPhiExpr = newPhiExpr.withArgs(args);
            newPhiExpr = newPhiExpr.withArgToBlockMap(argToBlock);
            newPhiStmt = ((JAssignStmt)phiStmt).withRValue(newPhiExpr);
            break;
        }
        return newPhiStmt;
    }
}

