/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.interceptors;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JEnterMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JExitMonitorStmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;

public class TrapTightener
implements BodyInterceptor {
    @Override
    public void interceptBody(@Nonnull Body.BodyBuilder builder) {
    }

    private Set<Stmt> monitoredStmts(@Nonnull StmtGraph<?> graph) {
        HashSet<Stmt> monitoredStmts = new HashSet<Stmt>();
        ArrayDeque<Stmt> queue = new ArrayDeque<Stmt>();
        queue.add(graph.getStartingStmt());
        HashSet<Stmt> visitedStmts = new HashSet<Stmt>();
        while (!queue.isEmpty()) {
            Stmt stmt = (Stmt)queue.removeFirst();
            visitedStmts.add(stmt);
            if (stmt instanceof JEnterMonitorStmt) {
                ArrayDeque<Stmt> monitoredQueue = new ArrayDeque<Stmt>();
                monitoredQueue.add(stmt);
                while (!monitoredQueue.isEmpty()) {
                    Stmt monitoredStmt = (Stmt)monitoredQueue.removeFirst();
                    monitoredStmts.add(monitoredStmt);
                    visitedStmts.add(monitoredStmt);
                    if (monitoredStmt instanceof JExitMonitorStmt) {
                        queue.addAll(graph.getAllSuccessors(monitoredStmt));
                        continue;
                    }
                    for (Stmt succ : graph.getAllSuccessors(monitoredStmt)) {
                        if (visitedStmts.contains(succ)) continue;
                        monitoredQueue.add(succ);
                    }
                }
                continue;
            }
            queue.addAll(graph.getAllSuccessors(stmt));
        }
        return monitoredStmts;
    }

    private boolean mightThrow(@Nonnull StmtGraph<?> graph, @Nonnull Stmt stmt, @Nonnull Trap trap) {
        BasicBlock<?> block = graph.getBlockOf(stmt);
        for (Map.Entry<ClassType, ?> dest : block.getExceptionalSuccessors().entrySet()) {
            ClassType exceptionType = dest.getKey();
            BasicBlock traphandlerBlock = (BasicBlock)dest.getValue();
            if (!exceptionType.equals(trap.getExceptionType()) || !traphandlerBlock.getHead().equals(trap.getHandlerStmt())) continue;
            return true;
        }
        return false;
    }
}

