/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ClassUtils;
import sootup.core.signatures.MethodSignature;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.signatures.ModulePackageName;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.ModuleJavaClassType;

public class JavaModuleIdentifierFactory
extends JavaIdentifierFactory {
    public static final String MODULE_INFO_FILE = "module-info";
    private static final Map<String, ModuleSignature> modules = new HashMap<String, ModuleSignature>();
    private static final JavaModuleIdentifierFactory INSTANCE = new JavaModuleIdentifierFactory();
    private static final Map<ModuleSignature, JavaModuleIdentifierFactory> moduleIdentifierFactoryWrapper = new HashMap<ModuleSignature, JavaModuleIdentifierFactory>();

    public static JavaModuleIdentifierFactory getInstance() {
        return INSTANCE;
    }

    public static JavaModuleIdentifierFactory getInstance(@Nonnull String module) {
        return JavaModuleIdentifierFactory.getInstance(JavaModuleIdentifierFactory.getModuleSignature(module));
    }

    public static JavaModuleIdentifierFactory getInstance(@Nonnull ModuleSignature moduleSignature) {
        return moduleIdentifierFactoryWrapper.computeIfAbsent(moduleSignature, methodSignature -> new JavaModuleIdentifierFactoryWrapper(moduleSignature));
    }

    @Override
    public ModuleJavaClassType getClassType(String className, String packageName) {
        return this.getClassType(className, packageName, ModuleSignature.UNNAMED_MODULE.getModuleName());
    }

    @Override
    public ModuleJavaClassType getClassType(String fullyQualyfiedClassNameWithModule) {
        int moduleSplit = fullyQualyfiedClassNameWithModule.indexOf(47);
        String moduleName = null;
        if (moduleSplit >= 0) {
            moduleName = fullyQualyfiedClassNameWithModule.substring(0, moduleSplit);
            fullyQualyfiedClassNameWithModule = fullyQualyfiedClassNameWithModule.substring(moduleSplit + 1);
        }
        String className = ClassUtils.getShortClassName(fullyQualyfiedClassNameWithModule);
        String packageName = ClassUtils.getPackageName(fullyQualyfiedClassNameWithModule);
        if (className.equals(MODULE_INFO_FILE)) {
            throw new IllegalArgumentException("module-info is not allowed as classname.");
        }
        if (moduleName == null) {
            return this.getClassType(className, packageName);
        }
        return this.getClassType(className, packageName, moduleName);
    }

    public ModuleJavaClassType getClassType(@Nonnull String className, @Nonnull String packageName, @Nonnull String moduleName) {
        ModulePackageName packageIdentifier = this.getPackageName(packageName, moduleName);
        return new ModuleJavaClassType(className, packageIdentifier);
    }

    public ModuleJavaClassType getClassType(@Nonnull String className, @Nonnull String packageName, @Nonnull ModuleSignature moduleSignature) {
        ModulePackageName packageIdentifier = this.getPackageName(packageName, moduleSignature);
        return new ModuleJavaClassType(className, packageIdentifier);
    }

    public static ModuleSignature getModuleSignature(@Nonnull String moduleName) {
        ModuleSignature moduleSignature = modules.get(moduleName);
        if (moduleSignature == null) {
            moduleSignature = new ModuleSignature(moduleName);
            modules.put(moduleName, moduleSignature);
        }
        return moduleSignature;
    }

    @Override
    public ModulePackageName getPackageName(@Nonnull String packageName) {
        return this.getPackageName(packageName, ModuleSignature.UNNAMED_MODULE.getModuleName());
    }

    public ModulePackageName getPackageName(@Nonnull String packageName, @Nonnull String moduleName) {
        String fqId = moduleName + "." + packageName;
        ModulePackageName packageSignature = (ModulePackageName)this.packages.get(fqId);
        if (packageSignature == null) {
            ModuleSignature moduleSignature = JavaModuleIdentifierFactory.getModuleSignature(moduleName);
            packageSignature = new ModulePackageName(packageName, moduleSignature);
            this.packages.put(fqId, packageSignature);
        }
        return packageSignature;
    }

    public ModulePackageName getPackageName(@Nonnull String packageName, @Nonnull ModuleSignature moduleSignature) {
        String fqId = moduleSignature.getModuleName() + "." + packageName;
        ModulePackageName packageSignature = (ModulePackageName)this.packages.get(fqId);
        if (packageSignature == null) {
            packageSignature = new ModulePackageName(packageName, moduleSignature);
            this.packages.put(fqId, packageSignature);
        }
        return packageSignature;
    }

    static {
        modules.put(ModuleSignature.UNNAMED_MODULE.getModuleName(), ModuleSignature.UNNAMED_MODULE);
    }

    private static class JavaModuleIdentifierFactoryWrapper
    extends JavaModuleIdentifierFactory {
        @Nonnull
        private final ModuleSignature moduleSignature;

        private JavaModuleIdentifierFactoryWrapper(@Nonnull ModuleSignature moduleSignature) {
            this.moduleSignature = moduleSignature;
        }

        @Override
        public ModuleJavaClassType getClassType(String fullyQualifiedClassName) {
            ModuleSignature moduleSig;
            int moduleSplitPos = fullyQualifiedClassName.indexOf(47);
            if (moduleSplitPos >= 0) {
                String moduleName = fullyQualifiedClassName.substring(0, moduleSplitPos);
                fullyQualifiedClassName = fullyQualifiedClassName.substring(moduleSplitPos + 1);
                moduleSig = JavaModuleIdentifierFactoryWrapper.getModuleSignature(moduleName);
            } else {
                moduleSig = this.moduleSignature;
            }
            String className = ClassUtils.getShortClassName(fullyQualifiedClassName);
            String packageName = ClassUtils.getPackageName(fullyQualifiedClassName);
            return this.getClassType(className, packageName, moduleSig);
        }

        @Override
        public MethodSignature getMethodSignature(String methodName, String fullyQualifiedNameDeclClass, String fqReturnType, List<String> parameters) {
            return super.getMethodSignature(methodName, fullyQualifiedNameDeclClass, fqReturnType, parameters);
        }
    }
}

