/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.frontend.ResolveException;
import sootup.java.core.JavaModuleIdentifierFactory;
import sootup.java.core.ModuleModifier;
import sootup.java.core.signatures.ModulePackageName;
import sootup.java.core.signatures.ModuleSignature;
import sootup.java.core.types.JavaClassType;

public abstract class JavaModuleInfo {
    public abstract ModuleSignature getModuleSignature();

    public Set<ModuleModifier> getModifiers() {
        return Collections.emptySet();
    }

    public abstract Collection<ModuleReference> requires();

    public abstract Collection<PackageReference> exports();

    public abstract Collection<PackageReference> opens();

    public abstract Collection<InterfaceReference> provides();

    public abstract Collection<JavaClassType> uses();

    public abstract boolean isAutomaticModule();

    public boolean isUnnamedModule() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getModuleSignature()).append(' ');
        if (this.isAutomaticModule()) {
            sb.append("auto ");
        }
        sb.append("requires ").append(this.requires());
        sb.append("exports ").append(this.exports());
        sb.append("opens ").append(this.opens());
        sb.append("uses ").append(this.uses());
        sb.append("provides ").append(this.provides());
        return sb.toString();
    }

    public static JavaModuleInfo createAutomaticModuleInfo(final @Nonnull ModuleSignature moduleName) {
        return new JavaModuleInfo(){

            @Override
            public ModuleSignature getModuleSignature() {
                return moduleName;
            }

            @Override
            public Collection<ModuleReference> requires() {
                throw new ResolveException("All modules can be required from the automatic module. Handle it separately.");
            }

            @Override
            public Collection<PackageReference> exports() {
                throw new ResolveException("All Packages are exported in the automatic module. Handle it separately.");
            }

            @Override
            public Collection<PackageReference> opens() {
                throw new ResolveException("All Packages are open in the automatic module. Handle it separately.");
            }

            @Override
            public Collection<InterfaceReference> provides() {
                throw new ResolveException("All Packages are open in the automatic module. Handle it separately.");
            }

            @Override
            public Collection<JavaClassType> uses() {
                throw new ResolveException("All Packages are open in the automatic module. Handle it separately.");
            }

            @Override
            public boolean isAutomaticModule() {
                return true;
            }
        };
    }

    public static JavaModuleInfo getUnnamedModuleInfo() {
        return new JavaModuleInfo(){

            @Override
            public ModuleSignature getModuleSignature() {
                return JavaModuleIdentifierFactory.getModuleSignature("");
            }

            @Override
            public Collection<ModuleReference> requires() {
                return Collections.emptyList();
            }

            @Override
            public Collection<PackageReference> exports() {
                return Collections.emptyList();
            }

            @Override
            public Collection<PackageReference> opens() {
                return Collections.emptyList();
            }

            @Override
            public Collection<InterfaceReference> provides() {
                return Collections.emptyList();
            }

            @Override
            public Collection<JavaClassType> uses() {
                return Collections.emptyList();
            }

            @Override
            public boolean isAutomaticModule() {
                return true;
            }

            @Override
            public boolean isUnnamedModule() {
                return true;
            }

            @Override
            public String toString() {
                return "<unnamed>" + super.toString();
            }
        };
    }

    public static class PackageReference {
        @Nonnull
        private final ModulePackageName packageName;
        @Nonnull
        private final EnumSet<ModuleModifier> modifers;
        @Nonnull
        private final Set<ModuleSignature> targetModules;

        public PackageReference(@Nonnull ModulePackageName packageName, @Nonnull EnumSet<ModuleModifier> modifier, @Nonnull Collection<ModuleSignature> targetModules) {
            this.packageName = packageName;
            this.modifers = modifier;
            this.targetModules = targetModules.isEmpty() ? Collections.emptySet() : new HashSet<ModuleSignature>(targetModules);
        }

        public boolean appliesTo(@Nonnull ModuleSignature moduleSignature) {
            if (this.targetModules.isEmpty()) {
                return true;
            }
            return this.targetModules.contains(moduleSignature);
        }

        @Nonnull
        public ModulePackageName getPackageName() {
            return this.packageName;
        }

        @Nonnull
        public EnumSet<ModuleModifier> getModifiers() {
            return this.modifers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.modifers).append(' ').append(this.packageName);
            if (!this.targetModules.isEmpty()) {
                sb.append(" to ").append(this.targetModules);
            }
            return sb.toString();
        }
    }

    public static class InterfaceReference {
        @Nonnull
        private final JavaClassType interfaceType;
        @Nonnull
        private final JavaClassType interfaceImplementation;

        public InterfaceReference(@Nonnull JavaClassType interfaceType, @Nonnull JavaClassType interfaceImplementation) {
            this.interfaceType = interfaceType;
            this.interfaceImplementation = interfaceImplementation;
        }

        @Nonnull
        public JavaClassType getInterfaceType() {
            return this.interfaceType;
        }

        @Nonnull
        public JavaClassType getInterfaceImplementation() {
            return this.interfaceImplementation;
        }

        public String toString() {
            return "provides " + this.interfaceType + " with " + this.interfaceImplementation;
        }
    }

    public static class ModuleReference {
        @Nonnull
        private final ModuleSignature moduleInfo;
        @Nonnull
        private final EnumSet<ModuleModifier> modifiers;

        public ModuleReference(@Nonnull ModuleSignature moduleInfo, @Nonnull EnumSet<ModuleModifier> accessModifier) {
            this.moduleInfo = moduleInfo;
            this.modifiers = accessModifier;
        }

        @Nonnull
        public EnumSet<ModuleModifier> getModifiers() {
            return this.modifiers;
        }

        @Nonnull
        public ModuleSignature getModuleSignature() {
            return this.moduleInfo;
        }

        public String toString() {
            return this.modifiers + " " + this.moduleInfo;
        }
    }
}

