/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.model.SootMethod;
import sootup.core.signatures.PackageName;
import sootup.core.types.VoidType;
import sootup.java.core.JavaAnnotationSootMethod;
import sootup.java.core.JavaSootClass;
import sootup.java.core.JavaSootMethod;
import sootup.java.core.types.JavaClassType;
import sootup.java.core.views.JavaView;

public class AnnotationType
extends JavaClassType {
    @Nullable
    private Boolean isInherited = null;
    @Nullable
    private Map<String, Object> defaultValues = null;
    final Set<String> metaAnnotationNames = new HashSet<String>(Arrays.asList("Retention", "Documented", "Target", "Inherited", "Repeatable"));
    static final Set<String> forbiddenMethodNames = new HashSet<String>(Arrays.asList("equals", "getClass", "hashCode", "notify", "notifyAll", "toString", "wait"));

    public void setInherited(boolean inherited) {
        this.isInherited = inherited;
    }

    public Map<String, Object> getDefaultValues(@Nonnull Optional<JavaView> viewOptional) {
        if (this.defaultValues == null) {
            this.defaultValues = new HashMap<String, Object>();
            if (viewOptional.isPresent()) {
                JavaView jv = viewOptional.get();
                if (this.isMetaAnnotation()) {
                    return this.defaultValues;
                }
                if (!jv.getClass(this).isPresent()) {
                    throw new RuntimeException("Class of annotation not in view");
                }
                JavaSootClass jsc = jv.getClass(this).get();
                for (JavaSootMethod javaSootMethod : jsc.getMethods()) {
                    JavaAnnotationSootMethod jasm = (JavaAnnotationSootMethod)javaSootMethod;
                    Object defaultVal = jasm.getDefaultValue();
                    this.defaultValues.put(jasm.getName(), defaultVal);
                }
            } else {
                throw new IllegalArgumentException("getDefaultMethods needs to be called at least once with a view for each annotation type.");
            }
        }
        return this.defaultValues;
    }

    public boolean isInherited(Optional<JavaView> viewOptional) {
        if (this.isInherited == null) {
            if (!viewOptional.isPresent()) {
                throw new IllegalArgumentException("JavaView needs to be supplied at least once for the annotationType");
            }
            JavaView jv = viewOptional.get();
            if (!jv.getClass(this).isPresent()) {
                throw new RuntimeException("Class of annotation not in view");
            }
            JavaSootClass jsc = jv.getClass(this).get();
            this.isInherited = StreamSupport.stream(jsc.getAnnotations(viewOptional).spliterator(), false).anyMatch(annotationUsage -> annotationUsage.getAnnotation().getClassName().equals("Inherited"));
        }
        return this.isInherited;
    }

    public AnnotationType(@Nonnull String annotationName, @Nonnull PackageName packageName) {
        super(annotationName, packageName);
    }

    public AnnotationType(@Nonnull String annotationName, @Nonnull PackageName packageName, boolean isInherited) {
        super(annotationName, packageName);
        this.isInherited = isInherited;
    }

    public boolean isMetaAnnotation() {
        return this.metaAnnotationNames.contains(this.getClassName());
    }

    public static boolean validateAnnotation(@Nonnull JavaSootClass annotationClass) {
        for (SootMethod sootMethod : annotationClass.getMethods()) {
            if (sootMethod.getReturnType() instanceof VoidType) {
                return false;
            }
            if (sootMethod.getParameterCount() != 0) {
                return false;
            }
            if (forbiddenMethodNames.contains(sootMethod.getName())) {
                return false;
            }
            if (sootMethod.getExceptionSignatures().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotationType that = (AnnotationType)o;
        return this.getFullyQualifiedName().equals(that.getFullyQualifiedName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isInherited, this.defaultValues);
    }
}

