/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.frontend.ClassProvider;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.bytecode.frontend.AsmAnnotationClassSource;
import sootup.java.bytecode.frontend.AsmClassSource;
import sootup.java.bytecode.frontend.AsmMethodSource;
import sootup.java.bytecode.frontend.AsmUtil;
import sootup.java.core.types.AnnotationType;
import sootup.java.core.types.JavaClassType;
import sootup.java.core.types.ModuleJavaClassType;

public class AsmJavaClassProvider
implements ClassProvider {
    @Nonnull
    private final View view;
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(AsmJavaClassProvider.class);

    public AsmJavaClassProvider(@Nonnull View view) {
        this.view = view;
    }

    public Optional<SootClassSource> createClassSource(@Nonnull AnalysisInputLocation analysisInputLocation, @Nonnull Path sourcePath, @Nonnull ClassType classType) {
        String actualClassSignature;
        SootClassNode classNode;
        try {
            classNode = new SootClassNode(analysisInputLocation);
            actualClassSignature = AsmUtil.initAsmClassSource(sourcePath, (ClassVisitor)classNode);
        }
        catch (IOException exception) {
            logger.warn("ioe: " + sourcePath, (Throwable)exception);
            return Optional.empty();
        }
        catch (IllegalArgumentException exception) {
            logger.warn("iae: " + sourcePath, (Throwable)exception);
            return Optional.empty();
        }
        String requestedName = classType.getPackageName().getName();
        String requestedFQClassName = classType.getPackageName().getName() + (requestedName.isEmpty() ? "" : ".") + classType.getClassName();
        String actualFQClassName = actualClassSignature.replace('/', '.');
        if (!actualFQClassName.equals(requestedFQClassName)) {
            return Optional.empty();
        }
        JavaClassType klassType = (JavaClassType)classType;
        if (klassType instanceof ModuleJavaClassType && klassType.getClassName().equals("module-info")) {
            logger.warn("Can not create ClassSource from a module info descriptor! path:" + sourcePath);
            return Optional.empty();
        }
        if (klassType instanceof AnnotationType) {
            return Optional.of(new AsmAnnotationClassSource(analysisInputLocation, sourcePath, klassType, classNode));
        }
        return Optional.of(new AsmClassSource(analysisInputLocation, sourcePath, klassType, classNode));
    }

    @Nonnull
    public FileType getHandledFileType() {
        return FileType.CLASS;
    }

    class SootClassNode
    extends ClassNode {
        private final AnalysisInputLocation analysisInputLocation;

        SootClassNode(AnalysisInputLocation analysisInputLocation) {
            super(589824);
            this.analysisInputLocation = analysisInputLocation;
        }

        @Nonnull
        public MethodVisitor visitMethod(int access, @Nonnull String name, @Nonnull String desc, @Nonnull String signature, @Nonnull String[] exceptions) {
            AsmMethodSource mn = new AsmMethodSource(access, name, desc, signature, exceptions, AsmJavaClassProvider.this.view, this.analysisInputLocation.getBodyInterceptors());
            this.methods.add(mn);
            return mn;
        }
    }
}

