/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.exceptionanalysis;

import com.ibm.wala.analysis.exceptionanalysis.IntraproceduralExceptionAnalysis;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cfg.exceptionpruning.interprocedural.InterproceduralExceptionFilter;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CGIntraproceduralExceptionAnalysis {
    private final Map<CGNode, IntraproceduralExceptionAnalysis> analysis;
    private final Set<TypeReference> exceptions;
    private final CallGraph callGraph;

    public CGIntraproceduralExceptionAnalysis(CallGraph cg, PointerAnalysis<InstanceKey> pointerAnalysis, ClassHierarchy cha, InterproceduralExceptionFilter<SSAInstruction> filter) {
        this.callGraph = cg;
        this.exceptions = new LinkedHashSet<TypeReference>();
        this.analysis = new LinkedHashMap<CGNode, IntraproceduralExceptionAnalysis>();
        for (CGNode node : cg) {
            if (node.getIR() == null || node.getIR().isEmptyIR()) {
                this.analysis.put(node, IntraproceduralExceptionAnalysis.newDummy());
                continue;
            }
            IntraproceduralExceptionAnalysis intraEA = new IntraproceduralExceptionAnalysis(node, filter.getFilter(node), cha, pointerAnalysis);
            this.analysis.put(node, intraEA);
            this.exceptions.addAll(intraEA.getExceptions());
            this.exceptions.addAll(intraEA.getPossiblyCaughtExceptions());
        }
    }

    public IntraproceduralExceptionAnalysis getAnalysis(CGNode node) {
        if (!this.callGraph.containsNode(node)) {
            throw new IllegalArgumentException("The given CG node has to be part of the call graph given during construction.");
        }
        IntraproceduralExceptionAnalysis result = this.analysis.get(node);
        if (result == null) {
            throw new RuntimeException("Internal Error: No result for the given node.");
        }
        return result;
    }

    public Set<TypeReference> getExceptions() {
        return this.exceptions;
    }
}

