/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.pointers;

import com.ibm.wala.analysis.pointers.HeapGraphImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.IntMapIterator;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.AbstractNumberedGraph;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableMapping;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSetFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public class BasicHeapGraph<T extends InstanceKey>
extends HeapGraphImpl<T> {
    private static final boolean VERBOSE = false;
    private static final int VERBOSE_INTERVAL = 10000;
    private static final MutableSparseIntSetFactory factory = new MutableSparseIntSetFactory();
    private final NumberedGraph<Object> G;
    private final CallGraph callGraph;

    public BasicHeapGraph(final PointerAnalysis<T> P, CallGraph callGraph) throws NullPointerException {
        super(P);
        this.callGraph = callGraph;
        final OrdinalSetMapping<PointerKey> pointerKeys = this.getPointerKeys();
        final NumberedNodeManager<Object> nodeMgr = new NumberedNodeManager<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new CompoundIterator<Object>(pointerKeys.iterator(), P.getInstanceKeyMapping().iterator());
            }

            @Override
            public Stream<Object> stream() {
                return Stream.concat(pointerKeys.stream(), P.getInstanceKeyMapping().stream());
            }

            @Override
            public int getNumberOfNodes() {
                return pointerKeys.getSize() + P.getInstanceKeyMapping().getSize();
            }

            @Override
            public void addNode(Object n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public void removeNode(Object n) {
                Assertions.UNREACHABLE();
            }

            @Override
            public int getNumber(Object N) {
                int inumber;
                if (N instanceof PointerKey) {
                    return pointerKeys.getMappedIndex(N);
                }
                if (!(N instanceof InstanceKey)) {
                    Assertions.UNREACHABLE(N.getClass().toString());
                }
                return (inumber = P.getInstanceKeyMapping().getMappedIndex(N)) == -1 ? -1 : inumber + pointerKeys.getMaximumIndex() + 1;
            }

            @Override
            public Object getNode(int number) {
                if (number > pointerKeys.getMaximumIndex()) {
                    return P.getInstanceKeyMapping().getMappedObject(number - pointerKeys.getSize());
                }
                return pointerKeys.getMappedObject(number);
            }

            @Override
            public int getMaxNumber() {
                return this.getNumberOfNodes() - 1;
            }

            @Override
            public boolean containsNode(Object n) {
                return this.getNumber(n) != -1;
            }

            @Override
            public Iterator<Object> iterateNodes(IntSet s2) {
                return new NumberedNodeIterator<Object>(s2, this);
            }
        };
        final IBinaryNaturalRelation pred = this.computePredecessors(nodeMgr);
        final IntFunction<Object> toNode = nodeMgr::getNode;
        this.G = new AbstractNumberedGraph<Object>(){
            private final NumberedEdgeManager<Object> edgeMgr = new NumberedEdgeManager<Object>(){

                @Override
                public Iterator<Object> getPredNodes(Object N) {
                    int n = nodeMgr.getNumber(N);
                    IntSet p = pred.getRelated(n);
                    if (p == null) {
                        return EmptyIterator.instance();
                    }
                    return new IntMapIterator<Object>(p.intIterator(), toNode);
                }

                @Override
                public IntSet getPredNodeNumbers(Object N) {
                    int n = nodeMgr.getNumber(N);
                    IntSet p = pred.getRelated(n);
                    if (p != null) {
                        return p;
                    }
                    return IntSetUtil.make();
                }

                @Override
                public int getPredNodeCount(Object N) {
                    int n = nodeMgr.getNumber(N);
                    return pred.getRelatedCount(n);
                }

                @Override
                public Iterator<Object> getSuccNodes(Object N) {
                    int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, nodeMgr);
                    if (succ == null) {
                        return EmptyIterator.instance();
                    }
                    MutableSparseIntSet s2 = factory.make(succ);
                    return new IntMapIterator<Object>(s2.intIterator(), toNode);
                }

                @Override
                public IntSet getSuccNodeNumbers(Object N) {
                    int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, nodeMgr);
                    if (succ == null) {
                        return IntSetUtil.make();
                    }
                    return IntSetUtil.make(succ);
                }

                @Override
                public int getSuccNodeCount(Object N) {
                    int[] succ = BasicHeapGraph.this.computeSuccNodeNumbers(N, nodeMgr);
                    return succ == null ? 0 : succ.length;
                }

                @Override
                public void addEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeAllIncidentEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeIncomingEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeOutgoingEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public boolean hasEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                    return false;
                }
            };

            @Override
            protected NumberedNodeManager<Object> getNodeManager() {
                return nodeMgr;
            }

            @Override
            protected NumberedEdgeManager<Object> getEdgeManager() {
                return this.edgeMgr;
            }
        };
    }

    private OrdinalSetMapping<PointerKey> getPointerKeys() {
        MutableMapping<PointerKey> result = MutableMapping.make();
        for (PointerKey p : this.getPointerAnalysis().getPointerKeys()) {
            result.add(p);
        }
        return result;
    }

    private int[] computeSuccNodeNumbers(Object N, NumberedNodeManager<Object> nodeManager) {
        if (N instanceof PointerKey) {
            PointerKey P = (PointerKey)N;
            OrdinalSet S = this.getPointerAnalysis().getPointsToSet(P);
            int[] result = new int[S.size()];
            int i = 0;
            for (InstanceKey t : S) {
                result[i] = nodeManager.getNumber(t);
                ++i;
            }
            return result;
        }
        if (N instanceof InstanceKey) {
            InstanceKey I2 = (InstanceKey)N;
            TypeReference T = I2.getConcreteType().getReference();
            assert (T != null) : "null concrete type from " + I2.getClass();
            if (T.isArrayType()) {
                PointerKey p = this.getHeapModel().getPointerKeyForArrayContents(I2);
                if (p == null || !nodeManager.containsNode(p)) {
                    return null;
                }
                return new int[]{nodeManager.getNumber(p)};
            }
            IClass klass = I2.getConcreteType();
            assert (klass != null) : "null klass for type " + T;
            MutableSparseIntSet result = MutableSparseIntSet.makeEmpty();
            for (IField f : klass.getAllInstanceFields()) {
                PointerKey p;
                if (f.getReference().getFieldType().isPrimitiveType() || (p = this.getHeapModel().getPointerKeyForInstanceField(I2, f)) == null || !nodeManager.containsNode(p)) continue;
                result.add(nodeManager.getNumber(p));
            }
            return result.toIntArray();
        }
        Assertions.UNREACHABLE("Unexpected type: " + N.getClass());
        return null;
    }

    private IBinaryNaturalRelation computePredecessors(NumberedNodeManager<Object> nodeManager) {
        BasicNaturalRelation R = new BasicNaturalRelation(new byte[]{0}, 0);
        this.computePredecessorsForNonLocals(nodeManager, R);
        this.computePredecessorsForLocals(nodeManager, R);
        return R;
    }

    private void computePredecessorsForNonLocals(NumberedNodeManager<Object> nodeManager, BasicNaturalRelation R) {
        for (int i = nodeManager.getMaxNumber(); i >= 0; --i) {
            int[] succ;
            Object n = nodeManager.getNode(i);
            if (n instanceof LocalPointerKey || (succ = this.computeSuccNodeNumbers(n, nodeManager)) == null) continue;
            for (int j : succ) {
                R.add(j, i);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void computePredecessorsForLocals(NumberedNodeManager<Object> nodeManager, BasicNaturalRelation R) {
        void var5_7;
        ArrayList<LocalPointerKey> list = new ArrayList<LocalPointerKey>();
        for (Object t : nodeManager) {
            if (!(t instanceof LocalPointerKey)) continue;
            list.add((LocalPointerKey)t);
        }
        Object[] arr = list.toArray();
        Arrays.sort(arr, new LocalPointerComparator());
        boolean bl = false;
        while (var5_7 < arr.length) {
            LocalPointerKey n = (LocalPointerKey)arr[var5_7];
            int num = nodeManager.getNumber(n);
            int[] succ = this.computeSuccNodeNumbers(n, nodeManager);
            if (succ != null) {
                for (int j : succ) {
                    R.add(j, num);
                }
            }
            ++var5_7;
        }
    }

    @Override
    public int getNumber(Object N) {
        return this.G.getNumber(N);
    }

    @Override
    public Object getNode(int number) {
        return this.G.getNode(number);
    }

    @Override
    public int getMaxNumber() {
        return this.G.getMaxNumber();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.G.iterator();
    }

    @Override
    public Stream<Object> stream() {
        return this.G.stream();
    }

    @Override
    public int getNumberOfNodes() {
        return this.G.getNumberOfNodes();
    }

    @Override
    public Iterator<Object> getPredNodes(Object N) {
        return this.G.getPredNodes(N);
    }

    @Override
    public int getPredNodeCount(Object N) {
        return this.G.getPredNodeCount(N);
    }

    @Override
    public Iterator<Object> getSuccNodes(Object N) {
        return this.G.getSuccNodes(N);
    }

    @Override
    public int getSuccNodeCount(Object N) {
        return this.G.getSuccNodeCount(N);
    }

    @Override
    public void addNode(Object n) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeNode(Object n) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void addEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public boolean hasEdge(Object from, Object to) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return false;
    }

    @Override
    public void removeAllIncidentEdges(Object node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsNode(Object N) {
        return this.G.containsNode(N);
    }

    public String toString() {
        Object node;
        int i;
        StringBuilder result = new StringBuilder();
        result.append("Nodes:\n");
        for (i = 0; i <= this.getMaxNumber(); ++i) {
            node = this.getNode(i);
            if (node == null) continue;
            result.append(i).append("  ").append(node).append('\n');
        }
        result.append("Edges:\n");
        for (i = 0; i <= this.getMaxNumber(); ++i) {
            node = this.getNode(i);
            if (node == null) continue;
            result.append(i).append(" -> ");
            for (Object s2 : Iterator2Iterable.make(this.getSuccNodes(node))) {
                result.append(this.getNumber(s2)).append(' ');
            }
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public void removeIncomingEdges(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public void removeOutgoingEdges(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
    }

    @Override
    public IntSet getSuccNodeNumbers(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public IntSet getPredNodeNumbers(Object node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    private final class LocalPointerComparator
    implements Comparator<Object> {
        private LocalPointerComparator() {
        }

        @Override
        public int compare(Object arg1, Object arg2) {
            LocalPointerKey o1 = (LocalPointerKey)arg1;
            LocalPointerKey o2 = (LocalPointerKey)arg2;
            if (o1.getNode().equals(o2.getNode())) {
                return o1.getValueNumber() - o2.getValueNumber();
            }
            return BasicHeapGraph.this.callGraph.getNumber(o1.getNode()) - BasicHeapGraph.this.callGraph.getNumber(o2.getNode());
        }
    }
}

