/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.stackMachine;

import com.ibm.wala.cfg.ShrikeCFG;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BasicFramework;
import com.ibm.wala.dataflow.graph.DataflowSolver;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.AbstractStatement;
import com.ibm.wala.fixpoint.AbstractVariable;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.ThrowInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.INodeWithNumber;
import com.ibm.wala.util.shrike.ShrikeUtil;
import java.util.Arrays;

public abstract class AbstractIntStackMachine
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    public static final int TOP = -1;
    public static final int BOTTOM = -2;
    public static final int UNANALYZED = -3;
    public static final int IGNORE = -4;
    private DataflowSolver<ShrikeCFG.BasicBlock, MachineState> solver;
    private final ShrikeCFG cfg;
    public static final boolean OPTIMISTIC = true;

    protected AbstractIntStackMachine(ShrikeCFG G) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.cfg = G;
    }

    protected void init(Meeter meeter, final FlowProvider flow) {
        final MeetOperator meet = new MeetOperator(meeter);
        ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState> xferFunctions = new ITransferFunctionProvider<ShrikeCFG.BasicBlock, MachineState>(){

            @Override
            public boolean hasNodeTransferFunctions() {
                return flow.needsNodeFlow();
            }

            @Override
            public boolean hasEdgeTransferFunctions() {
                return flow.needsEdgeFlow();
            }

            @Override
            public UnaryOperator<MachineState> getNodeTransferFunction(final ShrikeCFG.BasicBlock node) {
                return new UnaryOperator<MachineState>(){

                    @Override
                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, node);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    @Override
                    public String toString() {
                        return "NODE-FLOW";
                    }

                    @Override
                    public int hashCode() {
                        return 9973 * node.hashCode();
                    }

                    @Override
                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            @Override
            public UnaryOperator<MachineState> getEdgeTransferFunction(final ShrikeCFG.BasicBlock from, final ShrikeCFG.BasicBlock to) {
                return new UnaryOperator<MachineState>(){

                    @Override
                    public byte evaluate(MachineState lhs, MachineState rhs) {
                        MachineState exit = lhs;
                        MachineState entry = rhs;
                        MachineState newExit = flow.flow(entry, from, to);
                        if (newExit.stateEquals(exit)) {
                            return 0;
                        }
                        exit.copyState(newExit);
                        return 1;
                    }

                    @Override
                    public String toString() {
                        return "EDGE-FLOW";
                    }

                    @Override
                    public int hashCode() {
                        return 9973 * (from.hashCode() ^ to.hashCode());
                    }

                    @Override
                    public boolean equals(Object o) {
                        return this == o;
                    }
                };
            }

            @Override
            public AbstractMeetOperator<MachineState> getMeetOperator() {
                return meet;
            }
        };
        BasicFramework<ShrikeCFG.BasicBlock, MachineState> problem = new BasicFramework<ShrikeCFG.BasicBlock, MachineState>(this.cfg, xferFunctions);
        this.solver = new DataflowSolver<ShrikeCFG.BasicBlock, MachineState>(problem){
            private MachineState entry;

            @Override
            protected MachineState makeNodeVariable(ShrikeCFG.BasicBlock n, boolean IN) {
                assert (n != null);
                MachineState result = new MachineState(n);
                if (IN && n.equals(AbstractIntStackMachine.this.cfg.entry())) {
                    this.entry = result;
                }
                return result;
            }

            @Override
            protected MachineState makeEdgeVariable(ShrikeCFG.BasicBlock from, ShrikeCFG.BasicBlock to) {
                assert (from != null);
                assert (to != null);
                MachineState result = new MachineState(from);
                return result;
            }

            @Override
            protected void initializeWorkList() {
                super.buildEquations(false, false);
                for (INodeWithNumber s2 : Iterator2Iterable.make(this.getFixedPointSystem().getStatementsThatUse(this.entry))) {
                    this.addToWorkList((AbstractStatement)s2);
                }
            }

            @Override
            protected void initializeVariables() {
                super.initializeVariables();
                AbstractIntStackMachine.this.initializeVariables();
            }

            protected MachineState[] makeStmtRHS(int size) {
                return new MachineState[size];
            }
        };
    }

    public boolean solve() {
        try {
            return this.solver.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException(e);
        }
    }

    protected void initializeVariables() {
    }

    public MachineState getEntryState() {
        return this.solver.getIn(this.cfg.entry());
    }

    public MachineState getIn(ShrikeCFG.BasicBlock bb) {
        return this.solver.getIn(bb);
    }

    private static boolean meet(MachineState lhs, MachineState[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = AbstractIntStackMachine.meetStacks(lhs, rhs, bb, meeter);
        return changed |= AbstractIntStackMachine.meetLocals(lhs, rhs, bb, meeter);
    }

    private static boolean meetForCatchBlock(MachineState lhs, MachineState[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = AbstractIntStackMachine.meetStacksAtCatchBlock(lhs, bb, meeter);
        return changed |= AbstractIntStackMachine.meetLocals(lhs, rhs, bb, meeter);
    }

    private static boolean meetStacksAtCatchBlock(MachineState lhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        if (lhs.stack == null) {
            lhs.allocateStack(1);
            lhs.stackHeight = 1;
        }
        int meet = meeter.meetStackAtCatchBlock(bb);
        if (lhs.stack[0] == -1) {
            if (meet != -1) {
                changed = true;
                ((MachineState)lhs).stack[0] = meet;
            }
        } else if (meet != lhs.stack[0]) {
            changed = true;
            ((MachineState)lhs).stack[0] = meet;
        }
        return changed;
    }

    private static boolean meetStacks(MachineState lhs, MachineState[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        int height = AbstractIntStackMachine.computeMeetStackHeight(rhs);
        if (height > -1 && (lhs.stack == null || lhs.stack.length < height)) {
            lhs.allocateStack(height);
            lhs.stackHeight = height;
            changed = true;
        }
        for (int i = 0; i < height; ++i) {
            int[] R = new int[rhs.length];
            for (int j = 0; j < R.length; ++j) {
                MachineState m3 = rhs[j];
                if (m3.stack == null || m3.stack.length < i + 1) {
                    R[j] = -1;
                    continue;
                }
                R[j] = m3.stack[i];
                if (R[j] != 0) continue;
                R[j] = -1;
            }
            int meet = meeter.meetStack(i, R, bb);
            if (lhs.stack[i] == -1) {
                if (meet == -1) continue;
                changed = true;
                ((MachineState)lhs).stack[i] = meet;
                continue;
            }
            if (meet == lhs.stack[i]) continue;
            changed = true;
            ((MachineState)lhs).stack[i] = meet;
        }
        return changed;
    }

    private static boolean meetLocals(MachineState lhs, MachineState[] rhs, ShrikeCFG.BasicBlock bb, Meeter meeter) {
        boolean changed = false;
        int nLocals = AbstractIntStackMachine.computeMeetNLocals(rhs);
        if (nLocals > -1 && (lhs.locals == null || lhs.locals.length < nLocals)) {
            lhs.allocateLocals(nLocals);
        }
        for (int i = 0; i < nLocals; ++i) {
            int[] R = new int[rhs.length];
            for (int j = 0; j < rhs.length; ++j) {
                R[j] = rhs[j].getLocal(i);
            }
            int meet = meeter.meetLocal(i, R, bb);
            if (lhs.locals[i] == -1) {
                if (meet == -1) continue;
                changed = true;
                ((MachineState)lhs).locals[i] = meet;
                continue;
            }
            if (meet == lhs.locals[i]) continue;
            changed = true;
            ((MachineState)lhs).locals[i] = meet;
        }
        return changed;
    }

    private static int computeMeetNLocals(MachineState[] operands) {
        MachineState lhs = operands[0];
        int nLocals = -1;
        if (lhs.locals != null) {
            nLocals = lhs.locals.length;
        } else {
            for (int i = 1; i < operands.length; ++i) {
                MachineState rhs = operands[i];
                if (rhs.locals == null) continue;
                nLocals = rhs.locals.length;
                break;
            }
        }
        return nLocals;
    }

    private static int computeMeetStackHeight(MachineState[] operands) {
        MachineState lhs = operands[0];
        int height = -1;
        if (lhs.stack != null) {
            height = lhs.stackHeight;
        } else {
            for (int i = 1; i < operands.length; ++i) {
                MachineState rhs = operands[i];
                if (rhs.stack == null) continue;
                height = rhs.stackHeight;
                break;
            }
        }
        return height;
    }

    protected static abstract class BasicStackFlowProvider
    implements FlowProvider,
    Constants {
        private final ShrikeCFG cfg;
        protected MachineState workingState;
        private BasicStackMachineVisitor visitor;
        private IInstruction.Visitor edgeVisitor;
        private int currentInstructionIndex = 0;
        private ShrikeCFG.BasicBlock currentBlock;
        private ShrikeCFG.BasicBlock currentSuccessorBlock;

        protected BasicStackFlowProvider(ShrikeCFG cfg) {
            this.cfg = cfg;
        }

        protected void init(BasicStackMachineVisitor v, IInstruction.Visitor ev) {
            this.visitor = v;
            this.edgeVisitor = ev;
        }

        @Override
        public boolean needsNodeFlow() {
            return true;
        }

        @Override
        public boolean needsEdgeFlow() {
            return false;
        }

        @Override
        public MachineState flow(MachineState entry, ShrikeCFG.BasicBlock basicBlock) {
            this.workingState = entry.duplicate();
            this.currentBlock = basicBlock;
            this.currentSuccessorBlock = null;
            IInstruction[] instructions = this.getInstructions();
            for (int i = basicBlock.getFirstInstructionIndex(); i <= basicBlock.getLastInstructionIndex(); ++i) {
                this.currentInstructionIndex = i;
                instructions[i].visit(this.visitor);
            }
            return this.workingState;
        }

        @Override
        public MachineState flow(MachineState entry, ShrikeCFG.BasicBlock from, ShrikeCFG.BasicBlock to) {
            this.workingState = entry.duplicate();
            this.currentBlock = from;
            this.currentSuccessorBlock = to;
            IInstruction[] instructions = this.getInstructions();
            for (int i = from.getFirstInstructionIndex(); i <= from.getLastInstructionIndex(); ++i) {
                this.currentInstructionIndex = i;
                instructions[i].visit(this.edgeVisitor);
            }
            return this.workingState;
        }

        protected int getCurrentInstructionIndex() {
            return this.currentInstructionIndex;
        }

        protected int getCurrentProgramCounter() {
            return this.cfg.getProgramCounter(this.currentInstructionIndex);
        }

        protected ShrikeCFG.BasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        protected ShrikeCFG.BasicBlock getCurrentSuccessor() {
            return this.currentSuccessorBlock;
        }

        public abstract IInstruction[] getInstructions();

        protected class BasicStackMachineVisitor
        extends IInstruction.Visitor {
            protected BasicStackMachineVisitor() {
            }

            @Override
            public void visitArrayLength(ArrayLengthInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            @Override
            public void visitArrayLoad(IArrayLoadInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            @Override
            public void visitArrayStore(IArrayStoreInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            @Override
            public void visitBinaryOp(IBinaryOpInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            @Override
            public void visitComparison(IComparisonInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            @Override
            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.pop();
            }

            @Override
            public void visitConstant(ConstantInstruction instruction) {
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            @Override
            public void visitConversion(IConversionInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            @Override
            public void visitDup(DupInstruction instruction) {
                int v4;
                int size = instruction.getSize();
                int delta = instruction.getDelta();
                assert (size == 1 || size == 2);
                assert (delta == 0 || delta == 1 || delta == 2);
                int toPop = size + delta;
                int v1 = BasicStackFlowProvider.this.workingState.pop();
                int v2 = toPop > 1 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int v3 = toPop > 2 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                int n = v4 = toPop > 3 ? BasicStackFlowProvider.this.workingState.pop() : -4;
                if (size > 1) {
                    BasicStackFlowProvider.this.workingState.push(v2);
                }
                BasicStackFlowProvider.this.workingState.push(v1);
                if (v4 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v4);
                }
                if (v3 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v3);
                }
                if (v2 != -4) {
                    BasicStackFlowProvider.this.workingState.push(v2);
                }
                BasicStackFlowProvider.this.workingState.push(v1);
            }

            @Override
            public void visitGet(IGetInstruction instruction) {
                this.popN(instruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            protected void popN(IInstruction instruction) {
                for (int i = 0; i < instruction.getPoppedCount(); ++i) {
                    BasicStackFlowProvider.this.workingState.pop();
                }
            }

            @Override
            public void visitInstanceof(IInstanceofInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            @Override
            public void visitInvoke(IInvokeInstruction instruction) {
                this.popN(instruction);
                ClassLoaderReference loader = BasicStackFlowProvider.this.cfg.getMethod().getDeclaringClass().getClassLoader().getReference();
                TypeReference returnType = ShrikeUtil.makeTypeReference(loader, Util.getReturnType(instruction.getMethodSignature()));
                if (!returnType.equals(TypeReference.Void)) {
                    BasicStackFlowProvider.this.workingState.push(-3);
                }
            }

            @Override
            public void visitMonitor(MonitorInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            @Override
            public void visitLocalLoad(ILoadInstruction instruction) {
                int t = BasicStackFlowProvider.this.workingState.getLocal(instruction.getVarIndex());
                BasicStackFlowProvider.this.workingState.push(t);
            }

            @Override
            public void visitLocalStore(IStoreInstruction instruction) {
                int index = instruction.getVarIndex();
                BasicStackFlowProvider.this.workingState.setLocal(index, BasicStackFlowProvider.this.workingState.pop());
            }

            @Override
            public void visitNew(NewInstruction instruction) {
                this.popN(instruction);
                BasicStackFlowProvider.this.workingState.push(-3);
            }

            @Override
            public void visitPop(PopInstruction instruction) {
                if (instruction.getPoppedCount() > 0) {
                    BasicStackFlowProvider.this.workingState.pop();
                }
            }

            @Override
            public void visitPut(IPutInstruction instruction) {
                this.popN(instruction);
            }

            @Override
            public void visitShift(IShiftInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            @Override
            public void visitSwap(SwapInstruction instruction) {
                BasicStackFlowProvider.this.workingState.swap();
            }

            @Override
            public void visitSwitch(SwitchInstruction instruction) {
                BasicStackFlowProvider.this.workingState.pop();
            }

            @Override
            public void visitThrow(ThrowInstruction instruction) {
                int exceptionType = BasicStackFlowProvider.this.workingState.pop();
                BasicStackFlowProvider.this.workingState.clearStack();
                BasicStackFlowProvider.this.workingState.push(exceptionType);
            }

            @Override
            public void visitUnaryOp(IUnaryOpInstruction instruction) {
            }
        }
    }

    public static interface FlowProvider {
        public boolean needsNodeFlow();

        public boolean needsEdgeFlow();

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2);

        public MachineState flow(MachineState var1, ShrikeCFG.BasicBlock var2, ShrikeCFG.BasicBlock var3);
    }

    public class MachineState
    extends AbstractVariable<MachineState> {
        private int[] stack;
        private int[] locals;
        private int stackHeight;
        private final ShrikeCFG.BasicBlock bb;

        public MachineState duplicate() {
            MachineState result = new MachineState(this.bb);
            result.copyState(this);
            return result;
        }

        public MachineState(ShrikeCFG.BasicBlock bb) {
            this.setTOP();
            this.bb = bb;
        }

        public ShrikeCFG.BasicBlock getBasicBlock() {
            return this.bb;
        }

        void setTOP() {
            this.stackHeight = -1;
            this.stack = null;
        }

        boolean isTOP() {
            return this.stackHeight == -1;
        }

        public void push(int i) {
            if (this.stack == null || this.stackHeight >= this.stack.length) {
                this.allocateStack(this.stackHeight + 1);
            }
            this.stack[this.stackHeight++] = i;
        }

        public int pop() {
            if (this.stackHeight <= 0) assert (this.stackHeight > 0) : "can't pop stack of height " + this.stackHeight;
            --this.stackHeight;
            return this.stack[this.stackHeight];
        }

        public int peek() {
            return this.stack[this.stackHeight - 1];
        }

        public void swap() {
            int temp = this.stack[this.stackHeight - 1];
            this.stack[this.stackHeight - 1] = this.stack[this.stackHeight - 2];
            this.stack[this.stackHeight - 2] = temp;
        }

        private void allocateStack(int stackHeight) {
            if (this.stack == null) {
                this.stack = new int[stackHeight + 1];
                this.stackHeight = 0;
            } else {
                this.stack = Arrays.copyOf(this.stack, Math.max(this.stack.length, stackHeight) * 2 + 1);
            }
        }

        private void allocateLocals(int maxLocals) {
            int[] result = new int[maxLocals];
            int start = 0;
            if (this.locals != null) {
                System.arraycopy(this.locals, 0, result, 0, this.locals.length);
                start = this.locals.length;
            }
            for (int i = start; i < maxLocals; ++i) {
                result[i] = -1;
            }
            this.locals = result;
        }

        public void clearStack() {
            this.stackHeight = 0;
        }

        public void setLocal(int i, int j) {
            if (this.locals == null || this.locals.length < i + 1) {
                if (j == -1) {
                    return;
                }
                this.allocateLocals(i + 1);
            }
            this.locals[i] = j;
        }

        public int getLocal(int i) {
            if (this.locals == null || this.locals.length < i + 1) {
                return -1;
            }
            return this.locals[i];
        }

        public void replaceValue(int from, int to) {
            int i;
            if (this.stack != null) {
                for (i = 0; i < this.stackHeight; ++i) {
                    if (this.stack[i] != from) continue;
                    this.stack[i] = to;
                }
            }
            if (this.locals != null) {
                for (i = 0; i < this.locals.length; ++i) {
                    if (this.locals[i] != from) continue;
                    this.locals[i] = to;
                }
            }
        }

        public boolean hasValue(int val) {
            if (this.stack != null) {
                for (int i = 0; i < this.stackHeight; ++i) {
                    if (this.stack[i] != val) continue;
                    return true;
                }
            }
            if (this.locals != null) {
                for (int local : this.locals) {
                    if (local != val) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            if (this.isTOP()) {
                return "<TOP>@" + System.identityHashCode(this);
            }
            StringBuilder result = new StringBuilder("<");
            result.append('S');
            if (this.stackHeight == 0) {
                result.append("[empty]");
            } else {
                result.append((CharSequence)this.array2StringBuffer(this.stack, this.stackHeight));
            }
            result.append('L');
            result.append((CharSequence)this.array2StringBuffer(this.locals, this.locals == null ? 0 : this.locals.length));
            result.append('>');
            return result.toString();
        }

        private StringBuilder array2StringBuffer(int[] array, int n) {
            StringBuilder result = new StringBuilder("[");
            if (array == null) {
                result.append("TOP");
            } else {
                for (int i = 0; i < n - 1; ++i) {
                    result.append(array[i]).append(',');
                }
                result.append(array[n - 1]);
            }
            result.append(']');
            return result;
        }

        @Override
        public void copyState(MachineState other) {
            this.stack = other.stack == null ? null : (int[])other.stack.clone();
            this.locals = other.locals == null ? null : (int[])other.locals.clone();
            this.stackHeight = other.stackHeight;
        }

        boolean stateEquals(MachineState exit) {
            int i;
            if (this.stackHeight != exit.stackHeight) {
                return false;
            }
            if (this.locals == null) {
                if (exit.locals != null) {
                    return false;
                }
            } else {
                if (exit.locals == null) {
                    return false;
                }
                if (this.locals.length != exit.locals.length) {
                    return false;
                }
            }
            for (i = 0; i < this.stackHeight; ++i) {
                if (this.stack[i] == exit.stack[i]) continue;
                return false;
            }
            if (this.locals != null) {
                for (i = 0; i < this.locals.length; ++i) {
                    if (this.locals[i] == -1 && exit.locals[i] != -1) {
                        return false;
                    }
                    if (this.locals[i] == exit.locals[i]) continue;
                    return false;
                }
            }
            return true;
        }

        public int getStackHeight() {
            return this.stackHeight;
        }

        public int[] getLocals() {
            return this.locals;
        }
    }

    protected static interface Meeter {
        public int meetStack(int var1, int[] var2, ShrikeCFG.BasicBlock var3);

        public int meetStackAtCatchBlock(ShrikeCFG.BasicBlock var1);

        public int meetLocal(int var1, int[] var2, ShrikeCFG.BasicBlock var3);
    }

    private class MeetOperator
    extends AbstractMeetOperator<MachineState> {
        private final Meeter meeter;

        MeetOperator(Meeter meeter) {
            this.meeter = meeter;
        }

        @Override
        public boolean isUnaryNoOp() {
            return false;
        }

        public byte evaluate(MachineState lhs, MachineState[] rhs) {
            ShrikeCFG.BasicBlock bb = lhs.getBasicBlock();
            if (!bb.isCatchBlock()) {
                return AbstractIntStackMachine.meet(lhs, rhs, bb, this.meeter) ? (byte)1 : 0;
            }
            return AbstractIntStackMachine.meetForCatchBlock(lhs, rhs, bb, this.meeter) ? (byte)1 : 0;
        }

        @Override
        public int hashCode() {
            return 72223 * this.meeter.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MeetOperator) {
                MeetOperator other = (MeetOperator)o;
                return this.meeter.equals(other.meeter);
            }
            return false;
        }

        @Override
        public String toString() {
            return "MEETER";
        }
    }
}

