/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.PrimitiveType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeVariable;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dataflow.ssa.SSAInference;
import com.ibm.wala.fixedpoint.impl.NullaryOperator;
import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.fixpoint.FixedPointConstants;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IVisitorWithAddresses;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Iterator;

public class TypeInference
extends SSAInference<TypeVariable>
implements FixedPointConstants {
    private static final boolean DEBUG = false;
    protected final IR ir;
    protected final IClassHierarchy cha;
    protected final Language language;
    private static final AbstractOperator<TypeVariable> phiOp = new PhiOperator();
    private static final AbstractOperator<TypeVariable> primitivePropagateOp = new PrimitivePropagateOperator();
    protected final TypeAbstraction BOTTOM;
    private static final PiOperator piOp = new PiOperator();
    protected final boolean doPrimitives;
    private boolean solved = false;

    public static TypeInference make(IR ir, boolean doPrimitives) {
        return new TypeInference(ir, doPrimitives);
    }

    protected TypeInference(IR ir, boolean doPrimitives) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        this.language = ir.getMethod().getDeclaringClass().getClassLoader().getLanguage();
        this.cha = ir.getMethod().getDeclaringClass().getClassHierarchy();
        this.ir = ir;
        this.doPrimitives = doPrimitives;
        this.BOTTOM = new ConeType(this.cha.getRootClass());
        this.initialize();
        this.solve();
    }

    public boolean solve() {
        return this.solve(null);
    }

    @Override
    public boolean solve(MonitorUtil.IProgressMonitor monitor) {
        try {
            if (this.solved) {
                return false;
            }
            boolean result = super.solve(null);
            this.solved = true;
            return result;
        }
        catch (CancelException e) {
            throw new CancelRuntimeException(e);
        }
    }

    protected void initialize() {
        this.init(this.ir, new TypeVarFactory(), new TypeOperatorFactory());
    }

    @Override
    protected void initializeVariables() {
        int[] parameterValueNumbers = this.ir.getParameterValueNumbers();
        for (int i = 0; i < parameterValueNumbers.length; ++i) {
            TypeVariable v = (TypeVariable)this.getVariable(parameterValueNumbers[i]);
            TypeReference t = this.ir.getParameterType(i);
            if (t.isReferenceType()) {
                IClass klass = this.cha.lookupClass(t);
                if (klass != null) {
                    v.setType(new ConeType(klass));
                    continue;
                }
                v.setType(this.BOTTOM);
                continue;
            }
            if (!this.doPrimitives) continue;
            v.setType(this.language.getPrimitive(t));
        }
        SymbolTable st = this.ir.getSymbolTable();
        if (st != null) {
            for (int i = 0; i <= st.getMaxValueNumber(); ++i) {
                if (!st.isConstant(i)) continue;
                TypeVariable v = (TypeVariable)this.getVariable(i);
                v.setType(this.getConstantType(i));
            }
        }
        for (SSAInstruction s2 : Iterator2Iterable.make(this.ir.iterateNormalInstructions())) {
            if (!(s2 instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)s2;
            TypeVariable v = (TypeVariable)this.getVariable(call.getException());
            Collection<TypeReference> defaultExceptions = call.getExceptionTypes();
            if (defaultExceptions.size() == 0) continue;
            Iterator<TypeReference> types = defaultExceptions.iterator();
            TypeReference t = types.next();
            IClass klass = this.cha.lookupClass(t);
            if (klass == null) {
                v.setType(this.BOTTOM);
            } else {
                v.setType(new PointType(klass));
            }
            while (types.hasNext()) {
                t = types.next();
                klass = this.cha.lookupClass(t);
                if (klass == null) continue;
                v.setType(v.getType().meet(new PointType(klass)));
            }
            IMethod m3 = this.cha.resolveMethod(call.getDeclaredTarget());
            if (m3 == null) continue;
            TypeReference[] x = null;
            try {
                x = m3.getDeclaredExceptions();
            }
            catch (InvalidClassFileException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            catch (UnsupportedOperationException e) {
                x = new TypeReference[]{this.language.getThrowableType()};
            }
            if (x == null) continue;
            for (TypeReference tx : x) {
                IClass tc = this.cha.lookupClass(tx);
                if (tc == null) continue;
                v.setType(v.getType().meet(new ConeType(tc)));
            }
        }
    }

    @Override
    protected void initializeWorkList() {
        this.addAllStatementsToWorkList();
    }

    public IR getIR() {
        return this.ir;
    }

    public TypeAbstraction getType(int valueNumber) {
        if (valueNumber < 0) {
            throw new IllegalArgumentException("bad value number " + valueNumber);
        }
        TypeVariable variable = (TypeVariable)this.getVariable(valueNumber);
        assert (variable != null) : "null variable for value number " + valueNumber;
        return variable.getType();
    }

    public TypeAbstraction getConstantType(int valueNumber) {
        if (this.ir.getSymbolTable().isStringConstant(valueNumber)) {
            return new PointType(this.cha.lookupClass(this.language.getStringType()));
        }
        return this.getConstantPrimitiveType(valueNumber);
    }

    public TypeAbstraction getConstantPrimitiveType(int valueNumber) {
        SymbolTable st = this.ir.getSymbolTable();
        if (!st.isConstant(valueNumber) || st.isNullConstant(valueNumber)) {
            return TypeAbstraction.TOP;
        }
        return this.language.getPrimitive(this.language.getConstantType(st.getConstantValue(valueNumber)));
    }

    public boolean isUndefined(int valueNumber) {
        if (this.getVariable(valueNumber) == null) {
            return true;
        }
        TypeAbstraction ta = ((TypeVariable)this.getVariable(valueNumber)).getType();
        return ta == this.BOTTOM || ta.getType() == null;
    }

    public TypeAbstraction[] extractAllResults() {
        int numberOfVars = this.ir.getSymbolTable().getMaxValueNumber() + 1;
        TypeAbstraction[] ret = new TypeAbstraction[numberOfVars];
        for (int i = 0; i < numberOfVars; ++i) {
            TypeVariable var = (TypeVariable)this.getVariable(i);
            ret[i] = var == null ? null : var.getType();
        }
        return ret;
    }

    protected TypeVariable[] makeStmtRHS(int size) {
        return new TypeVariable[size];
    }

    public class TypeVarFactory
    implements SSAInference.VariableFactory<TypeVariable> {
        public TypeVariable makeVariable(int valueNumber) {
            SymbolTable st;
            if (TypeInference.this.doPrimitives && (st = TypeInference.this.ir.getSymbolTable()).isConstant(valueNumber) && st.isBooleanConstant(valueNumber)) {
                return new TypeVariable(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(Boolean.TRUE)));
            }
            return new TypeVariable(TypeAbstraction.TOP);
        }
    }

    protected class TypeOperatorFactory
    extends SSAInstruction.Visitor
    implements IVisitorWithAddresses,
    SSAInference.OperatorFactory<TypeVariable> {
        protected AbstractOperator<TypeVariable> result = null;

        protected TypeOperatorFactory() {
        }

        @Override
        public AbstractOperator<TypeVariable> get(SSAInstruction instruction) {
            instruction.visit(this);
            AbstractOperator<TypeVariable> temp = this.result;
            this.result = null;
            return temp;
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.result = new GetElementType(instruction);
        }

        @Override
        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.result = !TypeInference.this.doPrimitives ? null : new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(1)));
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
            IClass jlClassKlass = TypeInference.this.cha.lookupClass(instruction.getType());
            assert (jlClassKlass != null);
            this.result = new DeclaredTypeOperator(new ConeType(jlClassKlass));
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            TypeReference type = instruction.getDeclaredFieldType();
            if (TypeInference.this.doPrimitives && type.isPrimitiveType()) {
                PrimitiveType p = TypeInference.this.language.getPrimitive(type);
                assert (p != null) : "no type for " + type;
                this.result = new DeclaredTypeOperator(p);
            } else {
                IClass klass = TypeInference.this.cha.lookupClass(type);
                this.result = klass == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new ConeType(klass));
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            IClass klass;
            TypeReference type = instruction.getDeclaredResultType();
            this.result = type.isReferenceType() ? ((klass = TypeInference.this.cha.lookupClass(type)) == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new ConeType(klass))) : (TypeInference.this.doPrimitives && type.isPrimitiveType() ? new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(type)) : null);
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            TypeReference type = instruction.getConcreteType();
            IClass klass = TypeInference.this.cha.lookupClass(type);
            this.result = klass == null ? new DeclaredTypeOperator(TypeInference.this.BOTTOM) : new DeclaredTypeOperator(new PointType(klass));
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            TypeAbstraction typeAbs = null;
            for (TypeReference type : instruction.getDeclaredResultTypes()) {
                IClass klass = TypeInference.this.cha.lookupClass(type);
                if (klass == null) {
                    typeAbs = TypeInference.this.BOTTOM;
                    continue;
                }
                TypeAbstraction x = null;
                if (TypeInference.this.doPrimitives && type.isPrimitiveType()) {
                    x = TypeInference.this.language.getPrimitive(type);
                } else if (type.isReferenceType()) {
                    x = new ConeType(klass);
                }
                if (x == null) continue;
                typeAbs = typeAbs == null ? x : typeAbs.meet(x);
            }
            this.result = new DeclaredTypeOperator(typeAbs);
        }

        @Override
        public void visitConversion(SSAConversionInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(instruction.getToType()));
            }
        }

        @Override
        public void visitComparison(SSAComparisonInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(0)));
            }
        }

        @Override
        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = primitivePropagateOp;
            }
        }

        @Override
        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = primitivePropagateOp;
            }
        }

        @Override
        public void visitInstanceof(SSAInstanceofInstruction instruction) {
            if (TypeInference.this.doPrimitives) {
                this.result = new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(TypeInference.this.language.getConstantType(Boolean.TRUE)));
            }
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            TypeAbstraction type = this.meetDeclaredExceptionTypes(instruction);
            this.result = new DeclaredTypeOperator(type);
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
            this.result = phiOp;
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            this.result = piOp;
        }

        private TypeAbstraction meetDeclaredExceptionTypes(SSAGetCaughtExceptionInstruction s2) {
            SSACFG.ExceptionHandlerBasicBlock bb = (SSACFG.ExceptionHandlerBasicBlock)TypeInference.this.ir.getControlFlowGraph().getNode(s2.getBasicBlockNumber());
            Iterator<TypeReference> it = bb.getCaughtExceptionTypes();
            TypeReference t = it.next();
            IClass klass = TypeInference.this.cha.lookupClass(t);
            TypeAbstraction result = null;
            result = klass == null ? TypeInference.this.BOTTOM : new ConeType(klass);
            while (it.hasNext()) {
                t = it.next();
                IClass tClass = TypeInference.this.cha.lookupClass(t);
                if (tClass == null) {
                    result = TypeInference.this.BOTTOM;
                    continue;
                }
                result = result.meet(new ConeType(tClass));
            }
            return result;
        }

        private DeclaredTypeOperator getPointerTypeOperator(TypeReference type) {
            if (type.isPrimitiveType()) {
                return new DeclaredTypeOperator(TypeInference.this.language.getPrimitive(type));
            }
            IClass klass = TypeInference.this.cha.lookupClass(type);
            if (klass == null) {
                return new DeclaredTypeOperator(TypeInference.this.BOTTOM);
            }
            return new DeclaredTypeOperator(new ConeType(klass));
        }

        @Override
        public void visitAddressOf(SSAAddressOfInstruction instruction) {
            TypeReference type = TypeInference.this.language.getPointerType(instruction.getType());
            this.result = this.getPointerTypeOperator(type);
        }

        @Override
        public void visitLoadIndirect(SSALoadIndirectInstruction instruction) {
            this.result = this.getPointerTypeOperator(instruction.getLoadedType());
        }

        @Override
        public void visitStoreIndirect(SSAStoreIndirectInstruction instruction) {
            Assertions.UNREACHABLE();
        }
    }

    private final class GetElementType
    extends AbstractOperator<TypeVariable> {
        private final SSAArrayLoadInstruction load;

        GetElementType(SSAArrayLoadInstruction load) {
            this.load = load;
        }

        public byte evaluate(TypeVariable lhs, TypeVariable[] rhs) {
            TypeAbstraction arrayType = TypeInference.this.getType(this.load.getArrayRef());
            if (arrayType == null || arrayType.equals(TypeAbstraction.TOP)) {
                return 0;
            }
            TypeReference elementType = null;
            if (arrayType instanceof PointType) {
                elementType = ((PointType)arrayType).getType().getReference().getArrayElementType();
            } else if (arrayType instanceof ConeType) {
                elementType = ((ConeType)arrayType).getType().getReference().getArrayElementType();
            } else {
                Assertions.UNREACHABLE("Unexpected type " + arrayType.getClass());
            }
            if (elementType.isPrimitiveType()) {
                if (TypeInference.this.doPrimitives && lhs.getType() == TypeAbstraction.TOP) {
                    lhs.setType(PrimitiveType.getPrimitive(elementType));
                    return 1;
                }
                return 0;
            }
            if (lhs.getType() != TypeAbstraction.TOP) {
                TypeReference tType = null;
                if (lhs.getType() instanceof PointType) {
                    tType = ((PointType)lhs.getType()).getType().getReference();
                } else if (lhs.getType() instanceof ConeType) {
                    tType = ((ConeType)lhs.getType()).getType().getReference();
                } else {
                    Assertions.UNREACHABLE("Unexpected type " + lhs.getType().getClass());
                }
                if (tType.equals(elementType)) {
                    return 0;
                }
                IClass klass = TypeInference.this.cha.lookupClass(elementType);
                assert (klass != null);
                lhs.setType(new ConeType(klass));
                return 1;
            }
            IClass klass = TypeInference.this.cha.lookupClass(elementType);
            if (klass != null) {
                lhs.setType(new ConeType(klass));
            } else {
                lhs.setType(TypeAbstraction.TOP);
            }
            return 1;
        }

        @Override
        public String toString() {
            return "getElementType " + this.load;
        }

        @Override
        public int hashCode() {
            return 9923 * this.load.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof GetElementType) {
                GetElementType other = (GetElementType)o;
                return this.load.equals(other.load);
            }
            return false;
        }
    }

    protected static class PrimitivePropagateOperator
    extends AbstractOperator<TypeVariable> {
        protected PrimitivePropagateOperator() {
        }

        public byte evaluate(TypeVariable lhs, TypeVariable[] rhs) {
            TypeAbstraction lhsType = lhs.getType();
            TypeAbstraction meet = TypeAbstraction.TOP;
            for (TypeVariable r : rhs) {
                if (r == null || r.getType() == null) continue;
                meet = meet.meet(r.getType());
            }
            if (lhsType.equals(meet)) {
                return 0;
            }
            lhs.setType(meet);
            return 1;
        }

        @Override
        public String toString() {
            return "propagate";
        }

        @Override
        public int hashCode() {
            return 99292;
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass().equals(this.getClass());
        }
    }

    private static final class PiOperator
    extends AbstractOperator<TypeVariable> {
        private PiOperator() {
        }

        public byte evaluate(TypeVariable lhs, TypeVariable[] rhsOperands) {
            TypeVariable rhs;
            TypeAbstraction rhsType;
            TypeAbstraction lhsType = lhs.getType();
            if (lhsType.equals(rhsType = (rhs = rhsOperands[0]).getType())) {
                return 0;
            }
            lhs.setType(rhsType);
            return 1;
        }

        @Override
        public String toString() {
            return "pi";
        }

        @Override
        public int hashCode() {
            return 129077;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof PiOperator;
        }
    }

    private static final class PhiOperator
    extends AbstractOperator<TypeVariable> {
        private PhiOperator() {
        }

        public byte evaluate(TypeVariable lhs, TypeVariable[] rhs) {
            TypeAbstraction lhsType = lhs.getType();
            TypeAbstraction meet = TypeAbstraction.TOP;
            for (TypeVariable r : rhs) {
                if (r == null || r.getType() == null) continue;
                meet = meet.meet(r.getType());
            }
            if (lhsType.equals(meet)) {
                return 0;
            }
            lhs.setType(meet);
            return 1;
        }

        @Override
        public String toString() {
            return "phi meet";
        }

        @Override
        public int hashCode() {
            return 9929;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof PhiOperator;
        }
    }

    protected static final class DeclaredTypeOperator
    extends NullaryOperator<TypeVariable> {
        private final TypeAbstraction type;

        public DeclaredTypeOperator(TypeAbstraction type) {
            assert (type != null);
            this.type = type;
        }

        @Override
        public byte evaluate(TypeVariable lhs) {
            if (lhs.type.equals(this.type)) {
                return 2;
            }
            lhs.setType(this.type);
            return 3;
        }

        @Override
        public String toString() {
            return "delared type := " + this.type;
        }

        public static boolean isNullary() {
            return true;
        }

        @Override
        public int hashCode() {
            return 9931 * this.type.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof DeclaredTypeOperator) {
                DeclaredTypeOperator d = (DeclaredTypeOperator)o;
                return this.type.equals(d.type);
            }
            return false;
        }
    }
}

