/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;

public class ArgumentInstanceContext
implements Context {
    private final Context base;
    private final int index;
    private final InstanceKey instanceKey;
    public static final ContextKey ID_KEY = new ContextKey(){};

    public ArgumentInstanceContext(Context base, int index, InstanceKey instanceKey) {
        this.base = base;
        this.index = index;
        this.instanceKey = instanceKey;
    }

    @Override
    public ContextItem get(ContextKey name) {
        if (name.equals(ContextKey.PARAMETERS[this.index]) || name.equals(ID_KEY)) {
            return new FilteredPointerKey.SingleInstanceFilter(this.instanceKey);
        }
        return this.base.get(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.instanceKey == null ? 0 : this.instanceKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArgumentInstanceContext other = (ArgumentInstanceContext)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return !(this.instanceKey == null ? other.instanceKey != null : !this.instanceKey.equals(other.instanceKey));
    }

    public String toString() {
        return "ArgumentInstanceContext [base=" + this.base + ", index=" + this.index + ", instanceKey=" + this.instanceKey + ']';
    }
}

