/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ir.cfg.AstInducedCFG;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.util.ConcurrentModificationException;
import java.util.Set;
import java.util.function.Function;

public class AstCallGraph
extends ExplicitCallGraph {
    public AstCallGraph(IMethod fakeRootClass2, AnalysisOptions options, IAnalysisCacheView cache) {
        super(fakeRootClass2, options, cache);
    }

    @Override
    protected ExplicitCallGraph.ExplicitNode makeNode(IMethod method, Context context) {
        return new AstCGNode(method, context);
    }

    public class AstCGNode
    extends ExplicitCallGraph.ExplicitNode {
        private Set<Function<Object, Object>> callbacks;

        private AstCGNode(IMethod method, Context context) {
            super(method, context);
        }

        private void fireCallbacks() {
            if (this.callbacks != null) {
                boolean done = false;
                while (!done) {
                    try {
                        for (Function<Object, Object> function : this.callbacks) {
                            function.apply(null);
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        done = false;
                        continue;
                    }
                    done = true;
                }
            }
        }

        private boolean hasCallback(Function<Object, Object> callback) {
            return this.callbacks != null && this.callbacks.contains(callback);
        }

        private boolean hasAllCallbacks(Set<Function<Object, Object>> callbacks) {
            return callbacks != null && this.callbacks.containsAll(callbacks);
        }

        public void addCallback(Function<Object, Object> callback) {
            if (!this.hasCallback(callback)) {
                if (this.callbacks == null) {
                    this.callbacks = HashSetFactory.make(1);
                }
                this.callbacks.add(callback);
                for (CGNode cGNode : Iterator2Iterable.make(this.getCallGraph().getPredNodes(this))) {
                    ((AstCGNode)cGNode).addCallback(callback);
                }
            }
        }

        public void addAllCallbacks(Set<Function<Object, Object>> callback) {
            if (!this.hasAllCallbacks(this.callbacks)) {
                if (this.callbacks == null) {
                    this.callbacks = HashSetFactory.make(1);
                }
                this.callbacks.addAll(callback);
                for (CGNode cGNode : Iterator2Iterable.make(this.getCallGraph().getPredNodes(this))) {
                    ((AstCGNode)cGNode).addAllCallbacks(callback);
                }
            }
        }

        public void clearMutatedCache(CallSiteReference cs) {
            this.targets.remove(cs.getProgramCounter());
        }

        @Override
        public boolean addTarget(CallSiteReference site, CGNode node) {
            if (super.addTarget(site, node)) {
                if (((AstCGNode)node).callbacks != null) {
                    ((AstCGNode)node).fireCallbacks();
                    this.addAllCallbacks(((AstCGNode)node).callbacks);
                }
                return true;
            }
            return false;
        }
    }

    public static abstract class ScriptFakeRoot
    extends AstFakeRoot {
        public ScriptFakeRoot(MethodReference rootMethod, IClass declaringClass, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, declaringClass, cha, options, cache);
        }

        public ScriptFakeRoot(MethodReference rootMethod, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, cha, options, cache);
        }

        public abstract SSAAbstractInvokeInstruction addDirectCall(int var1, int[] var2, CallSiteReference var3);

        @Override
        public SSANewInstruction addAllocation(TypeReference T) {
            if (this.cha.isSubclassOf(this.cha.lookupClass(T), this.cha.lookupClass(this.declaringClass.getClassLoader().getLanguage().getRootType()))) {
                int instance = this.nextLocal++;
                NewSiteReference ref = NewSiteReference.make(this.statements.size(), T);
                SSANewInstruction result = this.getDeclaringClass().getClassLoader().getInstructionFactory().NewInstruction(this.statements.size(), instance, ref);
                this.statements.add(result);
                return result;
            }
            return super.addAllocation(T);
        }
    }

    public static class AstFakeRoot
    extends AbstractRootMethod {
        public AstFakeRoot(MethodReference rootMethod, IClass declaringClass, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, declaringClass, cha, options, cache);
        }

        public AstFakeRoot(MethodReference rootMethod, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, cha, options, cache);
        }

        @Override
        public InducedCFG makeControlFlowGraph(SSAInstruction[] statements) {
            return new AstInducedCFG(statements, this, Everywhere.EVERYWHERE);
        }

        public AstLexicalRead addGlobalRead(TypeReference type, String name) {
            AstLexicalRead s2 = new AstLexicalRead(this.statements.size(), this.nextLocal++, null, name, type);
            this.statements.add(s2);
            return s2;
        }
    }
}

