/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.CAstAnalysisScope;
import com.ibm.wala.cast.loader.SingleClassLoaderFactory;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceFileModule;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.IRView;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;

public class CAstCallGraphUtil {
    public static boolean AVOID_DUMP = true;

    public static SourceFileModule makeSourceModule(URL script, String dir, String name) {
        return CAstCallGraphUtil.makeSourceModule(script, dir + '/' + name);
    }

    public static SourceFileModule makeSourceModule(URL script, String scriptName) {
        String hackedName = script.getFile().replaceAll("%5c", "/").replaceAll("%20", " ");
        File scriptFile = new File(hackedName);
        assert (hackedName.endsWith(scriptName)) : scriptName + " does not match file " + script.getFile();
        return new SourceFileModule(scriptFile, scriptName, null){

            @Override
            public InputStream getInputStream() {
                BOMInputStream bs = new BOMInputStream(super.getInputStream(), false, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE);
                try {
                    if (bs.hasBOM()) {
                        System.err.println("removing BOM " + bs.getBOM());
                    }
                    return bs;
                }
                catch (IOException e) {
                    return super.getInputStream();
                }
            }
        };
    }

    public static AnalysisScope makeScope(String[] files, SingleClassLoaderFactory loaders, Language language) {
        CAstAnalysisScope result = new CAstAnalysisScope(files, loaders, Collections.singleton(language));
        return result;
    }

    public static AnalysisScope makeScope(Module[] files, SingleClassLoaderFactory loaders, Language language) {
        CAstAnalysisScope result = new CAstAnalysisScope(files, loaders, Collections.singleton(language));
        return result;
    }

    public static IAnalysisCacheView makeCache(IRFactory<IMethod> factory) {
        return new AnalysisCacheImpl(factory);
    }

    public static String getShortName(CGNode nd) {
        IMethod method = nd.getMethod();
        return CAstCallGraphUtil.getShortName(method);
    }

    public static String getShortName(IMethod method) {
        String origName;
        String result = origName = method.getName().toString();
        if (origName.equals("do") || origName.equals("ctor")) {
            result = method.getDeclaringClass().getName().toString();
            result = result.substring(result.lastIndexOf(47) + 1);
            if (origName.equals("ctor")) {
                String s2;
                if (result.equals("LFunction") && (s2 = method.toString()).indexOf(40) != -1) {
                    String functionName = s2.substring(s2.indexOf(40) + 1, s2.indexOf(41));
                    functionName = functionName.substring(functionName.lastIndexOf(47) + 1);
                    result = result + ' ' + functionName;
                }
                result = "ctor of " + result;
            }
        }
        return result;
    }

    public static void dumpCG(SSAContextInterpreter interp, PointerAnalysis<? extends InstanceKey> PA, CallGraph CG) {
        if (AVOID_DUMP) {
            return;
        }
        for (CGNode N : CG) {
            System.err.print("callees of node " + CAstCallGraphUtil.getShortName(N) + " : [");
            boolean fst = true;
            for (CGNode n : Iterator2Iterable.make(CG.getSuccNodes(N))) {
                if (fst) {
                    fst = false;
                } else {
                    System.err.print(", ");
                }
                System.err.print(CAstCallGraphUtil.getShortName(n));
            }
            System.err.println("]");
            System.err.println("\nIR of node " + N.getGraphNodeId() + ", context " + N.getContext());
            IRView ir = interp.getIRView(N);
            if (ir != null) {
                System.err.println(ir);
                continue;
            }
            System.err.println("no IR!");
        }
        System.err.println("pointer analysis");
        for (PointerKey n : PA.getPointerKeys()) {
            try {
                System.err.println(n + " --> " + PA.getPointsToSet(n));
            }
            catch (Throwable e) {
                System.err.println("error computing set for " + n);
            }
        }
    }

    public static SourceFileModule[] handleFileNames(String[] fileNameArgs) {
        SourceFileModule[] fileNames = new SourceFileModule[fileNameArgs.length];
        for (int i = 0; i < fileNameArgs.length; ++i) {
            if (new File(fileNameArgs[i]).exists()) {
                try {
                    fileNames[i] = CAstCallGraphUtil.makeSourceModule(new File(fileNameArgs[i]).toURI().toURL(), fileNameArgs[i]);
                }
                catch (MalformedURLException e) {
                    Assertions.UNREACHABLE(e.toString());
                }
                continue;
            }
            URL url = CAstCallGraphUtil.class.getClassLoader().getResource(fileNameArgs[i]);
            fileNames[i] = CAstCallGraphUtil.makeSourceModule(url, fileNameArgs[i]);
        }
        return fileNames;
    }
}

