/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.strings.Atom;
import java.util.Map;

public class CrossLanguageInstanceKeys
implements InstanceKeyFactory {
    private final Map<Atom, InstanceKeyFactory> languageSelectors;

    public CrossLanguageInstanceKeys(Map<Atom, InstanceKeyFactory> languageSelectors) {
        this.languageSelectors = languageSelectors;
    }

    private static Atom getLanguage(TypeReference type) {
        return type.getClassLoader().getLanguage();
    }

    private static Atom getLanguage(NewSiteReference site) {
        return CrossLanguageInstanceKeys.getLanguage(site.getDeclaredType());
    }

    private InstanceKeyFactory getSelector(NewSiteReference site) {
        return this.languageSelectors.get(CrossLanguageInstanceKeys.getLanguage(site));
    }

    private InstanceKeyFactory getSelector(TypeReference type) {
        return this.languageSelectors.get(CrossLanguageInstanceKeys.getLanguage(type));
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        return this.getSelector(allocation).getInstanceKeyForAllocation(node, allocation);
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        return this.getSelector(allocation).getInstanceKeyForMultiNewArray(node, allocation, dim);
    }

    public InstanceKey getInstanceKeyForConstant(TypeReference type, Object S) {
        return this.getSelector(type).getInstanceKeyForConstant(type, S);
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter instr, TypeReference type) {
        assert (this.getSelector(type) != null) : "no instance keys for " + type;
        return this.getSelector(type).getInstanceKeyForPEI(node, instr, type);
    }

    @Override
    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) {
        return this.getSelector(objType).getInstanceKeyForMetadataObject(obj, objType);
    }
}

