/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstPointerKeyFactory;
import com.ibm.wala.cast.ipa.callgraph.ObjectPropertyCatalogKey;
import com.ibm.wala.cast.ipa.callgraph.ReflectedFieldPointerKey;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.strings.Atom;
import java.util.Iterator;
import java.util.LinkedList;

public class DelegatingAstPointerKeys
implements AstPointerKeyFactory {
    private final PointerKeyFactory base;

    public DelegatingAstPointerKeys(PointerKeyFactory base) {
        this.base = base;
    }

    @Override
    public PointerKey getPointerKeyForLocal(CGNode node, int valueNumber) {
        return this.base.getPointerKeyForLocal(node, valueNumber);
    }

    @Override
    public FilteredPointerKey getFilteredPointerKeyForLocal(CGNode node, int valueNumber, FilteredPointerKey.TypeFilter filter) {
        return this.base.getFilteredPointerKeyForLocal(node, valueNumber, filter);
    }

    @Override
    public PointerKey getPointerKeyForReturnValue(CGNode node) {
        return this.base.getPointerKeyForReturnValue(node);
    }

    @Override
    public PointerKey getPointerKeyForExceptionalReturnValue(CGNode node) {
        return this.base.getPointerKeyForExceptionalReturnValue(node);
    }

    @Override
    public PointerKey getPointerKeyForStaticField(IField f) {
        return this.base.getPointerKeyForStaticField(f);
    }

    @Override
    public PointerKey getPointerKeyForObjectCatalog(InstanceKey I2) {
        return new ObjectPropertyCatalogKey(I2);
    }

    @Override
    public PointerKey getPointerKeyForInstanceField(InstanceKey I2, IField f) {
        return this.base.getPointerKeyForInstanceField(I2, f);
    }

    @Override
    public PointerKey getPointerKeyForArrayContents(InstanceKey I2) {
        return this.base.getPointerKeyForArrayContents(I2);
    }

    @Override
    public Iterator<PointerKey> getPointerKeysForReflectedFieldWrite(InstanceKey I2, InstanceKey F) {
        PointerKey ifk;
        LinkedList<PointerKey> result = new LinkedList<PointerKey>();
        if (F instanceof ConstantKey && (ifk = this.getInstanceFieldPointerKeyForConstant(I2, (ConstantKey)F)) != null) {
            result.add(ifk);
        }
        result.add(ReflectedFieldPointerKey.mapped(new ConcreteTypeKey(this.getFieldNameType(F)), I2));
        return result.iterator();
    }

    protected IClass getFieldNameType(InstanceKey F) {
        return F.getConcreteType();
    }

    protected PointerKey getInstanceFieldPointerKeyForConstant(InstanceKey I2, ConstantKey<?> F) {
        IField f;
        Object v = F.getValue();
        if (I2.getConcreteType().getClassLoader().getLanguage().modelConstant(v) && (f = I2.getConcreteType().getField(Atom.findOrCreateUnicodeAtom(String.valueOf(v)))) != null) {
            return this.getPointerKeyForInstanceField(I2, f);
        }
        return null;
    }

    @Override
    public Iterator<PointerKey> getPointerKeysForReflectedFieldRead(InstanceKey I2, InstanceKey F) {
        PointerKey ifk;
        if (F instanceof ConstantKey && (ifk = this.getInstanceFieldPointerKeyForConstant(I2, (ConstantKey)F)) != null) {
            return new NonNullSingletonIterator<PointerKey>(ifk);
        }
        ReflectedFieldPointerKey x = ReflectedFieldPointerKey.mapped(new ConcreteTypeKey(this.getFieldNameType(F)), I2);
        return new NonNullSingletonIterator<PointerKey>(x);
    }
}

