/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstCallGraph;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;

public abstract class ScriptEntryPoints
implements Iterable<Entrypoint> {
    protected final IClassHierarchy cha;
    protected final IClass scriptType;

    public ScriptEntryPoints(IClassHierarchy cha, IClass scriptType) {
        this.cha = cha;
        this.scriptType = scriptType;
    }

    protected abstract CallSiteReference makeScriptSite(IMethod var1, int var2);

    protected boolean keep() {
        return true;
    }

    @Override
    public Iterator<Entrypoint> iterator() {
        HashSet ES = HashSetFactory.make();
        Iterator<IClass> classes = this.scriptType.getClassLoader().iterateAllClasses();
        while (classes.hasNext()) {
            IClass cls = classes.next();
            if (!this.cha.isSubclassOf(cls, this.scriptType) || cls.isAbstract()) continue;
            for (IMethod iMethod : cls.getDeclaredMethods()) {
                if (!this.keep()) continue;
                ES.add(new ScriptEntryPoint(iMethod));
            }
        }
        return ES.iterator();
    }

    public Entrypoint make(String scriptName) {
        IClass cls = this.cha.lookupClass(TypeReference.findOrCreate(this.scriptType.getClassLoader().getReference(), scriptName));
        assert (cls != null && this.cha.isSubclassOf(cls, this.scriptType) && !cls.isAbstract()) : String.valueOf(cls) + " for " + scriptName;
        for (IMethod iMethod : cls.getDeclaredMethods()) {
            if (!this.keep()) continue;
            return new ScriptEntryPoint(iMethod);
        }
        assert (false);
        return null;
    }

    public class ScriptEntryPoint
    extends Entrypoint {
        public ScriptEntryPoint(IMethod scriptCodeBody) {
            super(scriptCodeBody);
        }

        @Override
        public CallSiteReference makeSite(int programCounter) {
            return ScriptEntryPoints.this.makeScriptSite(this.getMethod(), programCounter);
        }

        @Override
        public TypeReference[] getParameterTypes(int i) {
            assert (i == 0);
            if (this.getMethod().isStatic()) {
                return new TypeReference[0];
            }
            return new TypeReference[]{this.getMethod().getDeclaringClass().getReference()};
        }

        @Override
        public int getNumberOfParameters() {
            return this.getMethod().isStatic() ? 0 : 1;
        }

        @Override
        public SSAAbstractInvokeInstruction addCall(AbstractRootMethod m3) {
            CallSiteReference site = this.makeSite(0);
            if (site == null) {
                return null;
            }
            int functionVn = this.getMethod().isStatic() ? -1 : this.makeArgument(m3, 0);
            int[] paramVns = new int[Math.max(0, this.getNumberOfParameters() - 1)];
            for (int j = 0; j < paramVns.length; ++j) {
                paramVns[j] = this.makeArgument(m3, j + 1);
            }
            return ((AstCallGraph.ScriptFakeRoot)m3).addDirectCall(functionVn, paramVns, site);
        }
    }
}

