/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.cha;

import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.ClassHierarchyFactory;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.ComposedIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CrossLanguageClassHierarchy
implements IClassHierarchy {
    private final ClassLoaderFactory loaderFactory;
    private final AnalysisScope analysisScope;
    private final Map<Atom, IClassHierarchy> hierarchies;

    @Override
    public ClassLoaderFactory getFactory() {
        return this.loaderFactory;
    }

    @Override
    public AnalysisScope getScope() {
        return this.analysisScope;
    }

    private IClassHierarchy getHierarchy(Atom language) {
        return this.hierarchies.get(language);
    }

    private IClassHierarchy getHierarchy(IClassLoader loader) {
        return this.getHierarchy(loader.getLanguage().getName());
    }

    private IClassHierarchy getHierarchy(ClassLoaderReference loader) {
        return this.getHierarchy(loader.getLanguage());
    }

    private IClassHierarchy getHierarchy(IClass cls) {
        return this.getHierarchy(cls.getClassLoader());
    }

    private IClassHierarchy getHierarchy(TypeReference cls) {
        return this.getHierarchy(cls.getClassLoader());
    }

    private IClassHierarchy getHierarchy(MethodReference ref) {
        return this.getHierarchy(ref.getDeclaringClass());
    }

    private IClassHierarchy getHierarchy(FieldReference ref) {
        return this.getHierarchy(ref.getDeclaringClass());
    }

    @Override
    public IClassLoader[] getLoaders() {
        HashSet<IClassLoader> loaders = HashSetFactory.make();
        for (ClassLoaderReference loaderReference : this.analysisScope.getLoaders()) {
            loaders.add(this.getLoader(loaderReference));
        }
        return loaders.toArray(new IClassLoader[0]);
    }

    @Override
    public IClassLoader getLoader(ClassLoaderReference loaderRef) {
        return this.getHierarchy(loaderRef).getLoader(loaderRef);
    }

    @Override
    public boolean addClass(IClass klass) {
        return this.getHierarchy(klass).addClass(klass);
    }

    @Override
    public int getNumberOfClasses() {
        int total = 0;
        for (ClassLoaderReference loaderReference : this.analysisScope.getLoaders()) {
            total += this.getLoader(loaderReference).getNumberOfClasses();
        }
        return total;
    }

    @Override
    public boolean isRootClass(IClass c) {
        return this.getHierarchy(c).isRootClass(c);
    }

    @Override
    public IClass getRootClass() {
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public int getNumber(IClass c) {
        return this.getHierarchy(c).getNumber(c);
    }

    @Override
    public Set<IMethod> getPossibleTargets(MethodReference ref) {
        return this.getHierarchy(ref).getPossibleTargets(ref);
    }

    @Override
    public Set<IMethod> getPossibleTargets(IClass receiverClass, MethodReference ref) {
        return this.getHierarchy(ref).getPossibleTargets(receiverClass, ref);
    }

    @Override
    public IMethod resolveMethod(MethodReference m3) {
        return this.getHierarchy(m3).resolveMethod(m3);
    }

    @Override
    public IField resolveField(FieldReference f) {
        return this.getHierarchy(f).resolveField(f);
    }

    @Override
    public IField resolveField(IClass klass, FieldReference f) {
        return this.getHierarchy(klass).resolveField(klass, f);
    }

    @Override
    public IMethod resolveMethod(IClass receiver, Selector selector) {
        return this.getHierarchy(receiver).resolveMethod(receiver, selector);
    }

    @Override
    public IClass lookupClass(TypeReference A2) {
        return this.getHierarchy(A2).lookupClass(A2);
    }

    @Override
    public boolean isInterface(TypeReference type) {
        return this.getHierarchy(type).isInterface(type);
    }

    @Override
    public IClass getLeastCommonSuperclass(IClass A2, IClass B) {
        return this.getHierarchy(A2).getLeastCommonSuperclass(A2, B);
    }

    @Override
    public TypeReference getLeastCommonSuperclass(TypeReference A2, TypeReference B) {
        return this.getHierarchy(A2).getLeastCommonSuperclass(A2, B);
    }

    @Override
    public boolean isSubclassOf(IClass c, IClass T) {
        return this.getHierarchy(c).isSubclassOf(c, T);
    }

    @Override
    public boolean implementsInterface(IClass c, IClass i) {
        return this.getHierarchy(c).implementsInterface(c, i);
    }

    @Override
    public Collection<IClass> computeSubClasses(TypeReference type) {
        return this.getHierarchy(type).computeSubClasses(type);
    }

    @Override
    public Collection<TypeReference> getJavaLangRuntimeExceptionTypes() {
        return this.getHierarchy(TypeReference.JavaLangRuntimeException).getJavaLangErrorTypes();
    }

    @Override
    public Collection<TypeReference> getJavaLangErrorTypes() {
        return this.getHierarchy(TypeReference.JavaLangError).getJavaLangErrorTypes();
    }

    @Override
    public Set<IClass> getImplementors(TypeReference type) {
        return this.getHierarchy(type).getImplementors(type);
    }

    @Override
    public int getNumberOfImmediateSubclasses(IClass klass) {
        return this.getHierarchy(klass).getNumberOfImmediateSubclasses(klass);
    }

    @Override
    public Collection<IClass> getImmediateSubclasses(IClass klass) {
        return this.getHierarchy(klass).getImmediateSubclasses(klass);
    }

    @Override
    public boolean isAssignableFrom(IClass c1, IClass c2) {
        return this.getHierarchy(c1).isAssignableFrom(c1, c2);
    }

    @Override
    public Iterator<IClass> iterator() {
        return new ComposedIterator<ClassLoaderReference, IClass>(this.analysisScope.getLoaders().iterator()){

            @Override
            public Iterator<IClass> makeInner(ClassLoaderReference o) {
                IClassLoader ldr = CrossLanguageClassHierarchy.this.getLoader(o);
                return ldr.iterateAllClasses();
            }
        };
    }

    private CrossLanguageClassHierarchy(AnalysisScope scope, ClassLoaderFactory factory, Map<Atom, IClassHierarchy> hierarchies) {
        this.analysisScope = scope;
        this.loaderFactory = factory;
        this.hierarchies = hierarchies;
    }

    public static CrossLanguageClassHierarchy make(AnalysisScope scope, ClassLoaderFactory factory) throws ClassHierarchyException {
        Set<Language> languages = scope.getBaseLanguages();
        HashMap<Atom, IClassHierarchy> hierarchies = HashMapFactory.make();
        for (Language L : languages) {
            HashSet<Language> ll = HashSetFactory.make(L.getDerivedLanguages());
            ll.add(L);
            hierarchies.put(L.getName(), ClassHierarchyFactory.make(scope, factory, ll));
        }
        return new CrossLanguageClassHierarchy(scope, factory, hierarchies);
    }

    @Override
    public Set<TypeReference> getUnresolvedClasses() {
        return HashSetFactory.make();
    }
}

