/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.lexical;

import com.ibm.wala.cast.ipa.callgraph.ScopeMappingInstanceKeys;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphTransitiveClosure;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class LexicalModRef {
    private final CallGraph cg;
    private final PointerAnalysis<InstanceKey> pa;

    public static LexicalModRef make(CallGraph cg, PointerAnalysis<InstanceKey> pa) {
        return new LexicalModRef(cg, pa);
    }

    protected LexicalModRef(CallGraph cg, PointerAnalysis<InstanceKey> pa) {
        this.cg = cg;
        this.pa = pa;
    }

    public Map<CGNode, OrdinalSet<Pair<CGNode, String>>> computeLexicalRef() {
        Map scan = CallGraphTransitiveClosure.collectNodeResults(this.cg, this::scanNodeForLexReads);
        return CallGraphTransitiveClosure.transitiveClosure(this.cg, scan);
    }

    public Map<CGNode, OrdinalSet<Pair<CGNode, String>>> computeLexicalMod() {
        Map scan = CallGraphTransitiveClosure.collectNodeResults(this.cg, this::scanNodeForLexWrites);
        return CallGraphTransitiveClosure.transitiveClosure(this.cg, scan);
    }

    protected Collection<Pair<CGNode, String>> scanNodeForLexReads(CGNode n) {
        HashSet<Pair<CGNode, String>> result = HashSetFactory.make();
        IR ir = n.getIR();
        if (ir != null) {
            for (SSAInstruction instr : Iterator2Iterable.make(ir.iterateNormalInstructions())) {
                if (!(instr instanceof AstLexicalRead)) continue;
                AstLexicalRead read = (AstLexicalRead)instr;
                for (AstLexicalAccess.Access a : read.getAccesses()) {
                    Pair<String, String> nameAndDefiner = a.getName();
                    result.addAll(this.getNodeNamePairsForAccess(n, nameAndDefiner));
                }
            }
        }
        return result;
    }

    protected Collection<Pair<CGNode, String>> scanNodeForLexWrites(CGNode n) {
        HashSet<Pair<CGNode, String>> result = HashSetFactory.make();
        IR ir = n.getIR();
        if (ir != null) {
            for (SSAInstruction instr : Iterator2Iterable.make(ir.iterateNormalInstructions())) {
                if (!(instr instanceof AstLexicalWrite)) continue;
                AstLexicalWrite write = (AstLexicalWrite)instr;
                for (AstLexicalAccess.Access a : write.getAccesses()) {
                    Pair<String, String> nameAndDefiner = a.getName();
                    result.addAll(this.getNodeNamePairsForAccess(n, nameAndDefiner));
                }
            }
        }
        return result;
    }

    private Collection<Pair<CGNode, String>> getNodeNamePairsForAccess(CGNode n, Pair<String, String> nameAndDefiner) {
        HashSet<Pair<CGNode, String>> result = HashSetFactory.make();
        OrdinalSet<InstanceKey> functionValues = this.pa.getPointsToSet(this.pa.getHeapModel().getPointerKeyForLocal(n, 1));
        for (InstanceKey ik : functionValues) {
            if (!(ik instanceof ScopeMappingInstanceKeys.ScopeMappingInstanceKey)) continue;
            ScopeMappingInstanceKeys.ScopeMappingInstanceKey smik = (ScopeMappingInstanceKeys.ScopeMappingInstanceKey)ik;
            for (CGNode definerNode : Iterator2Iterable.make(smik.getFunargNodes(nameAndDefiner))) {
                result.add(Pair.make(definerNode, nameAndDefiner.fst));
            }
        }
        return result;
    }
}

