/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.cfg.Util;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.collections.ArrayIterator;
import com.ibm.wala.util.collections.IntStack;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.dominators.DominanceFrontiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractSSAConversion {
    protected final SSACFG CFG;
    protected final DominanceFrontiers<ISSABasicBlock> DF;
    private final Graph<ISSABasicBlock> dominatorTree;
    protected final int[] phiCounts;
    protected final SSAInstruction[] instructions;
    private final int[] flags;
    protected final SymbolTable symbolTable;
    protected final SSAOptions.DefaultValues defaultValues;
    protected IntStack[] S;
    protected int[] C;
    protected int[] valueMap;
    private Set<SSACFG.BasicBlock>[] assignmentMap;

    protected abstract int getNumberOfDefs(SSAInstruction var1);

    protected abstract int getDef(SSAInstruction var1, int var2);

    protected abstract int getNumberOfUses(SSAInstruction var1);

    protected abstract int getUse(SSAInstruction var1, int var2);

    protected abstract boolean isAssignInstruction(SSAInstruction var1);

    protected abstract int getMaxValueNumber();

    protected abstract boolean isLive(SSACFG.BasicBlock var1, int var2);

    protected abstract boolean skip(int var1);

    protected abstract boolean isConstant(int var1);

    protected abstract int getNextNewValueNumber();

    protected abstract void initializeVariables();

    protected abstract void repairExit();

    protected abstract void placeNewPhiAt(int var1, SSACFG.BasicBlock var2);

    protected abstract SSAPhiInstruction getPhi(SSACFG.BasicBlock var1, int var2);

    protected abstract void setPhi(SSACFG.BasicBlock var1, int var2, SSAPhiInstruction var3);

    protected abstract SSAPhiInstruction repairPhiDefs(SSAPhiInstruction var1, int[] var2);

    protected abstract void repairPhiUse(SSACFG.BasicBlock var1, int var2, int var3, int var4);

    protected abstract void repairInstructionUses(SSAInstruction var1, int var2, int[] var3);

    protected abstract void repairInstructionDefs(SSAInstruction var1, int var2, int[] var3, int[] var4);

    protected abstract void pushAssignment(SSAInstruction var1, int var2, int var3);

    protected abstract void popAssignment(SSAInstruction var1, int var2);

    protected AbstractSSAConversion(IR ir, SSAOptions options) {
        this.CFG = ir.getControlFlowGraph();
        this.DF = new DominanceFrontiers<SSACFG.BasicBlock>(ir.getControlFlowGraph(), ir.getControlFlowGraph().entry());
        this.dominatorTree = this.DF.dominatorTree();
        this.flags = new int[2 * ir.getControlFlowGraph().getNumberOfNodes()];
        this.instructions = this.getInstructions(ir);
        this.phiCounts = new int[this.CFG.getNumberOfNodes()];
        this.symbolTable = ir.getSymbolTable();
        this.defaultValues = options.getDefaultValues();
    }

    protected void perform() {
        this.init();
        this.placePhiNodes();
        this.renameVariables();
    }

    protected SSAInstruction[] getInstructions(IR ir) {
        return ir.getInstructions();
    }

    protected final Iterator<SSAInstruction> iterateInstructions(IR ir) {
        return new ArrayIterator<SSAInstruction>(this.getInstructions(ir));
    }

    protected void init() {
        this.S = new IntStack[this.getMaxValueNumber() + 1];
        this.C = new int[this.getMaxValueNumber() + 1];
        this.valueMap = new int[this.getMaxValueNumber() + 1];
        this.makeAssignmentMap();
    }

    private void makeAssignmentMap() {
        this.assignmentMap = new Set[this.getMaxValueNumber() + 1];
        for (ISSABasicBlock issaBasicBlock : this.CFG) {
            SSACFG.BasicBlock BB = (SSACFG.BasicBlock)issaBasicBlock;
            if (BB.getFirstInstructionIndex() < 0) continue;
            for (SSAInstruction inst : BB) {
                if (inst == null) continue;
                for (int j = 0; j < this.getNumberOfDefs(inst); ++j) {
                    this.addDefiningBlock(this.assignmentMap, BB, this.getDef(inst, j));
                }
            }
        }
    }

    private void addDefiningBlock(Set<SSACFG.BasicBlock>[] A2, SSACFG.BasicBlock BB, int i) {
        if (!this.skip(i)) {
            if (A2[i] == null) {
                A2[i] = new LinkedHashSet<SSACFG.BasicBlock>(2);
            }
            A2[i].add(BB);
        }
    }

    protected void placePhiNodes() {
        Object X;
        int IterCount = 0;
        for (ISSABasicBlock issaBasicBlock : this.CFG) {
            X = (SSACFG.BasicBlock)issaBasicBlock;
            this.setHasAlready((SSACFG.BasicBlock)X, 0);
            this.setWork((SSACFG.BasicBlock)X, 0);
        }
        LinkedHashSet<SSACFG.BasicBlock> W = new LinkedHashSet<SSACFG.BasicBlock>();
        for (int V = 0; V < this.assignmentMap.length; ++V) {
            if (this.assignmentMap[V] == null || this.skip(V)) continue;
            ++IterCount;
            for (SSACFG.BasicBlock X2 : this.assignmentMap[V]) {
                this.setWork(X2, IterCount);
                W.add(X2);
            }
            while (!W.isEmpty()) {
                X = (SSACFG.BasicBlock)W.iterator().next();
                W.remove(X);
                for (ISSABasicBlock IY : Iterator2Iterable.make(this.DF.getDominanceFrontier((ISSABasicBlock)X))) {
                    SSACFG.BasicBlock Y = (SSACFG.BasicBlock)IY;
                    if (this.getHasAlready(Y) >= IterCount) continue;
                    if (this.isLive(Y, V)) {
                        this.placeNewPhiAt(V, Y);
                        int n = Y.getGraphNodeId();
                        this.phiCounts[n] = this.phiCounts[n] + 1;
                    }
                    this.setHasAlready(Y, IterCount);
                    if (this.getWork(Y) >= IterCount) continue;
                    this.setWork(Y, IterCount);
                    W.add(Y);
                }
            }
        }
    }

    private int getWork(SSACFG.BasicBlock BB) {
        return this.flags[BB.getGraphNodeId() * 2 + 1];
    }

    private void setWork(SSACFG.BasicBlock BB, int v) {
        this.flags[BB.getGraphNodeId() * 2 + 1] = v;
    }

    private int getHasAlready(SSACFG.BasicBlock BB) {
        return this.flags[BB.getGraphNodeId() * 2];
    }

    private void setHasAlready(SSACFG.BasicBlock BB, int v) {
        this.flags[BB.getGraphNodeId() * 2] = v;
    }

    private void renameVariables() {
        for (int V = 1; V <= this.getMaxValueNumber(); ++V) {
            if (this.skip(V)) continue;
            this.C[V] = 0;
            this.S[V] = new IntStack();
        }
        this.initializeVariables();
        this.SEARCH(this.CFG.entry());
    }

    private void SEARCH(SSACFG.BasicBlock X) {
        ArrayList stack = new ArrayList();
        this.SearchPreRec(X);
        AbstractSSAConversion.push(stack, new Frame(X, this.dominatorTree.getSuccNodes(X)));
        while (!stack.isEmpty()) {
            Frame f = (Frame)AbstractSSAConversion.peek(stack);
            if (f.i.hasNext()) {
                SSACFG.BasicBlock next = (SSACFG.BasicBlock)f.i.next();
                this.SearchPreRec(next);
                AbstractSSAConversion.push(stack, new Frame(next, this.dominatorTree.getSuccNodes(next)));
                continue;
            }
            this.SearchPostRec(f.X);
            AbstractSSAConversion.pop(stack);
        }
    }

    private static <T> void push(ArrayList<T> stack, T elt) {
        stack.add(elt);
    }

    private static <T> T peek(ArrayList<T> stack) {
        return stack.get(stack.size() - 1);
    }

    private static <T> T pop(ArrayList<T> stack) {
        T e = stack.get(stack.size() - 1);
        stack.remove(stack.size() - 1);
        return e;
    }

    private void SearchPreRec(SSACFG.BasicBlock X) {
        int i;
        int id = X.getGraphNodeId();
        int Xf = X.getFirstInstructionIndex();
        for (i = 0; i < this.phiCounts[id]; ++i) {
            SSAPhiInstruction phi = this.getPhi(X, i);
            if (this.skipRepair(phi, -1)) continue;
            this.setPhi(X, i, this.repairPhiDefs(phi, this.makeNewDefs(phi)));
        }
        for (i = Xf; i <= X.getLastInstructionIndex(); ++i) {
            SSAInstruction inst = this.instructions[i];
            if (this.isAssignInstruction(inst)) {
                int lhs = this.getDef(inst, 0);
                int rhs = this.getUse(inst, 0);
                int newRhs = this.skip(rhs) ? rhs : this.top(rhs);
                this.S[lhs].push(newRhs);
                this.pushAssignment(inst, i, newRhs);
                continue;
            }
            if (this.skipRepair(inst, i)) continue;
            int[] newUses = this.makeNewUses(inst);
            this.repairInstructionUses(inst, i, newUses);
            int[] newDefs = this.makeNewDefs(inst);
            this.repairInstructionDefs(inst, i, newDefs, newUses);
        }
        if (X.isExitBlock()) {
            this.repairExit();
        }
        for (ISSABasicBlock IY : Iterator2Iterable.make(this.CFG.getSuccNodes(X))) {
            SSACFG.BasicBlock Y = (SSACFG.BasicBlock)IY;
            int Y_id = Y.getGraphNodeId();
            int j = Util.whichPred(this.CFG, Y, X);
            for (int i2 = 0; i2 < this.phiCounts[Y_id]; ++i2) {
                SSAPhiInstruction phi = this.getPhi(Y, i2);
                int oldUse = this.getUse(phi, j);
                int newUse = this.skip(oldUse) ? oldUse : this.top(oldUse);
                this.repairPhiUse(Y, i2, j, newUse);
            }
        }
    }

    private void SearchPostRec(SSACFG.BasicBlock X) {
        int j;
        SSAInstruction A2;
        int i;
        int id = X.getGraphNodeId();
        int Xf = X.getFirstInstructionIndex();
        for (i = 0; i < this.phiCounts[id]; ++i) {
            A2 = this.getPhi(X, i);
            for (j = 0; j < this.getNumberOfDefs(A2); ++j) {
                if (this.skip(this.getDef(A2, j))) continue;
                this.S[this.valueMap[this.getDef(A2, j)]].pop();
            }
        }
        for (i = Xf; i <= X.getLastInstructionIndex(); ++i) {
            A2 = this.instructions[i];
            if (this.isAssignInstruction(A2)) {
                this.S[this.getDef(A2, 0)].pop();
                this.popAssignment(A2, i);
                continue;
            }
            if (A2 == null) continue;
            for (j = 0; j < this.getNumberOfDefs(A2); ++j) {
                if (this.skip(this.getDef(A2, j))) continue;
                this.S[this.valueMap[this.getDef(A2, j)]].pop();
            }
        }
    }

    private int[] makeNewUses(SSAInstruction inst) {
        int[] newUses = new int[this.getNumberOfUses(inst)];
        for (int j = 0; j < this.getNumberOfUses(inst); ++j) {
            newUses[j] = this.skip(this.getUse(inst, j)) ? this.getUse(inst, j) : this.top(this.getUse(inst, j));
        }
        return newUses;
    }

    private int[] makeNewDefs(SSAInstruction inst) {
        int[] newDefs = new int[this.getNumberOfDefs(inst)];
        for (int j = 0; j < this.getNumberOfDefs(inst); ++j) {
            if (this.skip(this.getDef(inst, j))) {
                newDefs[j] = this.getDef(inst, j);
                continue;
            }
            int ii = this.getNextNewValueNumber();
            if (this.valueMap.length <= ii) {
                this.valueMap = Arrays.copyOf(this.valueMap, this.valueMap.length * 2 + ii + 1);
            }
            this.valueMap[ii] = this.getDef(inst, j);
            this.S[this.getDef(inst, j)].push(ii);
            newDefs[j] = ii;
        }
        return newDefs;
    }

    protected boolean skipRepair(SSAInstruction inst, int index) {
        int i;
        if (inst == null) {
            return true;
        }
        for (i = 0; i < this.getNumberOfDefs(inst); ++i) {
            if (this.skip(this.getDef(inst, i))) continue;
            return false;
        }
        for (i = 0; i < this.getNumberOfUses(inst); ++i) {
            if (this.skip(this.getUse(inst, i))) continue;
            return false;
        }
        return true;
    }

    protected void fail(int v) {
        assert (this.isConstant(v) || !this.S[v].isEmpty()) : "bad stack for " + v + " while SSA converting";
    }

    protected boolean hasDefaultValue(int valueNumber) {
        return this.defaultValues != null && this.defaultValues.getDefaultValue(this.symbolTable, valueNumber) != -1;
    }

    protected int getDefaultValue(int valueNumber) {
        return this.defaultValues.getDefaultValue(this.symbolTable, valueNumber);
    }

    protected int top(int v) {
        if (!this.isConstant(v) && this.S[v].isEmpty()) {
            if (this.hasDefaultValue(v)) {
                return this.getDefaultValue(v);
            }
            this.fail(v);
        }
        assert (!this.S[v].isEmpty());
        return this.isConstant(v) ? v : this.S[v].peek();
    }

    private static class Frame {
        public final SSACFG.BasicBlock X;
        public final Iterator<ISSABasicBlock> i;

        public Frame(SSACFG.BasicBlock X, Iterator<ISSABasicBlock> i) {
            this.X = X;
            this.i = i;
        }
    }
}

