/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AstInstructionFactory;
import com.ibm.wala.cast.ir.ssa.AstInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;

public class AstAssertInstruction
extends SSAInstruction {
    private final int value;
    private final boolean fromSpecification;

    public AstAssertInstruction(int iindex, int value, boolean fromSpecification) {
        super(iindex);
        this.value = value;
        this.fromSpecification = fromSpecification;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int i) {
        assert (i == 0);
        return this.value;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((AstInstructionFactory)insts).AssertInstruction(this.iIndex(), uses == null ? this.value : uses[0], this.fromSpecification);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return "assert " + this.getValueString(symbolTable, this.value) + " (fromSpec: " + this.fromSpecification + ')';
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        ((AstInstructionVisitor)v).visitAssert(this);
    }

    @Override
    public int hashCode() {
        return 2177 * this.value;
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return null;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    public boolean isFromSpecification() {
        return this.fromSpecification;
    }
}

