/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.SSAConversion;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ssa.DefaultIRFactory;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAIndirectionData;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Map;

public class AstIRFactory<T extends IMethod>
implements IRFactory<T> {
    public ControlFlowGraph<?, ?> makeCFG(IMethod method) {
        return ((AstMethod)method).getControlFlowGraph();
    }

    @Override
    public IR makeIR(IMethod method, Context context, SSAOptions options) {
        assert (method instanceof AstMethod) : method.toString();
        AbstractCFG<?, ?> oldCfg = ((AstMethod)method).cfg();
        SSAInstruction[] oldInstrs = (SSAInstruction[])oldCfg.getInstructions();
        SSAInstruction[] instrs = (SSAInstruction[])oldInstrs.clone();
        AstIR newIR = new AstIR((AstMethod)method, instrs, ((AstMethod)method).symbolTable().copy(), new SSACFG(method, oldCfg, instrs), options);
        return newIR;
    }

    public static IRFactory<IMethod> makeDefaultFactory() {
        return new AstDefaultIRFactory();
    }

    @Override
    public boolean contextIsIrrelevant(IMethod method) {
        return true;
    }

    public static class AstIR
    extends IR {
        private final AstMethod.LexicalInformation lexicalInfo;
        private final SSAConversion.SSAInformation localMap;

        public AstMethod.LexicalInformation lexicalInfo() {
            return this.lexicalInfo;
        }

        private void setCatchInstructions(SSACFG ssacfg, AbstractCFG<?, ?> oldcfg) {
            for (int i = 0; i < oldcfg.getNumberOfNodes(); ++i) {
                if (oldcfg.isCatchBlock(i)) {
                    SSACFG.ExceptionHandlerBasicBlock B = (SSACFG.ExceptionHandlerBasicBlock)ssacfg.getNode(i);
                    B.setCatchInstruction((SSAGetCaughtExceptionInstruction)this.getInstructions()[B.getFirstInstructionIndex()]);
                    this.getInstructions()[B.getFirstInstructionIndex()] = null;
                    continue;
                }
                assert (!(ssacfg.getNode(i) instanceof SSACFG.ExceptionHandlerBasicBlock));
            }
        }

        private static void setupCatchTypes(SSACFG cfg, Map<IBasicBlock<SSAInstruction>, TypeReference[]> map) {
            for (Map.Entry<IBasicBlock<SSAInstruction>, TypeReference[]> e : map.entrySet()) {
                if (e.getKey().getNumber() == -1) continue;
                SSACFG.ExceptionHandlerBasicBlock bb = (SSACFG.ExceptionHandlerBasicBlock)cfg.getNode(e.getKey().getNumber());
                for (int j = 0; j < e.getValue().length; ++j) {
                    bb.addCaughtExceptionType(e.getValue()[j]);
                }
            }
        }

        @Override
        public SSAConversion.SSAInformation getLocalMap() {
            return this.localMap;
        }

        @Override
        protected String instructionPosition(int instructionIndex) {
            CAstSourcePositionMap.Position pos = this.getMethod().getSourcePosition(instructionIndex);
            if (pos == null) {
                return "";
            }
            return pos.toString();
        }

        @Override
        public AstMethod getMethod() {
            return (AstMethod)super.getMethod();
        }

        private AstIR(AstMethod method, SSAInstruction[] instructions, SymbolTable symbolTable, SSACFG cfg, SSAOptions options) {
            super(method, instructions, symbolTable, cfg, options);
            this.lexicalInfo = method.cloneLexicalInfo();
            this.setCatchInstructions(this.getControlFlowGraph(), method.cfg());
            this.localMap = SSAConversion.convert(method, this, options);
            AstIR.setupCatchTypes(this.getControlFlowGraph(), method.catchTypes());
            this.setupLocationMap();
        }

        protected SSAIndirectionData<SSAIndirectionData.Name> getIndirectionData() {
            return null;
        }
    }

    public static class AstDefaultIRFactory<T extends IMethod>
    extends DefaultIRFactory {
        private final AstIRFactory<T> astFactory;

        public AstDefaultIRFactory() {
            this(new AstIRFactory());
        }

        public AstDefaultIRFactory(AstIRFactory<T> astFactory) {
            this.astFactory = astFactory;
        }

        @Override
        public IR makeIR(IMethod method, Context context, SSAOptions options) {
            if (method instanceof AstMethod) {
                return this.astFactory.makeIR(method, context, options);
            }
            return super.makeIR(method, context, options);
        }

        @Override
        public ControlFlowGraph<?, ?> makeCFG(IMethod method, Context context) {
            if (method instanceof AstMethod) {
                return this.astFactory.makeCFG(method);
            }
            return super.makeCFG(method, context);
        }
    }
}

