/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AstInstructionFactory;
import com.ibm.wala.cast.ir.ssa.AstInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.Collections;

public class AstIsDefinedInstruction
extends SSAInstruction {
    private final FieldReference fieldRef;
    private final int fieldVal;
    private final int rval;
    private final int lval;

    public AstIsDefinedInstruction(int iindex, int lval, int rval, int fieldVal, FieldReference fieldRef) {
        super(iindex);
        this.lval = lval;
        this.rval = rval;
        this.fieldVal = fieldVal;
        this.fieldRef = fieldRef;
    }

    public AstIsDefinedInstruction(int iindex, int lval, int rval, FieldReference fieldRef) {
        super(iindex);
        this.lval = lval;
        this.rval = rval;
        this.fieldVal = -1;
        this.fieldRef = fieldRef;
    }

    public AstIsDefinedInstruction(int iindex, int lval, int rval, int fieldVal) {
        super(iindex);
        this.lval = lval;
        this.rval = rval;
        this.fieldVal = fieldVal;
        this.fieldRef = null;
    }

    public AstIsDefinedInstruction(int iindex, int lval, int rval) {
        super(iindex);
        this.lval = lval;
        this.rval = rval;
        this.fieldVal = -1;
        this.fieldRef = null;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        assert (this.fieldVal == -1 || this.fieldRef == null);
        return ((AstInstructionFactory)insts).IsDefinedInstruction(this.iIndex(), defs == null ? this.lval : defs[0], uses == null ? this.rval : uses[0], uses == null || this.fieldVal == -1 ? this.fieldVal : uses[1], this.fieldRef);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        if (this.fieldVal == -1 && this.fieldRef == null) {
            return this.getValueString(symbolTable, this.lval) + " = isDefined(" + this.getValueString(symbolTable, this.rval) + ')';
        }
        if (this.fieldVal == -1) {
            return this.getValueString(symbolTable, this.lval) + " = isDefined(" + this.getValueString(symbolTable, this.rval) + ',' + this.fieldRef.getName() + ')';
        }
        if (this.fieldRef == null) {
            return this.getValueString(symbolTable, this.lval) + " = isDefined(" + this.getValueString(symbolTable, this.rval) + ',' + this.getValueString(symbolTable, this.fieldVal) + ')';
        }
        Assertions.UNREACHABLE();
        return null;
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        ((AstInstructionVisitor)v).visitIsDefined(this);
    }

    @Override
    public Collection<TypeReference> getExceptionTypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.lval;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.lval;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getNumberOfUses() {
        return this.fieldVal == -1 ? 1 : 2;
    }

    @Override
    public int getUse(int j) {
        if (j == 0) {
            return this.rval;
        }
        if (j == 1 && this.fieldVal != -1) {
            return this.fieldVal;
        }
        Assertions.UNREACHABLE();
        return -1;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    @Override
    public int hashCode() {
        return 3077 * this.fieldVal * this.rval;
    }

    public FieldReference getFieldRef() {
        return this.fieldRef;
    }
}

