/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa.analysis;

import com.ibm.wala.cast.ir.cfg.Util;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;

public class LiveAnalysis {
    public static Result perform(IR ir) {
        return LiveAnalysis.perform(ir.getControlFlowGraph(), ir.getSymbolTable());
    }

    public static Result perform(ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, SymbolTable symtab) {
        return LiveAnalysis.perform(cfg, symtab, new BitVector());
    }

    public static Result perform(final ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, final SymbolTable symtab, final BitVector considerLiveAtExit) {
        final BitVectorIntSet liveAtExit = new BitVectorIntSet(considerLiveAtExit);
        final SSAInstruction[] instructions = cfg.getInstructions();
        final BitVectorSolver<ISSABasicBlock> S = new BitVectorSolver<ISSABasicBlock>(new IKilldallFramework<ISSABasicBlock, BitVectorVariable>(){
            private final Graph<ISSABasicBlock> G;
            {
                this.G = GraphInverter.invert(cfg);
            }

            @Override
            public Graph<ISSABasicBlock> getFlowGraph() {
                return this.G;
            }

            @Override
            public ITransferFunctionProvider<ISSABasicBlock, BitVectorVariable> getTransferFunctionProvider() {
                return new ITransferFunctionProvider<ISSABasicBlock, BitVectorVariable>(){

                    @Override
                    public boolean hasNodeTransferFunctions() {
                        return true;
                    }

                    @Override
                    public boolean hasEdgeTransferFunctions() {
                        return false;
                    }

                    @Override
                    public UnaryOperator<BitVectorVariable> getNodeTransferFunction(ISSABasicBlock node) {
                        if (node.isExitBlock()) {
                            final class ExitBlockGenKillOperator
                            extends UnaryOperator<BitVectorVariable> {
                                final /* synthetic */ BitVector val$considerLiveAtExit;
                                final /* synthetic */ BitVectorIntSet val$liveAtExit;

                                ExitBlockGenKillOperator() {
                                    this.val$considerLiveAtExit = bitVector;
                                    this.val$liveAtExit = bitVectorIntSet;
                                }

                                @Override
                                public String toString() {
                                    return "ExitGenKill";
                                }

                                @Override
                                public boolean equals(Object o) {
                                    return o == this;
                                }

                                @Override
                                public int hashCode() {
                                    return 37721;
                                }

                                @Override
                                public byte evaluate(BitVectorVariable lhs, BitVectorVariable rhs) {
                                    boolean changed = lhs.getValue() == null ? !this.val$considerLiveAtExit.isZero() : !lhs.getValue().sameValue(this.val$liveAtExit);
                                    lhs.addAll(this.val$considerLiveAtExit);
                                    return changed ? (byte)1 : 0;
                                }
                            }
                            return new ExitBlockGenKillOperator(considerLiveAtExit, liveAtExit);
                        }
                        final class BlockValueGenKillOperator
                        extends UnaryOperator<BitVectorVariable> {
                            private final ISSABasicBlock block;
                            final /* synthetic */ SymbolTable val$symtab;
                            final /* synthetic */ ControlFlowGraph val$cfg;
                            final /* synthetic */ SSAInstruction[] val$instructions;

                            BlockValueGenKillOperator(ISSABasicBlock block) {
                                this.val$symtab = symbolTable;
                                this.val$cfg = controlFlowGraph;
                                this.val$instructions = sSAInstructionArray;
                                this.block = block;
                            }

                            @Override
                            public String toString() {
                                return "GenKill:" + this.block;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof BlockValueGenKillOperator && ((BlockValueGenKillOperator)o).block.equals(this.block);
                            }

                            @Override
                            public int hashCode() {
                                return this.block.hashCode() * 17;
                            }

                            private void processDefs(SSAInstruction inst, BitVector bits) {
                                for (int j = 0; j < inst.getNumberOfDefs(); ++j) {
                                    bits.clear(inst.getDef(j));
                                }
                            }

                            private void processUses(SSAInstruction inst, BitVector bits) {
                                for (int j = 0; j < inst.getNumberOfUses(); ++j) {
                                    assert (inst.getUse(j) != -1) : inst.toString();
                                    if (this.val$symtab.isConstant(inst.getUse(j))) continue;
                                    bits.set(inst.getUse(j));
                                }
                            }

                            @Override
                            public byte evaluate(BitVectorVariable lhs, BitVectorVariable rhs) {
                                BitVectorIntSet bits = new BitVectorIntSet();
                                IntSet s2 = rhs.getValue();
                                if (s2 != null) {
                                    bits.addAll(s2);
                                }
                                for (ISSABasicBlock iSSABasicBlock : Iterator2Iterable.make(this.val$cfg.getSuccNodes(this.block))) {
                                    int rval = Util.whichPred(this.val$cfg, iSSABasicBlock, this.block);
                                    for (SSAPhiInstruction sphi : Iterator2Iterable.make(iSSABasicBlock.iteratePhis())) {
                                        bits.add(sphi.getUse(rval));
                                    }
                                }
                                for (int i = this.block.getLastInstructionIndex(); i >= this.block.getFirstInstructionIndex(); --i) {
                                    SSAInstruction sSAInstruction = this.val$instructions[i];
                                    if (sSAInstruction == null) continue;
                                    this.processDefs(sSAInstruction, bits.getBitVector());
                                    this.processUses(sSAInstruction, bits.getBitVector());
                                }
                                for (SSAInstruction sSAInstruction : Iterator2Iterable.make(this.block.iteratePhis())) {
                                    this.processDefs(sSAInstruction, bits.getBitVector());
                                }
                                BitVectorVariable U = new BitVectorVariable();
                                U.addAll(bits.getBitVector());
                                if (!lhs.sameValue(U)) {
                                    lhs.copyState(U);
                                    return 1;
                                }
                                return 0;
                            }
                        }
                        return new BlockValueGenKillOperator(node, symtab, cfg, instructions);
                    }

                    @Override
                    public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(ISSABasicBlock s2, ISSABasicBlock d) {
                        Assertions.UNREACHABLE();
                        return null;
                    }

                    @Override
                    public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
                        return BitVectorUnion.instance();
                    }
                };
            }
        });
        try {
            S.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException(e);
        }
        return new Result(){

            public String toString() {
                StringBuilder s2 = new StringBuilder();
                for (int i = 0; i < cfg.getNumberOfNodes(); ++i) {
                    ISSABasicBlock bb = (ISSABasicBlock)cfg.getNode(i);
                    s2.append("live entering ").append(bb).append(':').append(S.getOut(bb)).append('\n');
                    s2.append("live exiting ").append(bb).append(':').append(S.getIn(bb)).append('\n');
                }
                return s2.toString();
            }

            @Override
            public boolean isLiveEntry(ISSABasicBlock bb, int valueNumber) {
                return ((BitVectorVariable)S.getOut(bb)).get(valueNumber);
            }

            @Override
            public boolean isLiveExit(ISSABasicBlock bb, int valueNumber) {
                return ((BitVectorVariable)S.getIn(bb)).get(valueNumber);
            }

            @Override
            public BitVector getLiveBefore(int instr) {
                ISSABasicBlock bb = (ISSABasicBlock)cfg.getBlockForInstruction(instr);
                BitVectorIntSet bits = new BitVectorIntSet();
                IntSet s2 = ((BitVectorVariable)S.getIn(bb)).getValue();
                if (s2 != null) {
                    bits.addAll(s2);
                }
                for (int i = bb.getLastInstructionIndex(); i >= instr; --i) {
                    int j;
                    SSAInstruction inst = instructions[i];
                    if (inst == null) continue;
                    for (j = 0; j < inst.getNumberOfDefs(); ++j) {
                        bits.remove(inst.getDef(j));
                    }
                    for (j = 0; j < inst.getNumberOfUses(); ++j) {
                        if (symtab.isConstant(inst.getUse(j))) continue;
                        bits.add(inst.getUse(j));
                    }
                }
                return bits.getBitVector();
            }
        };
    }

    public static interface Result {
        public boolean isLiveEntry(ISSABasicBlock var1, int var2);

        public boolean isLiveExit(ISSABasicBlock var1, int var2);

        public BitVector getLiveBefore(int var1);
    }
}

