/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.translator;

import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstInstructionFactory;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.AstYieldInstruction;
import com.ibm.wala.cast.ir.ssa.CAstBinaryOp;
import com.ibm.wala.cast.ir.ssa.CAstUnaryOp;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.ir.translator.ArrayOpHandler;
import com.ibm.wala.cast.ir.translator.ExposedNamesCollector;
import com.ibm.wala.cast.ir.translator.TranslatorToIR;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.loader.CAstAbstractLoader;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstSymbol;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.tree.impl.CAstOperator;
import com.ibm.wala.cast.tree.impl.CAstSymbolImpl;
import com.ibm.wala.cast.tree.impl.CAstSymbolImplBase;
import com.ibm.wala.cast.tree.rewrite.CAstBasicRewriter;
import com.ibm.wala.cast.tree.rewrite.CAstCloner;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.cast.tree.visit.CAstVisitor;
import com.ibm.wala.cast.types.AstTypeReference;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.cast.util.SourceBuffer;
import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.graph.impl.SparseNumberedGraph;
import com.ibm.wala.util.graph.traverse.DFS;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.warnings.Warning;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;

public abstract class AstTranslator
extends CAstVisitor<WalkContext>
implements ArrayOpHandler,
TranslatorToIR {
    private final ArrayOpHandler arrayOpHandler;
    protected final IClassLoader loader;
    protected final Map<Object, CAstEntity> namedEntityResolver;
    protected final SSAInstructionFactory insts;
    public static final boolean DEBUG_ALL = false;
    public static final boolean DEBUG_TOP = false;
    public static final boolean DEBUG_CFG = false;
    public static final boolean DEBUG_NAMES = false;
    public static final boolean DEBUG_LEXICAL = false;
    private static final boolean DEBUG = false;
    protected Map<CAstEntity, Set<String>> entity2ExposedNames;

    protected abstract boolean useDefaultInitValues();

    protected abstract boolean treatGlobalsAsLexicallyScoped();

    protected boolean topLevelFunctionsInGlobalScope() {
        return true;
    }

    protected abstract TypeReference defaultCatchType();

    protected abstract TypeReference makeType(CAstType var1);

    protected abstract boolean defineType(CAstEntity var1, WalkContext var2);

    protected abstract void declareFunction(CAstEntity var1, WalkContext var2);

    protected abstract void defineFunction(CAstEntity var1, WalkContext var2, AbstractCFG<SSAInstruction, ? extends IBasicBlock<SSAInstruction>> var3, SymbolTable var4, boolean var5, Map<IBasicBlock<SSAInstruction>, TypeReference[]> var6, boolean var7, AstLexicalInformation var8, AstMethod.DebuggingInformation var9);

    protected abstract void defineField(CAstEntity var1, WalkContext var2, CAstEntity var3);

    protected abstract String composeEntityName(WalkContext var1, CAstEntity var2);

    protected abstract void doThrow(WalkContext var1, int var2);

    @Override
    public abstract void doArrayRead(WalkContext var1, int var2, int var3, CAstNode var4, int[] var5);

    @Override
    public abstract void doArrayWrite(WalkContext var1, int var2, CAstNode var3, int[] var4, int var5);

    protected abstract void doFieldRead(WalkContext var1, int var2, int var3, CAstNode var4, CAstNode var5);

    protected abstract void doFieldWrite(WalkContext var1, int var2, CAstNode var3, CAstNode var4, int var5);

    protected abstract void doMaterializeFunction(CAstNode var1, WalkContext var2, int var3, int var4, CAstEntity var5);

    protected abstract void doNewObject(WalkContext var1, CAstNode var2, int var3, Object var4, int[] var5);

    protected abstract void doCall(WalkContext var1, CAstNode var2, int var3, int var4, CAstNode var5, int var6, int[] var7);

    protected abstract CAstType topType();

    protected abstract CAstType exceptionType();

    protected boolean liftDeclarationsForLexicalScoping() {
        return false;
    }

    protected boolean isExceptionLabel(Object label) {
        if (label == null) {
            return false;
        }
        if (label instanceof Boolean) {
            return false;
        }
        if (label instanceof Number) {
            return false;
        }
        return label != CAstControlFlowMap.SWITCH_DEFAULT;
    }

    protected boolean hasImplicitGlobals() {
        return false;
    }

    protected boolean hasSpecialUndeclaredVariables() {
        return false;
    }

    protected void handleUnspecifiedLiteralKey() {
        Assertions.UNREACHABLE();
    }

    protected void doPrologue(WalkContext context) {
        CAstEntity entity = context.top();
        Set<String> exposedNames = this.entity2ExposedNames.get(entity);
        if (exposedNames != null) {
            int i = 0;
            for (String arg : entity.getArgumentNames()) {
                if (!exposedNames.contains(arg)) continue;
                Scope currentScope = context.currentScope();
                Symbol symbol = currentScope.lookup(arg);
                assert (symbol.getDefiningScope() == currentScope);
                int argVN = symbol.valueNumber();
                CAstType type = entity.getType() instanceof CAstType.Method ? ((CAstType.Method)entity.getType()).getArgumentTypes().get(i) : this.topType();
                AstLexicalAccess.Access A2 = new AstLexicalAccess.Access(arg, context.getEntityName(entity), this.makeType(type), argVN);
                context.cfg().addInstruction(new AstLexicalWrite(context.cfg().currentInstruction, A2));
                AstTranslator.addExposedName(entity, entity, arg, argVN, true, context);
            }
        }
    }

    protected abstract void doPrimitive(int var1, WalkContext var2, CAstNode var3);

    protected int doLocalRead(WalkContext context, String name, TypeReference type) {
        CAstEntity entity = context.top();
        Set<String> exposed = this.entity2ExposedNames.get(entity);
        if (exposed != null && exposed.contains(name)) {
            return AstTranslator.doLexReadHelper(context, name, type);
        }
        return context.currentScope().lookup(name).valueNumber();
    }

    protected void doLocalWrite(WalkContext context, String nm, TypeReference type, int rval) {
        CAstEntity entity = context.top();
        Set<String> exposed = this.entity2ExposedNames.get(entity);
        if (exposed != null && exposed.contains(nm)) {
            this.doLexicallyScopedWrite(context, nm, type, rval);
            return;
        }
        int lval = context.currentScope().lookup(nm).valueNumber();
        if (lval != rval) {
            context.cfg().addInstruction(new AssignInstruction(context.cfg().currentInstruction, lval, rval));
        }
    }

    protected int doLexicallyScopedRead(CAstNode node, WalkContext context, String name, TypeReference type) {
        return AstTranslator.doLexReadHelper(context, name, type);
    }

    protected boolean ignoreName(String name) {
        return false;
    }

    private static int doLexReadHelper(WalkContext context, String name, TypeReference type) {
        Symbol S = context.currentScope().lookup(name);
        Scope definingScope = S.getDefiningScope();
        CAstEntity E = definingScope.getEntity();
        AstTranslator.addExposedName(E, E, name, definingScope.lookup(name).valueNumber(), false, context);
        String entityName = context.getEntityName(E);
        int result = context.currentScope().allocateTempValue();
        AstLexicalAccess.Access A2 = new AstLexicalAccess.Access(name, entityName, type, result);
        context.cfg().addInstruction(new AstLexicalRead(context.cfg().currentInstruction, A2));
        AstTranslator.markExposedInEnclosingEntities(context, name, definingScope, type, E, entityName, false);
        return result;
    }

    private static void markExposedInEnclosingEntities(WalkContext context, String name, Scope definingScope, TypeReference type, CAstEntity E, String entityName, boolean isWrite) {
        Scope curScope = context.currentScope();
        while (!curScope.equals(definingScope)) {
            Symbol curSymbol = curScope.lookup(name);
            int vn = curSymbol.valueNumber();
            AstLexicalAccess.Access A2 = new AstLexicalAccess.Access(name, entityName, type, vn);
            CAstEntity entity = curScope.getEntity();
            if (entity != definingScope.getEntity()) {
                AstTranslator.addExposedName(entity, E, name, vn, isWrite, context);
                AstTranslator.addAccess(context, entity, A2);
            }
            curScope = curScope.getParent();
        }
    }

    protected void doLexicallyScopedWrite(WalkContext context, String name, TypeReference type, int rval) {
        Symbol S = context.currentScope().lookup(name);
        Scope definingScope = S.getDefiningScope();
        CAstEntity E = definingScope.getEntity();
        AstTranslator.addExposedName(E, E, name, definingScope.lookup(name).valueNumber(), true, context);
        AstLexicalAccess.Access A2 = new AstLexicalAccess.Access(name, context.getEntityName(E), type, rval);
        context.cfg().addInstruction(new AstLexicalWrite(context.cfg().currentInstruction, A2));
        AstTranslator.markExposedInEnclosingEntities(context, name, definingScope, type, E, context.getEntityName(E), true);
    }

    protected int doGlobalRead(CAstNode node, WalkContext context, String name, TypeReference type) {
        if (this.treatGlobalsAsLexicallyScoped()) {
            int result = context.currentScope().allocateTempValue();
            AstLexicalAccess.Access A2 = new AstLexicalAccess.Access(name, null, type, result);
            context.cfg().addInstruction(new AstLexicalRead(context.cfg().currentInstruction, A2));
            AstTranslator.addAccess(context, context.top(), A2);
            return result;
        }
        int result = context.currentScope().allocateTempValue();
        FieldReference global = this.makeGlobalRef(name);
        context.cfg().addInstruction(new AstGlobalRead(context.cfg().currentInstruction, result, global));
        return result;
    }

    protected void doGlobalWrite(WalkContext context, String name, TypeReference type, int rval) {
        if (this.treatGlobalsAsLexicallyScoped()) {
            AstLexicalAccess.Access A2 = new AstLexicalAccess.Access(name, null, type, rval);
            context.cfg().addInstruction(new AstLexicalWrite(context.cfg().currentInstruction, A2));
            AstTranslator.addAccess(context, context.top(), A2);
        } else {
            FieldReference global = this.makeGlobalRef(name);
            context.cfg().addInstruction(new AstGlobalWrite(context.cfg().currentInstruction, global, rval));
        }
    }

    protected FieldReference makeGlobalRef(String globalName) {
        TypeReference rootTypeRef = TypeReference.findOrCreate(this.loader.getReference(), AstTypeReference.rootTypeName);
        return FieldReference.findOrCreate(rootTypeRef, Atom.findOrCreateUnicodeAtom("global " + globalName), rootTypeRef);
    }

    protected AstTranslator(IClassLoader loader, Map<Object, CAstEntity> namedEntityResolver, ArrayOpHandler arrayOpHandler) {
        this.loader = loader;
        this.namedEntityResolver = namedEntityResolver;
        this.arrayOpHandler = arrayOpHandler != null ? arrayOpHandler : this;
        this.insts = loader.getInstructionFactory();
    }

    protected AstTranslator(IClassLoader loader, Map<Object, CAstEntity> namedEntityResolver) {
        this(loader, namedEntityResolver, null);
    }

    protected AstTranslator(IClassLoader loader) {
        this(loader, null);
    }

    protected AbstractScope makeScriptScope(final CAstEntity s2, Scope parent) {
        return new AbstractScope(parent){
            final SymbolTable scriptGlobalSymtab;
            {
                super(parent);
                this.scriptGlobalSymtab = new SymbolTable(s2.getArgumentCount());
            }

            @Override
            public SymbolTable getUnderlyingSymtab() {
                return this.scriptGlobalSymtab;
            }

            @Override
            protected AbstractScope getEntityScope() {
                return this;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s22) {
                if (this.isGlobal(s22)) {
                    return false;
                }
                return ((AbstractScope)s22.getDefiningScope()).getEntity() != this.getEntity();
            }

            @Override
            public CAstEntity getEntity() {
                return s2;
            }

            @Override
            public ScopeType type() {
                return ScopeType.SCRIPT;
            }

            @Override
            protected Symbol makeSymbol(final String nm, final CAstType type, boolean isFinal, final boolean isInternalName, Object defaultInitValue, int vn, Scope definer) {
                int v;
                assert (nm != null);
                assert (type != null);
                int n = v = vn == -1 ? this.getUnderlyingSymtab().newSymbol() : vn;
                if (AstTranslator.this.useDefaultInitValues() && defaultInitValue != null && this.getUnderlyingSymtab().getValue(v) == null) {
                    AstTranslator.this.setDefaultValue(this.getUnderlyingSymtab(), v, defaultInitValue);
                }
                return new AbstractSymbol(definer, isFinal, defaultInitValue){

                    public String toString() {
                        return nm + ':' + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return type;
                    }

                    @Override
                    public int valueNumber() {
                        return v;
                    }

                    @Override
                    public boolean isInternalName() {
                        return isInternalName;
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }

                    @Override
                    public boolean isGlobal() {
                        return false;
                    }
                };
            }
        };
    }

    protected int getArgumentCount(CAstEntity f) {
        return f.getArgumentCount();
    }

    protected String[] getArgumentNames(CAstEntity f) {
        return f.getArgumentNames();
    }

    private AbstractScope makeFunctionScope(final CAstEntity f, Scope parent) {
        return new AbstractScope(parent){
            private final String[] params;
            private final SymbolTable functionSymtab;
            {
                super(parent);
                this.params = AstTranslator.this.getArgumentNames(f);
                this.functionSymtab = new SymbolTable(AstTranslator.this.getArgumentCount(f));
                int i = 0;
                while (i < AstTranslator.this.getArgumentCount(f)) {
                    final int yuck = i++;
                    this.declare(new CAstSymbol(){

                        @Override
                        public String name() {
                            return params[yuck];
                        }

                        @Override
                        public CAstType type() {
                            if (f.getType() instanceof CAstType.Method) {
                                if (yuck == 0) {
                                    return ((CAstType.Method)f.getType()).getDeclaringType();
                                }
                                return ((CAstType.Method)f.getType()).getArgumentTypes().get(yuck - 1);
                            }
                            if (f.getType() instanceof CAstType.Function) {
                                return ((CAstType.Function)f.getType()).getArgumentTypes().get(yuck);
                            }
                            return AstTranslator.this.topType();
                        }

                        @Override
                        public boolean isFinal() {
                            return false;
                        }

                        @Override
                        public boolean isCaseInsensitive() {
                            return false;
                        }

                        @Override
                        public boolean isInternalName() {
                            return false;
                        }

                        @Override
                        public Object defaultInitValue() {
                            return null;
                        }
                    });
                }
            }

            public String toString() {
                return "scope for " + f.getName();
            }

            @Override
            public SymbolTable getUnderlyingSymtab() {
                return this.functionSymtab;
            }

            @Override
            protected AbstractScope getEntityScope() {
                return this;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s2) {
                if (this.isGlobal(s2)) {
                    return false;
                }
                return ((AbstractScope)s2.getDefiningScope()).getEntity() != this.getEntity();
            }

            @Override
            public CAstEntity getEntity() {
                return f;
            }

            @Override
            public ScopeType type() {
                return ScopeType.FUNCTION;
            }

            private int find(String n) {
                for (int i = 0; i < this.params.length; ++i) {
                    if (!n.equals(this.params[i])) continue;
                    return i + 1;
                }
                return -1;
            }

            @Override
            protected Symbol makeSymbol(final String nm, final CAstType type, boolean isFinal, final boolean isInternalName, final Object defaultInitValue, final int valueNumber, Scope definer) {
                assert (nm != null);
                assert (type != null);
                return new AbstractSymbol(definer, isFinal, defaultInitValue){
                    final int vn;
                    {
                        super(definingScope, isFinalValue, defaultValue);
                        int x = this.find(nm);
                        if (x != -1) {
                            assert (valueNumber == -1);
                            this.vn = x;
                        } else {
                            this.vn = valueNumber != -1 ? valueNumber : this.getUnderlyingSymtab().newSymbol();
                        }
                        if (AstTranslator.this.useDefaultInitValues() && defaultInitValue != null && this.getUnderlyingSymtab().getValue(this.vn) == null) {
                            AstTranslator.this.setDefaultValue(this.getUnderlyingSymtab(), this.vn, defaultInitValue);
                        }
                    }

                    @Override
                    public CAstType type() {
                        return type;
                    }

                    public String toString() {
                        return nm + ':' + System.identityHashCode(this);
                    }

                    @Override
                    public int valueNumber() {
                        return this.vn;
                    }

                    @Override
                    public boolean isInternalName() {
                        return isInternalName;
                    }

                    @Override
                    public boolean isParameter() {
                        return this.vn <= params.length;
                    }

                    @Override
                    public boolean isGlobal() {
                        return false;
                    }
                };
            }
        };
    }

    private Scope makeLocalScope(final Scope parent) {
        return new AbstractScope(parent){

            @Override
            public ScopeType type() {
                return ScopeType.LOCAL;
            }

            @Override
            public SymbolTable getUnderlyingSymtab() {
                return ((AbstractScope)parent).getUnderlyingSymtab();
            }

            @Override
            protected AbstractScope getEntityScope() {
                return ((AbstractScope)parent).getEntityScope();
            }

            @Override
            public boolean isLexicallyScoped(Symbol s2) {
                return this.getEntityScope().isLexicallyScoped(s2);
            }

            @Override
            public CAstEntity getEntity() {
                return this.getEntityScope().getEntity();
            }

            @Override
            protected Symbol makeSymbol(final String nm, final CAstType type, boolean isFinal, final boolean isInternalName, Object defaultInitValue, int vn, Scope definer) {
                int v;
                int n = v = vn == -1 ? this.getUnderlyingSymtab().newSymbol() : vn;
                if (AstTranslator.this.useDefaultInitValues() && defaultInitValue != null && this.getUnderlyingSymtab().getValue(v) == null) {
                    AstTranslator.this.setDefaultValue(this.getUnderlyingSymtab(), v, defaultInitValue);
                }
                assert (nm != null);
                assert (type != null);
                return new AbstractSymbol(definer, isFinal, defaultInitValue){

                    public String toString() {
                        return nm + ':' + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return type;
                    }

                    @Override
                    public int valueNumber() {
                        return v;
                    }

                    @Override
                    public boolean isInternalName() {
                        return isInternalName;
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }

                    @Override
                    public boolean isGlobal() {
                        return false;
                    }
                };
            }
        };
    }

    private Scope makeGlobalScope() {
        final LinkedHashMap globalSymbols = new LinkedHashMap();
        final LinkedHashMap caseInsensitiveNames = new LinkedHashMap();
        return new Scope(){

            public String toString() {
                return "global scope";
            }

            private final String mapName(String nm) {
                String mappedName = (String)caseInsensitiveNames.get(nm.toLowerCase());
                return mappedName == null ? nm : mappedName;
            }

            @Override
            public Scope getParent() {
                return null;
            }

            @Override
            public boolean isGlobal(Symbol s2) {
                return true;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s2) {
                return false;
            }

            @Override
            public CAstEntity getEntity() {
                return null;
            }

            @Override
            public int size() {
                return globalSymbols.size();
            }

            @Override
            public Iterator<String> getAllNames() {
                return globalSymbols.keySet().iterator();
            }

            @Override
            public int allocateTempValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getConstantValue(Object c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getConstantObject(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ScopeType type() {
                return ScopeType.GLOBAL;
            }

            @Override
            public boolean contains(String name) {
                return AstTranslator.this.hasImplicitGlobals() || globalSymbols.containsKey(this.mapName(name));
            }

            @Override
            public boolean isCaseInsensitive(String name) {
                return caseInsensitiveNames.containsKey(name.toLowerCase());
            }

            @Override
            public Symbol lookup(final String name) {
                if (!globalSymbols.containsKey(this.mapName(name))) {
                    if (AstTranslator.this.hasImplicitGlobals()) {
                        this.declare(new CAstSymbol(){

                            @Override
                            public String name() {
                                return name;
                            }

                            @Override
                            public boolean isFinal() {
                                return false;
                            }

                            @Override
                            public boolean isCaseInsensitive() {
                                return false;
                            }

                            @Override
                            public boolean isInternalName() {
                                return false;
                            }

                            @Override
                            public Object defaultInitValue() {
                                return null;
                            }

                            @Override
                            public CAstType type() {
                                return AstTranslator.this.topType();
                            }
                        });
                    } else {
                        if (AstTranslator.this.hasSpecialUndeclaredVariables()) {
                            return null;
                        }
                        throw new UnimplementedError("cannot find " + name);
                    }
                }
                return (Symbol)globalSymbols.get(this.mapName(name));
            }

            @Override
            public void declare(CAstSymbol s2, int vn) {
                assert (vn == -1);
                this.declare(s2);
            }

            @Override
            public void declare(final CAstSymbol s2) {
                final String name = s2.name();
                if (s2.isCaseInsensitive()) {
                    caseInsensitiveNames.put(name.toLowerCase(), name);
                }
                globalSymbols.put(name, new AbstractSymbol(this, s2.isFinal(), s2.defaultInitValue()){

                    public String toString() {
                        return name + ':' + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return s2.type();
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }

                    @Override
                    public boolean isInternalName() {
                        return s2.isInternalName();
                    }

                    @Override
                    public int valueNumber() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isGlobal() {
                        return true;
                    }
                });
            }
        };
    }

    protected Scope makeTypeScope(final CAstEntity type, final Scope parent) {
        final LinkedHashMap typeSymbols = new LinkedHashMap();
        final LinkedHashMap caseInsensitiveNames = new LinkedHashMap();
        return new Scope(){

            private final String mapName(String nm) {
                String mappedName = (String)caseInsensitiveNames.get(nm.toLowerCase());
                return mappedName == null ? nm : mappedName;
            }

            @Override
            public Scope getParent() {
                return parent;
            }

            @Override
            public boolean isGlobal(Symbol s2) {
                return false;
            }

            @Override
            public boolean isLexicallyScoped(Symbol s2) {
                return false;
            }

            @Override
            public CAstEntity getEntity() {
                return type;
            }

            @Override
            public int size() {
                return typeSymbols.size();
            }

            @Override
            public Iterator<String> getAllNames() {
                return typeSymbols.keySet().iterator();
            }

            @Override
            public int allocateTempValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getConstantValue(Object c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isConstant(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getConstantObject(int valueNumber) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ScopeType type() {
                return ScopeType.TYPE;
            }

            @Override
            public boolean contains(String name) {
                return typeSymbols.containsKey(this.mapName(name));
            }

            @Override
            public boolean isCaseInsensitive(String name) {
                return caseInsensitiveNames.containsKey(name.toLowerCase());
            }

            @Override
            public Symbol lookup(String nm) {
                if (typeSymbols.containsKey(this.mapName(nm))) {
                    return (Symbol)typeSymbols.get(this.mapName(nm));
                }
                return parent.lookup(nm);
            }

            @Override
            public void declare(CAstSymbol s2, int vn) {
                assert (vn == -1);
                this.declare(s2);
            }

            @Override
            public void declare(final CAstSymbol s2) {
                final String name = s2.name();
                assert (!s2.isFinal());
                if (s2.isCaseInsensitive()) {
                    caseInsensitiveNames.put(name.toLowerCase(), name);
                }
                typeSymbols.put(name, new AbstractSymbol(this, s2.isFinal(), s2.defaultInitValue()){

                    public String toString() {
                        return name + ':' + System.identityHashCode(this);
                    }

                    @Override
                    public CAstType type() {
                        return s2.type();
                    }

                    @Override
                    public boolean isParameter() {
                        return false;
                    }

                    @Override
                    public boolean isInternalName() {
                        return s2.isInternalName();
                    }

                    @Override
                    public int valueNumber() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isGlobal() {
                        return false;
                    }
                });
            }
        };
    }

    private static void addAccess(WalkContext context, CAstEntity e, AstLexicalAccess.Access access) {
        context.getAccesses(e).add(access);
    }

    private static void addExposedName(CAstEntity entity, CAstEntity declaration, String name, int valueNumber, boolean isWrite, WalkContext context) {
        Pair<Pair<String, String>, Integer> newVal = Pair.make(Pair.make(name, context.getEntityName(declaration)), valueNumber);
        context.exposeNameSet(entity, isWrite).add(newVal);
    }

    @Override
    protected WalkContext getCodeContext(WalkContext context) {
        return context.codeContext();
    }

    public void setDefaultValue(SymbolTable symtab, int vn, Object value) {
        if (value == CAstSymbol.NULL_DEFAULT_VALUE) {
            symtab.setDefaultValue(vn, null);
        } else {
            symtab.setDefaultValue(vn, value);
        }
    }

    protected IUnaryOpInstruction.IOperator translateUnaryOpcode(CAstNode op) {
        if (op == CAstOperator.OP_BITNOT) {
            return CAstUnaryOp.BITNOT;
        }
        if (op == CAstOperator.OP_NOT) {
            return IUnaryOpInstruction.Operator.NEG;
        }
        if (op == CAstOperator.OP_SUB) {
            return CAstUnaryOp.MINUS;
        }
        if (op == CAstOperator.OP_ADD) {
            return CAstUnaryOp.PLUS;
        }
        Assertions.UNREACHABLE("cannot translate " + CAstPrinter.print(op));
        return null;
    }

    protected IBinaryOpInstruction.IOperator translateBinaryOpcode(CAstNode op) {
        if (op == CAstOperator.OP_ADD) {
            return IBinaryOpInstruction.Operator.ADD;
        }
        if (op == CAstOperator.OP_DIV) {
            return IBinaryOpInstruction.Operator.DIV;
        }
        if (op == CAstOperator.OP_LSH) {
            return IShiftInstruction.Operator.SHL;
        }
        if (op == CAstOperator.OP_MOD) {
            return IBinaryOpInstruction.Operator.REM;
        }
        if (op == CAstOperator.OP_MUL) {
            return IBinaryOpInstruction.Operator.MUL;
        }
        if (op == CAstOperator.OP_RSH) {
            return IShiftInstruction.Operator.SHR;
        }
        if (op == CAstOperator.OP_SUB) {
            return IBinaryOpInstruction.Operator.SUB;
        }
        if (op == CAstOperator.OP_URSH) {
            return IShiftInstruction.Operator.USHR;
        }
        if (op == CAstOperator.OP_BIT_AND) {
            return IBinaryOpInstruction.Operator.AND;
        }
        if (op == CAstOperator.OP_BIT_OR) {
            return IBinaryOpInstruction.Operator.OR;
        }
        if (op == CAstOperator.OP_BIT_XOR) {
            return IBinaryOpInstruction.Operator.XOR;
        }
        if (op == CAstOperator.OP_CONCAT) {
            return CAstBinaryOp.CONCAT;
        }
        if (op == CAstOperator.OP_EQ) {
            return CAstBinaryOp.EQ;
        }
        if (op == CAstOperator.OP_STRICT_EQ) {
            return CAstBinaryOp.STRICT_EQ;
        }
        if (op == CAstOperator.OP_GE) {
            return CAstBinaryOp.GE;
        }
        if (op == CAstOperator.OP_GT) {
            return CAstBinaryOp.GT;
        }
        if (op == CAstOperator.OP_LE) {
            return CAstBinaryOp.LE;
        }
        if (op == CAstOperator.OP_LT) {
            return CAstBinaryOp.LT;
        }
        if (op == CAstOperator.OP_NE) {
            return CAstBinaryOp.NE;
        }
        if (op == CAstOperator.OP_STRICT_NE) {
            return CAstBinaryOp.STRICT_NE;
        }
        Assertions.UNREACHABLE("cannot translate " + CAstPrinter.print(op));
        return null;
    }

    protected IConditionalBranchInstruction.IOperator translateConditionOpcode(CAstNode op) {
        if (op == CAstOperator.OP_EQ) {
            return IConditionalBranchInstruction.Operator.EQ;
        }
        if (op == CAstOperator.OP_GE) {
            return IConditionalBranchInstruction.Operator.GE;
        }
        if (op == CAstOperator.OP_GT) {
            return IConditionalBranchInstruction.Operator.GT;
        }
        if (op == CAstOperator.OP_LE) {
            return IConditionalBranchInstruction.Operator.LE;
        }
        if (op == CAstOperator.OP_LT) {
            return IConditionalBranchInstruction.Operator.LT;
        }
        if (op == CAstOperator.OP_NE) {
            return IConditionalBranchInstruction.Operator.NE;
        }
        assert (false) : "cannot translate " + CAstPrinter.print(op);
        return null;
    }

    protected String[] makeNameMap(CAstEntity n, Set<Scope> scopes, SSAInstruction[] insts) {
        String[] map = new String[scopes.iterator().next().size() + 1];
        for (Scope scope : scopes) {
            for (String nm : Iterator2Iterable.make(scope.getAllNames())) {
                Symbol v;
                if (this.ignoreName(nm) || (v = scope.lookup(nm)).isInternalName() || scope.isConstant(v.valueNumber())) continue;
                assert (map[v.valueNumber()] == null || map[v.valueNumber()].equals(nm) || this.ignoreName(map[v.valueNumber()])) : "value number " + v.valueNumber() + " mapped to multiple names in " + n.getName() + ": " + nm + " and " + map[v.valueNumber()];
                map[v.valueNumber()] = nm;
            }
        }
        return map;
    }

    protected static final CAstType getTypeForNode(WalkContext context, CAstNode node) {
        if (context.top().getNodeTypeMap() != null) {
            return context.top().getNodeTypeMap().getNodeType(node);
        }
        return null;
    }

    private CAstSourcePositionMap.Position getPosition(CAstSourcePositionMap map, CAstNode n) {
        if (map.getPosition(n) != null) {
            return map.getPosition(n);
        }
        for (CAstNode child : n.getChildren()) {
            CAstSourcePositionMap.Position p = this.getPosition(map, child);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    protected WalkContext makeFileContext(WalkContext c, CAstEntity n) {
        return new FileContext(c, n.getName());
    }

    @Override
    protected WalkContext makeTypeContext(WalkContext c, CAstEntity n) {
        return new TypeContext(c, n);
    }

    @Override
    protected WalkContext makeCodeContext(WalkContext context, CAstEntity n) {
        AbstractScope scope = n.getKind() == 2 ? this.makeScriptScope(n, context.currentScope()) : this.makeFunctionScope(n, context.currentScope());
        return new CodeEntityContext(context, scope, n);
    }

    @Override
    protected boolean enterEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected boolean visitFileEntity(CAstEntity n, WalkContext context, WalkContext fileContext, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFileEntity(CAstEntity n, WalkContext context, WalkContext fileContext, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitFieldEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFieldEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        CAstEntity topEntity = context.top();
        assert (topEntity.getKind() == 3) : "Parent of field entity is not a type???";
        this.defineField(topEntity, context, n);
    }

    @Override
    protected boolean visitGlobalEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveGlobalEntity(CAstEntity n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        context.getGlobalScope().declare(new CAstSymbolImpl(n.getName(), n.getType()));
    }

    @Override
    protected boolean visitTypeEntity(CAstEntity n, WalkContext context, WalkContext typeContext, CAstVisitor<WalkContext> visitor) {
        return !this.defineType(n, context);
    }

    @Override
    protected void leaveTypeEntity(CAstEntity n, WalkContext context, WalkContext typeContext, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitFunctionEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        if (n.getAST() == null) {
            this.declareFunction(n, context);
        } else {
            this.declareFunction(n, context);
            this.initFunctionEntity(n, codeContext);
        }
        return false;
    }

    @Override
    protected void leaveFunctionEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        if (n.getAST() != null) {
            this.closeFunctionEntity(n, context, codeContext);
        }
    }

    @Override
    protected boolean visitMacroEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        return true;
    }

    @Override
    protected boolean visitScriptEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        this.declareFunction(n, codeContext);
        this.initFunctionEntity(n, codeContext);
        return false;
    }

    @Override
    protected void leaveScriptEntity(CAstEntity n, WalkContext context, WalkContext codeContext, CAstVisitor<WalkContext> visitor) {
        this.closeFunctionEntity(n, context, codeContext);
    }

    public void initFunctionEntity(CAstEntity n, WalkContext functionContext) {
        Set<String> names;
        if (this.liftDeclarationsForLexicalScoping() && (names = this.entity2ExposedNames.get(n)) != null) {
            for (String nm : names) {
                functionContext.currentScope().declare(new CAstSymbolImpl(nm, CAstType.DYNAMIC));
            }
        }
        functionContext.cfg().makeEntryBlock(functionContext.cfg().newBlock(false));
        functionContext.cfg().newBlock(true);
        this.doPrologue(functionContext);
    }

    public void closeFunctionEntity(CAstEntity n, WalkContext parentContext, WalkContext functionContext) {
        functionContext.cfg().makeExitBlock(functionContext.cfg().newBlock(true));
        SymbolTable symtab = ((AbstractScope)functionContext.currentScope()).getUnderlyingSymtab();
        Map<IBasicBlock<SSAInstruction>, TypeReference[]> catchTypes = functionContext.getCatchTypes();
        AstCFG cfg = new AstCFG(n, functionContext.cfg(), symtab, this.insts);
        CAstSourcePositionMap.Position[] line = functionContext.cfg().getLinePositionMap();
        CAstSourcePositionMap.Position[][] operand = functionContext.cfg().getOperandPositionMap();
        boolean katch = functionContext.cfg().hasCatchBlock();
        boolean monitor = functionContext.cfg().hasMonitorOp();
        String[] nms = this.makeNameMap(n, functionContext.entityScopes(), cfg.getInstructions());
        AstLexicalInformation LI = new AstLexicalInformation(functionContext.getEntityName(n), functionContext.currentScope(), cfg.getInstructions(), functionContext.exposeNameSet(n, false), functionContext.exposeNameSet(n, true), functionContext.getAccesses(n));
        CAstSourcePositionMap.Position[] parameterPositions = this.getParameterPositions(n);
        AstDebuggingInformation DBG = new AstDebuggingInformation(n.getNamePosition(), n.getPosition(), line, operand, parameterPositions, nms, n.getSourceMap().positions());
        this.defineFunction(n, parentContext, cfg, symtab, katch, catchTypes, monitor, LI, DBG);
    }

    protected abstract CAstSourcePositionMap.Position[] getParameterPositions(CAstEntity var1);

    @Override
    protected WalkContext makeLocalContext(WalkContext context, CAstNode n) {
        return new LocalContext(context, this.makeLocalScope(context.currentScope()));
    }

    @Override
    protected WalkContext makeSpecialParentContext(final WalkContext context, CAstNode n) {
        final String specialName = (String)n.getChild(0).getValue();
        return new LocalContext(context, new AbstractScope(context.currentScope()){
            private Scope parent;
            {
                super(parent);
                this.parent = null;
            }

            private Scope parent() {
                if (this.parent == null) {
                    this.parent = ((AbstractScope)context.currentScope()).getEntityScope().getParent();
                }
                return this.parent;
            }

            @Override
            public ScopeType type() {
                return ScopeType.LOCAL;
            }

            private Scope scopeFor(String name) {
                if (name.equals(specialName)) {
                    return this.parent();
                }
                return context.currentScope();
            }

            @Override
            public boolean contains(String name) {
                return this.scopeFor(name).contains(name);
            }

            @Override
            public Symbol lookup(String name) {
                return this.scopeFor(name).lookup(name);
            }

            @Override
            protected SymbolTable getUnderlyingSymtab() {
                return ((AbstractScope)context.currentScope()).getUnderlyingSymtab();
            }

            @Override
            protected Symbol makeSymbol(String nm, CAstType type, boolean isFinal, boolean isInternalName, Object defaultInitValue, int vn, Scope parent) {
                return ((AbstractScope)context.currentScope()).makeSymbol(nm, type, isFinal, isInternalName, defaultInitValue, vn, parent);
            }

            @Override
            protected AbstractScope getEntityScope() {
                return ((AbstractScope)context.currentScope()).getEntityScope();
            }

            @Override
            public boolean isLexicallyScoped(Symbol s2) {
                return context.currentScope().isLexicallyScoped(s2);
            }

            @Override
            public CAstEntity getEntity() {
                return context.top();
            }
        });
    }

    @Override
    protected WalkContext makeUnwindContext(WalkContext context, CAstNode n, CAstVisitor<WalkContext> visitor) {
        return new UnwindContext(n, context, visitor);
    }

    protected int processFunctionExpr(CAstNode n, WalkContext context) {
        CAstEntity fn = (CAstEntity)n.getChild(0).getValue();
        this.declareFunction(fn, context);
        int result = context.currentScope().allocateTempValue();
        int ex = context.currentScope().allocateTempValue();
        this.doMaterializeFunction(n, context, result, ex, fn);
        return result;
    }

    @Override
    protected boolean visitFunctionExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFunctionExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int result = this.processFunctionExpr(n, c);
        c.setValue(n, result);
    }

    @Override
    protected boolean visitFunctionStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveFunctionStmt(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        int result = this.processFunctionExpr(n, context);
        CAstEntity fn = (CAstEntity)n.getChild(0).getValue();
        Scope cs = context.currentScope();
        if (cs.contains(fn.getName()) && !cs.isLexicallyScoped(cs.lookup(fn.getName())) && !cs.isGlobal(cs.lookup(fn.getName()))) {
            this.assignValue(n, context, cs.lookup(fn.getName()), fn.getName(), result);
        } else if (this.topLevelFunctionsInGlobalScope() && context.top().getKind() == 2) {
            context.getGlobalScope().declare(new FinalCAstSymbol(fn.getName(), fn.getType()));
            this.assignValue(n, context, cs.lookup(fn.getName()), fn.getName(), result);
        } else {
            context.currentScope().declare(new FinalCAstSymbol(fn.getName(), fn.getType()), result);
        }
    }

    @Override
    protected boolean visitLocalScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected boolean visitSpecialParentScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveLocalScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(0)));
    }

    @Override
    protected void leaveSpecialParentScope(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(1)));
    }

    @Override
    protected boolean visitBlockExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(n.getChildCount() - 1)));
    }

    @Override
    protected boolean visitBlockStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitLoop(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        context.cfg().newBlock(true);
        PreBasicBlock headerB = context.cfg().getCurrentBlock();
        visitor.visit(n.getChild(0), context, visitor);
        assert (c.getValue(n.getChild(0)) != -1) : "error in loop test " + CAstPrinter.print(n.getChild(0), context.top().getSourceMap()) + " of loop " + CAstPrinter.print(n, context.top().getSourceMap());
        context.cfg().addInstruction(this.insts.ConditionalBranchInstruction(context.cfg().currentInstruction, this.translateConditionOpcode(CAstOperator.OP_EQ), null, c.getValue(n.getChild(0)), context.currentScope().getConstantValue(0), -1));
        PreBasicBlock branchB = context.cfg().getCurrentBlock();
        context.cfg().newBlock(true);
        visitor.visit(n.getChild(1), context, visitor);
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            context.cfg().addInstruction(this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
            PreBasicBlock bodyB = context.cfg().getCurrentBlock();
            context.cfg().addEdge(bodyB, headerB);
            context.cfg().newBlock(false);
        }
        PreBasicBlock nextB = context.cfg().getCurrentBlock();
        context.cfg().addEdge(branchB, nextB);
        return true;
    }

    @Override
    protected final void leaveLoopHeader(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveLoop(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitGetCaughtException(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveGetCaughtException(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        String nm = (String)n.getChild(0).getValue();
        context.currentScope().declare(new FinalCAstSymbol(nm, this.exceptionType()));
        int v = context.currentScope().allocateTempValue();
        context.cfg().addInstruction(this.insts.GetCaughtExceptionInstruction(context.cfg().currentInstruction, context.cfg().getCurrentBlock().getNumber(), v));
        context.cfg().addInstruction(new AssignInstruction(context.cfg().currentInstruction, context.currentScope().lookup(nm).valueNumber(), v));
    }

    @Override
    protected boolean visitThis(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveThis(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, 1);
    }

    @Override
    protected boolean visitSuper(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveSuper(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, 1);
    }

    @Override
    protected boolean visitCall(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveCall(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        int exp = context.currentScope().allocateTempValue();
        int fun = c.getValue(n.getChild(0));
        CAstNode functionName = n.getChild(1);
        int[] args = new int[n.getChildCount() - 2];
        for (int i = 0; i < args.length; ++i) {
            args[i] = c.getValue(n.getChild(i + 2));
        }
        this.doCall(context, n, result, exp, functionName, fun, args);
    }

    @Override
    protected boolean visitVar(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveVar(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        String nm = (String)n.getChild(0).getValue();
        assert (nm != null) : "cannot find var for " + CAstPrinter.print(n, context.getSourceMap());
        Symbol s2 = context.currentScope().lookup(nm);
        assert (s2 != null) : "cannot find symbol for " + nm + " at " + CAstPrinter.print(n, context.getSourceMap());
        assert (s2.type() != null) : "no type for " + nm + " at " + CAstPrinter.print(n, context.getSourceMap());
        TypeReference type = this.makeType(s2.type());
        if (context.currentScope().isGlobal(s2)) {
            c.setValue(n, this.doGlobalRead(n, context, nm, type));
        } else if (context.currentScope().isLexicallyScoped(s2)) {
            c.setValue(n, this.doLexicallyScopedRead(n, context, nm, type));
        } else {
            c.setValue(n, this.doLocalRead(context, nm, type));
        }
    }

    @Override
    protected boolean visitConstant(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveConstant(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        c.setValue(n, context.currentScope().getConstantValue(n.getValue()));
    }

    @Override
    protected boolean visitBinaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    private static boolean handleBinaryOpThrow(CAstNode n, CAstNode op, WalkContext context) {
        boolean mayBeInteger = AstTranslator.handlePossibleThrow(n, context);
        if (mayBeInteger) assert (op == CAstOperator.OP_DIV || op == CAstOperator.OP_MOD) : CAstPrinter.print(n);
        return mayBeInteger;
    }

    private static boolean handlePossibleThrow(CAstNode n, WalkContext context) {
        boolean mayThrow = false;
        Collection<Object> labels = context.getControlFlow().getTargetLabels(n);
        if (!labels.isEmpty()) {
            mayThrow = true;
            context.cfg().addPreNode(n, context.getUnwindState());
            for (Object label : labels) {
                CAstNode target = context.getControlFlow().getTarget(n, label);
                if (target == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                    context.cfg().addPreEdgeToExit(n, true);
                    continue;
                }
                context.cfg().addPreEdge(n, target, true);
            }
        }
        return mayThrow;
    }

    @Override
    protected void leaveBinaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        CAstNode l = n.getChild(1);
        CAstNode r = n.getChild(2);
        assert (c.getValue(r) != -1) : CAstPrinter.print(n);
        assert (c.getValue(l) != -1) : CAstPrinter.print(n);
        boolean mayBeInteger = AstTranslator.handleBinaryOpThrow(n, n.getChild(0), context);
        int currentInstruction = context.cfg().currentInstruction;
        context.cfg().addInstruction(this.insts.BinaryOpInstruction(currentInstruction, this.translateBinaryOpcode(n.getChild(0)), false, false, result, c.getValue(l), c.getValue(r), mayBeInteger));
        context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(l), context.getSourceMap().getPosition(r));
        if (mayBeInteger) {
            context.cfg().newBlock(true);
        }
    }

    @Override
    protected boolean visitUnaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveUnaryExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        CAstNode v = n.getChild(1);
        int currentInstruction = context.cfg().currentInstruction;
        context.cfg().addInstruction(this.insts.UnaryOpInstruction(currentInstruction, this.translateUnaryOpcode(n.getChild(0)), result, c.getValue(v)));
        context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(v));
    }

    @Override
    protected boolean visitArrayLength(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveArrayLength(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        CAstNode arrayExpr = n.getChild(0);
        int arrayValue = c.getValue(arrayExpr);
        int currentInstruction = context.cfg().currentInstruction;
        context.cfg().addInstruction(this.insts.ArrayLengthInstruction(currentInstruction, result, arrayValue));
        context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(arrayExpr));
    }

    @Override
    protected boolean visitArrayRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int arrayValue = c.getValue(n.getChild(0));
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        this.arrayOpHandler.doArrayRead(context, result, arrayValue, n, AstTranslator.gatherArrayDims(c, n));
    }

    @Override
    protected boolean visitDeclStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveDeclStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        CAstSymbol s2 = (CAstSymbol)n.getChild(0).getValue();
        String nm = s2.name();
        CAstType t = s2.type();
        Scope scope = c.currentScope();
        if (n.getChildCount() == 2) {
            CAstNode v = n.getChild(1);
            if (scope.contains(nm) && scope.lookup(nm).getDefiningScope() == scope) {
                assert (!s2.isFinal());
                this.doLocalWrite(c, nm, this.makeType(t), c.getValue(v));
            } else if (v.getKind() != 300 && v.getKind() != 111 && v.getKind() != 116 && v.getKind() != 104) {
                scope.declare(s2, c.getValue(v));
            } else {
                scope.declare(s2);
                this.doLocalWrite(c, nm, this.makeType(t), c.getValue(v));
            }
        } else {
            c.currentScope().declare(s2);
        }
    }

    @Override
    protected boolean visitReturn(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveReturn(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int currentInstruction = context.cfg().currentInstruction;
        if (n.getChildCount() > 0) {
            CAstNode returnExpr = n.getChild(0);
            context.cfg().addInstruction(this.insts.ReturnInstruction(currentInstruction, c.getValue(returnExpr), false));
            context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(returnExpr));
        } else {
            context.cfg().addInstruction(this.insts.ReturnInstruction(currentInstruction));
        }
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().newBlock(false);
        context.cfg().addPreEdgeToExit(n, false);
    }

    @Override
    protected boolean visitIfgoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveIfgoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int currentInstruction = context.cfg().currentInstruction;
        switch (n.getChildCount()) {
            case 1: {
                CAstNode arg = n.getChild(0);
                context.cfg().addInstruction(this.insts.ConditionalBranchInstruction(currentInstruction, this.translateConditionOpcode(CAstOperator.OP_NE), null, c.getValue(arg), context.currentScope().getConstantValue(0), -1));
                context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(arg));
                break;
            }
            case 3: {
                CAstNode op = n.getChild(0);
                CAstNode leftExpr = n.getChild(1);
                CAstNode rightExpr = n.getChild(2);
                context.cfg().addInstruction(this.insts.ConditionalBranchInstruction(currentInstruction, this.translateConditionOpcode(op), null, c.getValue(leftExpr), c.getValue(rightExpr), -1));
                context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(leftExpr), context.getSourceMap().getPosition(rightExpr));
                break;
            }
            default: {
                Assertions.UNREACHABLE();
            }
        }
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().addPreEdge(n, context.getControlFlow().getTarget(n, Boolean.TRUE), false);
        context.cfg().newBlock(true);
    }

    @Override
    protected boolean visitGoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveGoto(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            context.cfg().addPreNode(n, context.getUnwindState());
            CAstControlFlowMap controlFlowMap = context.getControlFlow();
            context.cfg().addPreEdge(n, controlFlowMap.getTarget(n, null), false);
            context.cfg().addInstruction(this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
            if (controlFlowMap.getTarget(n, null) == null) assert (controlFlowMap.getTarget(n, null) != null) : controlFlowMap + " does not map " + n + " (" + context.getSourceMap().getPosition(n) + ')';
            context.cfg().newBlock(false);
        }
    }

    @Override
    protected boolean visitLabelStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (!context.getControlFlow().getSourceNodes(n).isEmpty()) {
            context.cfg().newBlock(true);
            context.cfg().addPreNode(n, context.getUnwindState());
        }
        return false;
    }

    @Override
    protected void leaveLabelStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    protected void processIf(CAstNode n, boolean isExpr, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        PreBasicBlock trueB = null;
        PreBasicBlock falseB = null;
        CAstNode l = n.getChild(0);
        visitor.visit(l, context, visitor);
        int currentInstruction = context.cfg().getCurrentInstruction();
        context.cfg().addInstruction(this.insts.ConditionalBranchInstruction(currentInstruction, this.translateConditionOpcode(CAstOperator.OP_EQ), null, c.getValue(l), context.currentScope().getConstantValue(0), -1));
        context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(l));
        PreBasicBlock srcB = context.cfg().getCurrentBlock();
        context.cfg().newBlock(true);
        CAstNode r = n.getChild(1);
        visitor.visit(r, context, visitor);
        if (isExpr) {
            currentInstruction = context.cfg().getCurrentInstruction();
            context.cfg().addInstruction(new AssignInstruction(currentInstruction, c.getValue(n), c.getValue(r)));
            context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(r));
        }
        if (n.getChildCount() == 3) {
            if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
                context.cfg().addInstruction(this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
                trueB = context.cfg().getCurrentBlock();
                context.cfg().newBlock(false);
            }
            falseB = context.cfg().getCurrentBlock();
            CAstNode f = n.getChild(2);
            context.cfg().deadBlocks.remove(falseB);
            visitor.visit(f, context, visitor);
            if (isExpr) {
                currentInstruction = context.cfg().currentInstruction;
                context.cfg().addInstruction(new AssignInstruction(currentInstruction, c.getValue(n), c.getValue(f)));
                context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(f));
            }
        }
        context.cfg().newBlock(true);
        if (n.getChildCount() == 3) {
            if (trueB != null) {
                context.cfg().addEdge(trueB, context.cfg().getCurrentBlock());
            }
            context.cfg().addEdge(srcB, falseB);
        } else {
            context.cfg().addEdge(srcB, context.cfg().getCurrentBlock());
        }
    }

    @Override
    protected final void leaveIfStmtCondition(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfStmtTrueClause(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfExprCondition(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfExprTrueClause(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveIfExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitIfStmt(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        this.processIf(n, false, c, visitor);
        return true;
    }

    @Override
    protected boolean visitIfExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        this.processIf(n, true, c, visitor);
        return true;
    }

    @Override
    protected boolean visitNew(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveNew(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int[] arguments;
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        if (n.getChildCount() <= 1) {
            arguments = null;
        } else {
            arguments = new int[n.getChildCount() - 1];
            for (int i = 1; i < n.getChildCount(); ++i) {
                arguments[i - 1] = c.getValue(n.getChild(i));
            }
        }
        this.doNewObject(context, n, result, n.getChild(0).getValue(), arguments);
    }

    @Override
    protected boolean visitObjectLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveObjectLiteralFieldInit(CAstNode n, int i, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (n.getChild(i).getKind() == 19) {
            this.handleUnspecifiedLiteralKey();
        }
        this.doFieldWrite(context, c.getValue(n.getChild(0)), n.getChild(i), n, c.getValue(n.getChild(i + 1)));
    }

    @Override
    protected void leaveObjectLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(0)));
    }

    @Override
    protected boolean visitArrayLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayLiteralObject(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(0)));
    }

    @Override
    protected void leaveArrayLiteralInitElement(CAstNode n, int i, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        this.arrayOpHandler.doArrayWrite(context, c.getValue(n.getChild(0)), n, new int[]{context.currentScope().getConstantValue(i - 1)}, c.getValue(n.getChild(i)));
    }

    @Override
    protected void leaveArrayLiteral(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitObjectRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        return false;
    }

    @Override
    protected void leaveObjectRef(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = c.getValue(n);
        CAstNode elt = n.getChild(1);
        this.doFieldRead(context, result, c.getValue(n.getChild(0)), elt, n);
    }

    @Override
    public boolean visitAssign(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    public void leaveAssign(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        if (n.getKind() == 14) {
            c.setValue(n, c.getValue(n.getChild(1)));
        } else {
            c.setValue(n, c.getValue(n.getChild(0)));
        }
    }

    private static int[] gatherArrayDims(WalkContext c, CAstNode n) {
        int numDims = n.getChildCount() - 2;
        int[] dims = new int[numDims];
        for (int i = 0; i < numDims; ++i) {
            dims[i] = c.getValue(n.getChild(i + 2));
        }
        return dims;
    }

    protected int processAssignOp(CAstNode v, CAstNode a, int temp, WalkContext c) {
        WalkContext context = c;
        int rval = c.getValue(v);
        CAstNode op = a.getChild(2);
        int temp2 = context.currentScope().allocateTempValue();
        boolean mayBeInteger = AstTranslator.handleBinaryOpThrow(a, op, context);
        int currentInstruction = context.cfg().getCurrentInstruction();
        context.cfg().addInstruction(this.insts.BinaryOpInstruction(currentInstruction, this.translateBinaryOpcode(op), false, false, temp2, temp, rval, mayBeInteger));
        context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(a.getChild(0)), context.getSourceMap().getPosition(v));
        if (mayBeInteger) {
            context.cfg().newBlock(true);
        }
        return temp2;
    }

    @Override
    protected boolean visitArrayRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int rval = c.getValue(v);
        c.setValue(n, rval);
        this.arrayOpHandler.doArrayWrite(context, c.getValue(n.getChild(0)), n, AstTranslator.gatherArrayDims(c, n), rval);
    }

    @Override
    protected boolean visitArrayRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveArrayRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int temp = context.currentScope().allocateTempValue();
        int[] dims = AstTranslator.gatherArrayDims(c, n);
        this.arrayOpHandler.doArrayRead(context, temp, c.getValue(n.getChild(0)), n, dims);
        int rval = this.processAssignOp(v, a, temp, c);
        c.setValue(n, pre ? rval : temp);
        this.arrayOpHandler.doArrayWrite(context, c.getValue(n.getChild(0)), n, dims, rval);
    }

    @Override
    protected boolean visitObjectRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveObjectRefAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int rval = c.getValue(v);
        c.setValue(n, rval);
        this.doFieldWrite(context, c.getValue(n.getChild(0)), n.getChild(1), n, rval);
    }

    @Override
    protected boolean visitObjectRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveObjectRefAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int temp = context.currentScope().allocateTempValue();
        this.doFieldRead(context, temp, c.getValue(n.getChild(0)), n.getChild(1), n);
        int rval = this.processAssignOp(v, a, temp, c);
        c.setValue(n, pre ? rval : temp);
        this.doFieldWrite(context, c.getValue(n.getChild(0)), n.getChild(1), n, rval);
    }

    @Override
    protected boolean visitBlockExprAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockExprAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(n.getChildCount() - 1)));
    }

    @Override
    protected boolean visitBlockExprAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveBlockExprAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, c.getValue(n.getChild(n.getChildCount() - 1)));
    }

    @Override
    protected boolean visitVarAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    protected void assignValue(CAstNode n, WalkContext context, Symbol ls, String nm, int rval) {
        if (context.currentScope().isGlobal(ls)) {
            this.doGlobalWrite(context, nm, this.makeType(ls.type()), rval);
        } else if (context.currentScope().isLexicallyScoped(ls)) {
            this.doLexicallyScopedWrite(context, nm, this.makeType(ls.type()), rval);
        } else {
            assert (rval != -1) : CAstPrinter.print(n, context.top().getSourceMap());
            this.doLocalWrite(context, nm, this.makeType(ls.type()), rval);
        }
    }

    @Override
    protected void leaveVarAssign(CAstNode n, CAstNode v, CAstNode a, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int rval = c.getValue(v);
        String nm = (String)n.getChild(0).getValue();
        Symbol ls = context.currentScope().lookup(nm);
        c.setValue(n, rval);
        this.assignValue(n, context, ls, nm, rval);
    }

    @Override
    protected boolean visitVarAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveVarAssignOp(CAstNode n, CAstNode v, CAstNode a, boolean pre, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        String nm = (String)n.getChild(0).getValue();
        Symbol ls = context.currentScope().lookup(nm);
        TypeReference type = this.makeType(ls.type());
        int temp = context.currentScope().isGlobal(ls) ? this.doGlobalRead(n, context, nm, type) : (context.currentScope().isLexicallyScoped(ls) ? this.doLexicallyScopedRead(n, context, nm, type) : this.doLocalRead(context, nm, type));
        if (!pre) {
            int ret = context.currentScope().allocateTempValue();
            int currentInstruction = context.cfg().getCurrentInstruction();
            context.cfg().addInstruction(new AssignInstruction(currentInstruction, ret, temp));
            context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(n.getChild(0)));
            c.setValue(n, ret);
        }
        int rval = this.processAssignOp(v, a, temp, c);
        if (pre) {
            c.setValue(n, rval);
        }
        if (context.currentScope().isGlobal(ls)) {
            this.doGlobalWrite(context, nm, type, rval);
        } else if (context.currentScope().isLexicallyScoped(ls)) {
            this.doLexicallyScopedWrite(context, nm, type, rval);
        } else {
            this.doLocalWrite(context, nm, type, rval);
        }
    }

    private static boolean isSimpleSwitch(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        boolean hasCase = false;
        CAstControlFlowMap ctrl = context.getControlFlow();
        Collection<Object> caseLabels = ctrl.getTargetLabels(n);
        for (Object x : caseLabels) {
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            hasCase = true;
            CAstNode xn = (CAstNode)x;
            if (xn.getKind() == 300) {
                Number num;
                Object val;
                visitor.visit(xn, context, visitor);
                if (context.getValue(xn) != -1 && context.currentScope().isConstant(context.getValue(xn)) && (val = context.currentScope().getConstantObject(context.getValue(xn))) instanceof Number && (double)(num = (Number)val).intValue() == num.doubleValue()) continue;
            }
            return false;
        }
        return hasCase;
    }

    private void doSimpleSwitch(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        PreBasicBlock dummyDefaultBlock = null;
        CAstControlFlowMap ctrl = context.getControlFlow();
        CAstNode switchValue = n.getChild(0);
        visitor.visit(switchValue, context, visitor);
        int v = context.getValue(switchValue);
        boolean hasExplicitDefault = ctrl.getTarget(n, CAstControlFlowMap.SWITCH_DEFAULT) != null;
        Collection<Object> caseLabels = ctrl.getTargetLabels(n);
        int cases = caseLabels.size();
        if (hasExplicitDefault) {
            --cases;
        }
        int[] casesAndLabels = new int[cases * 2];
        PreBasicBlock switchInstrBlock = context.cfg().getCurrentBlock();
        int currentInstruction = context.cfg().getCurrentInstruction();
        context.cfg().addInstruction(this.insts.SwitchInstruction(currentInstruction, v, currentInstruction + 1, casesAndLabels));
        context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(switchValue));
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().newBlock(false);
        context.cfg().addInstruction(this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
        dummyDefaultBlock = context.cfg().getCurrentBlock();
        context.cfg().addEdge(switchInstrBlock, dummyDefaultBlock);
        context.cfg().newBlock(false);
        CAstNode switchBody = n.getChild(1);
        visitor.visit(switchBody, context, visitor);
        context.cfg().newBlock(true);
        if (!hasExplicitDefault) {
            context.cfg().addEdge(dummyDefaultBlock, context.cfg().getCurrentBlock());
        }
        int cn = 0;
        for (Object x : caseLabels) {
            CAstNode target = ctrl.getTarget(n, x);
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) {
                context.cfg().addEdge(dummyDefaultBlock, context.cfg().getBlock(target));
                continue;
            }
            Number caseLabel = (Number)context.currentScope().getConstantObject(context.getValue((CAstNode)x));
            casesAndLabels[2 * cn] = caseLabel.intValue();
            casesAndLabels[2 * cn + 1] = context.cfg().getBlock(target).firstIndex;
            ++cn;
            context.cfg().addPreEdge(n, target, false);
        }
    }

    private void doIfConvertSwitch(CAstNode n, WalkContext context, CAstVisitor<WalkContext> visitor) {
        CAstControlFlowMap ctrl = context.getControlFlow();
        context.cfg().addPreNode(n, context.getUnwindState());
        CAstNode switchValue = n.getChild(0);
        visitor.visit(switchValue, context, visitor);
        int v = context.getValue(switchValue);
        Collection<Object> caseLabels = ctrl.getTargetLabels(n);
        LinkedHashMap<Object, PreBasicBlock> labelToBlock = new LinkedHashMap<Object, PreBasicBlock>();
        for (Object x : caseLabels) {
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            visitor.visit((CAstNode)x, context, visitor);
            int currentInstruction = context.cfg().getCurrentInstruction();
            context.cfg().addInstruction(this.insts.ConditionalBranchInstruction(currentInstruction, this.translateConditionOpcode(CAstOperator.OP_EQ), null, v, context.getValue((CAstNode)x), -1));
            context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(switchValue), context.getSourceMap().getPosition((CAstNode)x));
            labelToBlock.put(x, context.cfg().getCurrentBlock());
            context.cfg().newBlock(true);
        }
        PreBasicBlock defaultGotoBlock = context.cfg().getCurrentBlock();
        context.cfg().addInstruction(this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
        context.cfg().newBlock(false);
        CAstNode switchBody = n.getChild(1);
        visitor.visit(switchBody, context, visitor);
        context.cfg().newBlock(true);
        for (Object x : caseLabels) {
            if (x == CAstControlFlowMap.SWITCH_DEFAULT) continue;
            CAstNode target = ctrl.getTarget(n, x);
            context.cfg().addEdge((PreBasicBlock)labelToBlock.get(x), context.cfg().getBlock(target));
        }
        if (ctrl.getTarget(n, CAstControlFlowMap.SWITCH_DEFAULT) == null) {
            context.cfg().addEdge(defaultGotoBlock, context.cfg().getCurrentBlock());
        } else {
            CAstNode target = ctrl.getTarget(n, CAstControlFlowMap.SWITCH_DEFAULT);
            context.cfg().addEdge(defaultGotoBlock, context.cfg().getBlock(target));
        }
    }

    @Override
    protected boolean visitSwitch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (AstTranslator.isSimpleSwitch(n, context, visitor)) {
            this.doSimpleSwitch(n, context, visitor);
        } else {
            this.doIfConvertSwitch(n, context, visitor);
        }
        return true;
    }

    @Override
    protected final void leaveSwitchValue(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveSwitch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitThrow(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveThrow(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        this.doThrow(context, c.getValue(n.getChild(0)));
        context.cfg().addPreNode(n, context.getUnwindState());
        context.cfg().newBlock(false);
        Collection<Object> labels = context.getControlFlow().getTargetLabels(n);
        for (Object label : labels) {
            CAstNode target = context.getControlFlow().getTarget(n, label);
            if (target == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                context.cfg().addPreEdgeToExit(n, true);
                continue;
            }
            context.cfg().addPreEdge(n, target, true);
        }
    }

    @Override
    protected boolean visitCatch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        if (context.getControlFlow().getSourceNodes(n).isEmpty()) {
            return true;
        }
        String id = (String)n.getChild(0).getValue();
        context.cfg().setCurrentBlockAsHandler();
        int v = context.currentScope().allocateTempValue();
        context.cfg().addInstruction(this.insts.GetCaughtExceptionInstruction(context.cfg().currentInstruction, context.cfg().getCurrentBlock().getNumber(), v));
        context.cfg().addPreNode(n, context.getUnwindState());
        this.doLocalWrite(context, id, this.defaultCatchType(), v);
        CAstType caughtType = AstTranslator.getTypeForNode(context, n);
        if (caughtType != null) {
            this.setType(context, n, caughtType);
        } else {
            context.setCatchType(n, this.defaultCatchType());
        }
        return false;
    }

    private void setType(WalkContext context, CAstNode n, CAstType caughtType) {
        if (caughtType instanceof CAstType.Union) {
            for (CAstType type : ((CAstType.Union)caughtType).getConstituents()) {
                this.setType(context, n, type);
            }
        } else {
            TypeReference caughtRef = this.makeType(caughtType);
            context.setCatchType(n, caughtRef);
        }
    }

    @Override
    protected void leaveCatch(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitUnwind(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveUnwind(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    private boolean hasIncomingEdges(CAstNode n, WalkContext context) {
        if (context.cfg().hasDelayedEdges(n)) {
            return true;
        }
        for (CAstNode child : n.getChildren()) {
            if (!this.hasIncomingEdges(child, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean visitTry(final CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        final WalkContext context = c;
        boolean addSkipCatchGoto = false;
        visitor.visit(n.getChild(0), context, visitor);
        PreBasicBlock endOfTry = context.cfg().getCurrentBlock();
        if (!this.hasIncomingEdges(n.getChild(1), context)) {
            if (this.loader instanceof CAstAbstractLoader) {
                ((CAstAbstractLoader)this.loader).addMessage(context.getModule(), new Warning(0){

                    @Override
                    public String getMsg() {
                        return "Dead catch block at " + AstTranslator.this.getPosition(context.getSourceMap(), n.getChild(1));
                    }
                });
            }
            return true;
        }
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            addSkipCatchGoto = true;
            context.cfg().addInstruction(this.insts.GotoInstruction(context.cfg().currentInstruction, -1));
            context.cfg().newBlock(false);
        }
        context.cfg().noteCatchBlock();
        visitor.visit(n.getChild(1), context, visitor);
        if (!context.cfg().isDeadBlock(context.cfg().getCurrentBlock())) {
            context.cfg().newBlock(true);
        }
        if (addSkipCatchGoto) {
            PreBasicBlock afterBlock = context.cfg().getCurrentBlock();
            context.cfg().addEdge(endOfTry, afterBlock);
        }
        return true;
    }

    @Override
    protected final void leaveTryBlock(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected final void leaveTry(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
    }

    @Override
    protected boolean visitEmpty(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEmpty(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        c.setValue(n, context.currentScope().getConstantValue(null));
    }

    @Override
    protected boolean visitPrimitive(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leavePrimitive(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        int result = context.currentScope().allocateTempValue();
        c.setValue(n, result);
        this.doPrimitive(result, context, n);
    }

    @Override
    protected boolean visitVoid(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveVoid(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        c.setValue(n, -1);
    }

    @Override
    protected boolean visitAssert(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveAssert(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext context = c;
        boolean fromSpec = true;
        CAstNode assertion = n.getChild(0);
        int result = c.getValue(assertion);
        if (n.getChildCount() == 2) {
            assert (n.getChild(1).getKind() == 300);
            assert (n.getChild(1).getValue() instanceof Boolean);
            fromSpec = n.getChild(1).getValue().equals(Boolean.TRUE);
        }
        int currentInstruction = context.cfg().currentInstruction;
        context.cfg().addInstruction(new AstAssertInstruction(currentInstruction, result, fromSpec));
        context.cfg().noteOperands(currentInstruction, context.getSourceMap().getPosition(assertion));
    }

    @Override
    protected boolean visitEachElementGet(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEachElementGet(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int result = c.currentScope().allocateTempValue();
        c.setValue(n, result);
        int currentInstruction = c.cfg().getCurrentInstruction();
        c.cfg().addInstruction(new EachElementGetInstruction(currentInstruction, result, c.getValue(n.getChild(0)), c.getValue(n.getChild(1))));
        c.cfg().noteOperands(currentInstruction, c.getSourceMap().getPosition(n.getChild(0)), c.getSourceMap().getPosition(n.getChild(1)));
        if (AstTranslator.handlePossibleThrow(n, c)) {
            c.cfg().newBlock(true);
        }
    }

    @Override
    protected boolean visitEachElementHasNext(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEachElementHasNext(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        int result = c.currentScope().allocateTempValue();
        c.setValue(n, result);
        int currentInstruction = c.cfg().getCurrentInstruction();
        c.cfg().addInstruction(new EachElementHasNextInstruction(currentInstruction, result, c.getValue(n.getChild(0)), c.getValue(n.getChild(1))));
        c.cfg().noteOperands(currentInstruction, c.getSourceMap().getPosition(n.getChild(0)), c.getSourceMap().getPosition(n.getChild(1)));
    }

    @Override
    protected boolean visitTypeLiteralExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveTypeLiteralExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        assert (n.getChild(0).getKind() == 300);
        String typeNameStr = (String)n.getChild(0).getValue();
        TypeName typeName = TypeName.string2TypeName(typeNameStr);
        TypeReference typeRef = TypeReference.findOrCreate(this.loader.getReference(), typeName);
        int result = wc.currentScope().allocateTempValue();
        c.setValue(n, result);
        wc.cfg().addInstruction(this.insts.LoadMetadataInstruction(wc.cfg().currentInstruction, result, this.loader.getLanguage().getConstantType(typeRef), typeRef));
    }

    @Override
    protected boolean visitIsDefinedExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveIsDefinedExpr(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        CAstNode refExpr = n.getChild(0);
        int ref = c.getValue(refExpr);
        int result = wc.currentScope().allocateTempValue();
        c.setValue(n, result);
        if (n.getChildCount() == 1) {
            int currentInstruction = wc.cfg().getCurrentInstruction();
            wc.cfg().addInstruction(new AstIsDefinedInstruction(currentInstruction, result, ref));
            wc.cfg().noteOperands(currentInstruction, wc.getSourceMap().getPosition(refExpr));
        } else {
            this.doIsFieldDefined(wc, result, ref, n.getChild(1));
        }
    }

    @Override
    protected boolean visitEcho(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveEcho(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        int[] rvals = new int[n.getChildCount()];
        CAstSourcePositionMap.Position[] rposs = new CAstSourcePositionMap.Position[n.getChildCount()];
        int i = 0;
        for (CAstNode child : n.getChildren()) {
            rvals[i] = c.getValue(child);
            rposs[i] = c.getSourceMap().getPosition(child);
            ++i;
        }
        int currentInstruction = wc.cfg().getCurrentInstruction();
        wc.cfg().addInstruction(new AstEchoInstruction(currentInstruction, rvals));
        wc.cfg().noteOperands(currentInstruction, rposs);
    }

    @Override
    protected boolean visitYield(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        return false;
    }

    @Override
    protected void leaveYield(CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        int[] rvals = new int[n.getChildCount()];
        CAstSourcePositionMap.Position[] rposs = new CAstSourcePositionMap.Position[n.getChildCount()];
        int i = 0;
        for (CAstNode child : n.getChildren()) {
            rvals[i] = c.getValue(child);
            rposs[i] = c.getSourceMap().getPosition(child);
            ++i;
        }
        int currentInstruction = wc.cfg().getCurrentInstruction();
        wc.cfg().addInstruction(new AstYieldInstruction(currentInstruction, rvals));
        wc.cfg().noteOperands(currentInstruction, rposs);
    }

    public CAstEntity getIncludedEntity(CAstNode n) {
        if (n.getChild(0).getKind() == 405) {
            assert (this.namedEntityResolver != null);
            return this.namedEntityResolver.get(n.getChild(0).getChild(0).getValue());
        }
        return (CAstEntity)n.getChild(0).getValue();
    }

    @Override
    protected void leaveInclude(final CAstNode n, WalkContext c, CAstVisitor<WalkContext> visitor) {
        WalkContext wc = c;
        CAstEntity included = this.getIncludedEntity(n);
        if (included == null) {
            System.err.println("cannot find include for " + CAstPrinter.print(n));
            System.err.println("from:\n" + this.namedEntityResolver);
        } else {
            final boolean isMacroExpansion = included.getKind() == 7;
            System.err.println("found " + included.getName() + " for " + CAstPrinter.print(n));
            final CAstEntity copy = new CAstCloner(new CAstImpl(), true){

                private CAstNode copyIncludeExpr(CAstNode expr) {
                    if (expr.getValue() != null) {
                        return this.Ast.makeConstant(expr.getValue());
                    }
                    if (expr instanceof CAstOperator) {
                        return expr;
                    }
                    ArrayList<CAstNode> nc = new ArrayList<CAstNode>(expr.getChildCount());
                    for (CAstNode child : expr.getChildren()) {
                        nc.add(this.copyIncludeExpr(child));
                    }
                    return this.Ast.makeNode(expr.getKind(), nc);
                }

                @Override
                protected CAstNode copyNodes(CAstNode root, CAstControlFlowMap cfg, CAstBasicRewriter.NonCopyingContext c, Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap) {
                    if (isMacroExpansion && root.getKind() == 129) {
                        int arg = ((Number)root.getChild(0).getValue()).intValue();
                        CAstNode expr = this.copyIncludeExpr(n.getChild(arg));
                        nodeMap.put(Pair.make(root, c.key()), expr);
                        return expr;
                    }
                    return super.copyNodes(root, cfg, c, nodeMap);
                }
            }.rewrite(included);
            if (copy.getAST() == null) {
                System.err.println(copy.getName() + " has no AST");
            } else {
                this.visit(copy.getAST(), new DelegatingContext(wc){

                    @Override
                    public CAstSourcePositionMap getSourceMap() {
                        return copy.getSourceMap();
                    }

                    @Override
                    public CAstControlFlowMap getControlFlow() {
                        return copy.getControlFlow();
                    }
                }, visitor);
                visitor.visitScopedEntities(copy, copy.getAllScopedEntities(), wc, visitor);
            }
        }
    }

    protected final void walkEntities(CAstEntity N, WalkContext c) {
        this.visitEntities(N, c, this);
    }

    @Override
    public void translate(CAstEntity N, ModuleEntry module) {
        ExposedNamesCollector exposedNamesCollector = new ExposedNamesCollector();
        exposedNamesCollector.run(N);
        if (this.liftDeclarationsForLexicalScoping()) {
            exposedNamesCollector.run(N);
        }
        this.entity2ExposedNames = exposedNamesCollector.getEntity2ExposedNames();
        this.walkEntities(N, new RootContext(N, module));
    }

    public void translate(CAstEntity N, WalkContext context) {
        ExposedNamesCollector exposedNamesCollector = new ExposedNamesCollector();
        exposedNamesCollector.run(N);
        if (this.liftDeclarationsForLexicalScoping()) {
            exposedNamesCollector.run(N);
        }
        this.entity2ExposedNames = exposedNamesCollector.getEntity2ExposedNames();
        this.walkEntities(N, context);
    }

    protected void doIsFieldDefined(WalkContext context, int result, int ref, CAstNode f) {
        if (f.getKind() == 300 && f.getValue() instanceof String) {
            String field = (String)f.getValue();
            FieldReference fieldRef = FieldReference.findOrCreate(this.loader.getLanguage().getRootType(), Atom.findOrCreateUnicodeAtom(field), this.loader.getLanguage().getRootType());
            context.cfg().addInstruction(((AstInstructionFactory)this.insts).IsDefinedInstruction(context.cfg().getCurrentInstruction(), result, ref, fieldRef));
        } else {
            context.cfg().addInstruction(((AstInstructionFactory)this.insts).IsDefinedInstruction(context.cfg().getCurrentInstruction(), result, ref, context.getValue(f)));
        }
    }

    public final class RootContext
    implements WalkContext {
        private final Scope globalScope;
        private final CAstEntity N;
        private final ModuleEntry module;
        private final Map<CAstEntity, String> entityNames = new LinkedHashMap<CAstEntity, String>();

        public RootContext(CAstEntity N, ModuleEntry module) {
            this.N = N;
            this.module = module;
            this.globalScope = AstTranslator.this.makeGlobalScope();
        }

        @Override
        public WalkContext codeContext() {
            assert (false);
            return null;
        }

        @Override
        public ModuleEntry getModule() {
            return this.module;
        }

        @Override
        public String file() {
            return this.module.getName();
        }

        @Override
        public CAstEntity top() {
            return this.N;
        }

        @Override
        public Scope currentScope() {
            return this.globalScope;
        }

        @Override
        public Set<Scope> entityScopes() {
            return Collections.singleton(this.globalScope);
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.N.getSourceMap();
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.N.getControlFlow();
        }

        @Override
        public IncipientCFG cfg() {
            return null;
        }

        @Override
        public UnwindState getUnwindState() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public void setCatchType(IBasicBlock<SSAInstruction> bb, TypeReference catchType) {
        }

        @Override
        public void setCatchType(CAstNode castNode, TypeReference catchType) {
        }

        @Override
        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes() {
            return null;
        }

        @Override
        public void addEntityName(CAstEntity e, String name) {
            this.entityNames.put(e, name);
        }

        @Override
        public String getEntityName(CAstEntity e) {
            if (e == null) {
                return null;
            }
            assert (this.entityNames.containsKey(e));
            return 'L' + this.entityNames.get(e);
        }

        @Override
        public boolean hasValue(CAstNode n) {
            assert (false);
            return false;
        }

        @Override
        public int setValue(CAstNode n, int v) {
            assert (false);
            return 0;
        }

        @Override
        public int getValue(CAstNode n) {
            assert (false);
            return -1;
        }

        @Override
        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity entity, boolean writeSet) {
            assert (false);
            return null;
        }

        @Override
        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity e) {
            assert (false);
            return null;
        }

        @Override
        public Scope getGlobalScope() {
            return this.globalScope;
        }
    }

    public static class AstLexicalInformation
    implements AstMethod.LexicalInformation {
        private final String functionLexicalName;
        private final Pair<String, String>[] exposedNames;
        private final int[][] instructionLexicalUses;
        private final int[] exitLexicalUses;
        private final String[] scopingParents;
        private MutableIntSet allExposedUses = null;
        private final Set<String> readOnlyNames;
        private static final int[] NONE = new int[0];

        public AstLexicalInformation(AstLexicalInformation original) {
            int i;
            this.functionLexicalName = original.functionLexicalName;
            if (original.exposedNames != null) {
                this.exposedNames = new Pair[original.exposedNames.length];
                for (i = 0; i < this.exposedNames.length; ++i) {
                    this.exposedNames[i] = Pair.make(original.exposedNames[i].fst, original.exposedNames[i].snd);
                }
            } else {
                this.exposedNames = null;
            }
            this.instructionLexicalUses = new int[original.instructionLexicalUses.length][];
            for (i = 0; i < this.instructionLexicalUses.length; ++i) {
                int[] x = original.instructionLexicalUses[i];
                if (x == null) continue;
                this.instructionLexicalUses[i] = (int[])x.clone();
            }
            if (original.exitLexicalUses != null) {
                this.exitLexicalUses = new int[original.exitLexicalUses.length];
                System.arraycopy(original.exitLexicalUses, 0, this.exitLexicalUses, 0, this.exitLexicalUses.length);
            } else {
                this.exitLexicalUses = null;
            }
            if (original.scopingParents != null) {
                this.scopingParents = new String[original.scopingParents.length];
                System.arraycopy(original.scopingParents, 0, this.scopingParents, 0, this.scopingParents.length);
            } else {
                this.scopingParents = null;
            }
            this.readOnlyNames = original.readOnlyNames;
        }

        private static int[] buildLexicalUseArray(Pair<Pair<String, String>, Integer>[] exposedNames, String entityName) {
            if (exposedNames != null) {
                int[] lexicalUses = new int[exposedNames.length];
                for (int j = 0; j < exposedNames.length; ++j) {
                    lexicalUses[j] = entityName == null || entityName.equals(((Pair)exposedNames[j].fst).snd) ? (Integer)exposedNames[j].snd : -1;
                }
                return lexicalUses;
            }
            return null;
        }

        private static Pair<String, String>[] buildLexicalNamesArray(Pair<Pair<String, String>, Integer>[] exposedNames) {
            if (exposedNames != null) {
                Pair[] lexicalNames = new Pair[exposedNames.length];
                for (int j = 0; j < exposedNames.length; ++j) {
                    lexicalNames[j] = (Pair)exposedNames[j].fst;
                }
                return lexicalNames;
            }
            return null;
        }

        AstLexicalInformation(String entityName, Scope scope, SSAInstruction[] instrs, Set<Pair<Pair<String, String>, Integer>> exposedNamesForReadSet, Set<Pair<Pair<String, String>, Integer>> exposedNamesForWriteSet, Set<AstLexicalAccess.Access> accesses) {
            this.functionLexicalName = entityName;
            Pair[] EN = null;
            if (exposedNamesForReadSet != null || exposedNamesForWriteSet != null) {
                HashSet<Pair<Pair<String, String>, Integer>> exposedNamesSet = new HashSet<Pair<Pair<String, String>, Integer>>();
                if (exposedNamesForReadSet != null) {
                    exposedNamesSet.addAll(exposedNamesForReadSet);
                }
                if (exposedNamesForWriteSet != null) {
                    exposedNamesSet.addAll(exposedNamesForWriteSet);
                }
                EN = exposedNamesSet.toArray(new Pair[0]);
            }
            if (exposedNamesForReadSet != null) {
                HashSet<String> readOnlyNames = new HashSet<String>();
                for (Pair<Pair<String, String>, Integer> v : exposedNamesForReadSet) {
                    if (entityName == null || !entityName.equals(((Pair)v.fst).snd)) continue;
                    readOnlyNames.add((String)((Pair)v.fst).fst);
                }
                if (exposedNamesForWriteSet != null) {
                    for (Pair<Pair<String, String>, Integer> v : exposedNamesForWriteSet) {
                        if (entityName == null || !entityName.equals(((Pair)v.fst).snd)) continue;
                        readOnlyNames.remove(((Pair)v.fst).fst);
                    }
                }
                this.readOnlyNames = readOnlyNames;
            } else {
                this.readOnlyNames = null;
            }
            this.exposedNames = AstLexicalInformation.buildLexicalNamesArray(EN);
            this.exitLexicalUses = AstLexicalInformation.buildLexicalUseArray(EN, entityName);
            this.instructionLexicalUses = new int[instrs.length][];
            for (int i = 0; i < instrs.length; ++i) {
                if (!(instrs[i] instanceof SSAAbstractInvokeInstruction)) continue;
                this.instructionLexicalUses[i] = AstLexicalInformation.buildLexicalUseArray(EN, null);
            }
            if (accesses != null) {
                LinkedHashSet<String> parents = new LinkedHashSet<String>();
                for (AstLexicalAccess.Access AC : accesses) {
                    if (AC.variableDefiner == null) continue;
                    parents.add(AC.variableDefiner);
                }
                this.scopingParents = parents.toArray(new String[0]);
            } else {
                this.scopingParents = null;
            }
        }

        @Override
        public int[] getExitExposedUses() {
            return this.exitLexicalUses;
        }

        @Override
        public int[] getExposedUses(int instructionOffset) {
            return this.instructionLexicalUses[instructionOffset] == null ? NONE : this.instructionLexicalUses[instructionOffset];
        }

        @Override
        public IntSet getAllExposedUses() {
            if (this.allExposedUses == null) {
                this.allExposedUses = IntSetUtil.make();
                if (this.exitLexicalUses != null) {
                    for (int exitLexicalUse : this.exitLexicalUses) {
                        if (exitLexicalUse <= 0) continue;
                        this.allExposedUses.add(exitLexicalUse);
                    }
                }
                if (this.instructionLexicalUses != null) {
                    for (int[] instructionLexicalUse : this.instructionLexicalUses) {
                        if (instructionLexicalUse == null) continue;
                        for (int element : instructionLexicalUse) {
                            if (element <= 0) continue;
                            this.allExposedUses.add(element);
                        }
                    }
                }
            }
            return this.allExposedUses;
        }

        @Override
        public Pair<String, String>[] getExposedNames() {
            return this.exposedNames;
        }

        @Override
        public String[] getScopingParents() {
            return this.scopingParents;
        }

        @Override
        public boolean isReadOnly(String name) {
            return this.readOnlyNames != null && this.readOnlyNames.contains(name);
        }

        @Override
        public String getScopingName() {
            return this.functionLexicalName;
        }

        public static boolean hasExposedUses(CGNode caller, CallSiteReference site) {
            int[] uses = ((AstMethod)caller.getMethod()).lexicalInfo().getExposedUses(site.getProgramCounter());
            if (uses != null && uses.length > 0) {
                for (int use : uses) {
                    if (use <= 0) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class LocalContext
    extends DelegatingContext {
        private final Scope localScope;

        LocalContext(WalkContext parent, Scope localScope) {
            super(parent);
            this.localScope = localScope;
            parent.entityScopes().add(localScope);
        }

        @Override
        public Scope currentScope() {
            return this.localScope;
        }
    }

    protected final class TypeContext
    extends EntityContext {
        private TypeContext(WalkContext parent, CAstEntity n) {
            super(parent, n);
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            Assertions.UNREACHABLE("TypeContext.getControlFlow()");
            return null;
        }

        @Override
        public IncipientCFG cfg() {
            Assertions.UNREACHABLE("TypeContext.cfg()");
            return null;
        }

        @Override
        public UnwindState getUnwindState() {
            Assertions.UNREACHABLE("TypeContext.getUnwindState()");
            return null;
        }
    }

    public class CodeEntityContext
    extends EntityContext {
        private final Scope topEntityScope;
        private final Set<Scope> allEntityScopes;
        private final IncipientCFG cfg;
        private final Map<IBasicBlock<SSAInstruction>, TypeReference[]> catchTypes;
        Set<Pair<Pair<String, String>, Integer>> exposedReads;
        Set<Pair<Pair<String, String>, Integer>> exposedWrites;
        Set<AstLexicalAccess.Access> accesses;
        private final Map<CAstNode, Integer> results;

        public CodeEntityContext(WalkContext parent, Scope entityScope, CAstEntity s2) {
            super(parent, s2);
            this.catchTypes = HashMapFactory.make();
            this.results = new LinkedHashMap<CAstNode, Integer>();
            this.topEntityScope = entityScope;
            this.allEntityScopes = HashSetFactory.make();
            this.allEntityScopes.add(entityScope);
            this.cfg = new IncipientCFG();
        }

        @Override
        public WalkContext codeContext() {
            return this;
        }

        @Override
        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity e) {
            if (e == this.topNode) {
                if (this.accesses == null) {
                    this.accesses = HashSetFactory.make();
                }
                return this.accesses;
            }
            return super.getAccesses(e);
        }

        @Override
        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity entity, boolean writeSet) {
            if (entity == this.topNode) {
                if (writeSet) {
                    if (this.exposedWrites == null) {
                        this.exposedWrites = HashSetFactory.make();
                    }
                    return this.exposedWrites;
                }
                if (this.exposedReads == null) {
                    this.exposedReads = HashSetFactory.make();
                }
                return this.exposedReads;
            }
            return super.exposeNameSet(entity, writeSet);
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.top().getControlFlow();
        }

        @Override
        public IncipientCFG cfg() {
            return this.cfg;
        }

        @Override
        public Scope currentScope() {
            return this.topEntityScope;
        }

        @Override
        public Set<Scope> entityScopes() {
            return this.allEntityScopes;
        }

        @Override
        public UnwindState getUnwindState() {
            return null;
        }

        @Override
        public void setCatchType(CAstNode catchNode, TypeReference catchType) {
            this.setCatchType(this.cfg.getBlock(catchNode), catchType);
        }

        @Override
        public void setCatchType(IBasicBlock<SSAInstruction> bb, TypeReference catchType) {
            if (!this.catchTypes.containsKey(bb)) {
                this.catchTypes.put(bb, new TypeReference[]{catchType});
            } else {
                TypeReference[] data;
                for (TypeReference element : data = this.catchTypes.get(bb)) {
                    if (element != catchType) continue;
                    return;
                }
                TypeReference[] newData = Arrays.copyOf(data, data.length + 1);
                newData[data.length] = catchType;
                this.catchTypes.put(bb, newData);
            }
        }

        @Override
        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes() {
            return this.catchTypes;
        }

        @Override
        public boolean hasValue(CAstNode n) {
            return this.results.containsKey(n);
        }

        @Override
        public final int setValue(CAstNode n, int v) {
            this.results.put(n, v);
            return v;
        }

        @Override
        public final int getValue(CAstNode n) {
            if (this.results.containsKey(n)) {
                return this.results.get(n);
            }
            return -1;
        }
    }

    private abstract class EntityContext
    extends DelegatingContext {
        protected final CAstEntity topNode;
        protected final String name;

        EntityContext(WalkContext parent, CAstEntity s2) {
            super(parent);
            this.topNode = s2;
            this.name = AstTranslator.this.composeEntityName(parent, s2);
            this.addEntityName(s2, this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public CAstEntity top() {
            return this.topNode;
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.top().getSourceMap();
        }
    }

    private class UnwindContext
    extends DelegatingContext {
        private final UnwindState state;

        UnwindContext(CAstNode unwindNode, WalkContext parent, CAstVisitor<WalkContext> visitor) {
            super(parent);
            this.state = new UnwindState(unwindNode, parent, visitor);
        }

        @Override
        public UnwindState getUnwindState() {
            return this.state;
        }
    }

    private class FileContext
    extends DelegatingContext {
        private final String fUnitName;

        public FileContext(WalkContext parent, String unitName) {
            super(parent);
            this.fUnitName = unitName;
        }

        @Override
        public String getName() {
            return this.fUnitName;
        }
    }

    private abstract class DelegatingContext
    implements WalkContext {
        private final WalkContext parent;

        DelegatingContext(WalkContext parent) {
            this.parent = parent;
        }

        @Override
        public WalkContext codeContext() {
            return this.parent.codeContext();
        }

        @Override
        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity e) {
            return this.parent.getAccesses(e);
        }

        @Override
        public ModuleEntry getModule() {
            return this.parent.getModule();
        }

        @Override
        public String getName() {
            return this.parent.getName();
        }

        @Override
        public String file() {
            return this.parent.file();
        }

        @Override
        public CAstEntity top() {
            return this.parent.top();
        }

        @Override
        public CAstSourcePositionMap getSourceMap() {
            return this.parent.getSourceMap();
        }

        @Override
        public CAstControlFlowMap getControlFlow() {
            return this.parent.getControlFlow();
        }

        @Override
        public Scope currentScope() {
            return this.parent.currentScope();
        }

        @Override
        public Set<Scope> entityScopes() {
            return this.parent.entityScopes();
        }

        @Override
        public IncipientCFG cfg() {
            return this.parent.cfg();
        }

        @Override
        public UnwindState getUnwindState() {
            return this.parent.getUnwindState();
        }

        @Override
        public void setCatchType(IBasicBlock<SSAInstruction> bb, TypeReference catchType) {
            this.parent.setCatchType(bb, catchType);
        }

        @Override
        public void setCatchType(CAstNode catchNode, TypeReference catchType) {
            this.parent.setCatchType(catchNode, catchType);
        }

        @Override
        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes() {
            return this.parent.getCatchTypes();
        }

        @Override
        public void addEntityName(CAstEntity e, String name) {
            this.parent.addEntityName(e, name);
        }

        @Override
        public String getEntityName(CAstEntity e) {
            return this.parent.getEntityName(e);
        }

        @Override
        public boolean hasValue(CAstNode n) {
            return this.parent.hasValue(n);
        }

        @Override
        public int setValue(CAstNode n, int v) {
            return this.parent.setValue(n, v);
        }

        @Override
        public int getValue(CAstNode n) {
            return this.parent.getValue(n);
        }

        @Override
        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity entity, boolean writeSet) {
            return this.parent.exposeNameSet(entity, writeSet);
        }

        @Override
        public Scope getGlobalScope() {
            return this.parent.getGlobalScope();
        }
    }

    public static interface WalkContext
    extends CAstVisitor.Context {
        public WalkContext codeContext();

        public ModuleEntry getModule();

        public String getName();

        public String file();

        @Override
        public CAstSourcePositionMap getSourceMap();

        public CAstControlFlowMap getControlFlow();

        public Scope currentScope();

        public Set<Scope> entityScopes();

        public IncipientCFG cfg();

        public UnwindState getUnwindState();

        public void setCatchType(IBasicBlock<SSAInstruction> var1, TypeReference var2);

        public void setCatchType(CAstNode var1, TypeReference var2);

        public Map<IBasicBlock<SSAInstruction>, TypeReference[]> getCatchTypes();

        public void addEntityName(CAstEntity var1, String var2);

        public String getEntityName(CAstEntity var1);

        public boolean hasValue(CAstNode var1);

        public int setValue(CAstNode var1, int var2);

        public int getValue(CAstNode var1);

        public Set<Pair<Pair<String, String>, Integer>> exposeNameSet(CAstEntity var1, boolean var2);

        public Set<AstLexicalAccess.Access> getAccesses(CAstEntity var1);

        public Scope getGlobalScope();
    }

    public abstract class AbstractScope
    implements Scope {
        private final Scope parent;
        private final Map<String, Symbol> values = new LinkedHashMap<String, Symbol>();
        private final Map<String, String> caseInsensitiveNames = new LinkedHashMap<String, String>();

        protected abstract SymbolTable getUnderlyingSymtab();

        @Override
        public Scope getParent() {
            return this.parent;
        }

        @Override
        public int size() {
            return this.getUnderlyingSymtab().getMaxValueNumber() + 1;
        }

        @Override
        public Iterator<String> getAllNames() {
            return this.values.keySet().iterator();
        }

        @Override
        public int allocateTempValue() {
            return this.getUnderlyingSymtab().newSymbol();
        }

        @Override
        public int getConstantValue(Object o) {
            if (o instanceof Integer) {
                return this.getUnderlyingSymtab().getConstant((Integer)o);
            }
            if (o instanceof Float) {
                return this.getUnderlyingSymtab().getConstant(((Float)o).floatValue());
            }
            if (o instanceof Double) {
                return this.getUnderlyingSymtab().getConstant((Double)o);
            }
            if (o instanceof Long) {
                return this.getUnderlyingSymtab().getConstant((Long)o);
            }
            if (o instanceof String) {
                return this.getUnderlyingSymtab().getConstant((String)o);
            }
            if (o instanceof Boolean) {
                return this.getUnderlyingSymtab().getConstant((Boolean)o);
            }
            if (o instanceof Character) {
                return this.getUnderlyingSymtab().getConstant(((Character)o).charValue());
            }
            if (o instanceof Byte) {
                return this.getUnderlyingSymtab().getConstant(((Byte)o).byteValue());
            }
            if (o instanceof Short) {
                return this.getUnderlyingSymtab().getConstant(((Short)o).shortValue());
            }
            if (o == null) {
                return this.getUnderlyingSymtab().getNullConstant();
            }
            if (o == CAstControlFlowMap.SWITCH_DEFAULT) {
                return this.getUnderlyingSymtab().getConstant("__default label");
            }
            return this.getUnderlyingSymtab().getOtherConstant(o);
        }

        @Override
        public boolean isConstant(int valueNumber) {
            return this.getUnderlyingSymtab().isConstant(valueNumber);
        }

        @Override
        public Object getConstantObject(int valueNumber) {
            return this.getUnderlyingSymtab().getConstantValue(valueNumber);
        }

        @Override
        public void declare(CAstSymbol s2, int vn) {
            String nm = s2.name();
            if (!this.contains(nm)) {
                if (s2.isCaseInsensitive()) {
                    this.caseInsensitiveNames.put(nm.toLowerCase(), nm);
                }
                this.values.put(nm, this.makeSymbol(s2, vn));
            } else {
                assert (AstTranslator.this.hasImplicitGlobals());
                assert (this.isGlobal(this.lookup(nm)));
            }
        }

        @Override
        public void declare(CAstSymbol s2) {
            String nm = s2.name();
            if (!this.contains(nm) || this.lookup(nm).getDefiningScope() != this) {
                if (s2.isCaseInsensitive()) {
                    this.caseInsensitiveNames.put(nm.toLowerCase(), nm);
                }
                this.values.put(nm, this.makeSymbol(s2));
            } else assert (!s2.isFinal()) : "trying to redeclare " + nm;
        }

        protected AbstractScope(Scope parent) {
            this.parent = parent;
        }

        private final String mapName(String nm) {
            String mappedName = this.caseInsensitiveNames.get(nm.toLowerCase());
            return mappedName == null ? nm : mappedName;
        }

        protected Symbol makeSymbol(CAstSymbol s2) {
            return this.makeSymbol(s2.name(), s2.type(), s2.isFinal(), s2.isInternalName(), s2.defaultInitValue(), -1, this);
        }

        protected Symbol makeSymbol(CAstSymbol s2, int vn) {
            return this.makeSymbol(s2.name(), s2.type(), s2.isFinal(), s2.isInternalName(), s2.defaultInitValue(), vn, this);
        }

        protected abstract Symbol makeSymbol(String var1, CAstType var2, boolean var3, boolean var4, Object var5, int var6, Scope var7);

        @Override
        public boolean isCaseInsensitive(String nm) {
            return this.caseInsensitiveNames.containsKey(nm.toLowerCase());
        }

        @Override
        public Symbol lookup(String nm) {
            if (this.contains(nm)) {
                return this.values.get(this.mapName(nm));
            }
            Symbol scoped = this.parent.lookup(nm);
            if (scoped != null && this.getEntityScope() == this && (this.isGlobal(scoped) || this.isLexicallyScoped(scoped))) {
                this.values.put(nm, this.makeSymbol(nm, scoped.type(), scoped.isFinal(), scoped.isInternalName(), scoped.defaultInitValue(), -1, scoped.getDefiningScope()));
                if (scoped.getDefiningScope().isCaseInsensitive(nm)) {
                    this.caseInsensitiveNames.put(nm.toLowerCase(), nm);
                }
                return this.values.get(nm);
            }
            return scoped;
        }

        @Override
        public boolean contains(String nm) {
            String mappedName = this.caseInsensitiveNames.get(nm.toLowerCase());
            return this.values.containsKey(mappedName == null ? nm : mappedName);
        }

        @Override
        public boolean isGlobal(Symbol s2) {
            return s2.getDefiningScope().type() == ScopeType.GLOBAL;
        }

        @Override
        public abstract boolean isLexicallyScoped(Symbol var1);

        protected abstract AbstractScope getEntityScope();

        @Override
        public abstract CAstEntity getEntity();
    }

    public static abstract class AbstractSymbol
    implements Symbol {
        private Object constantValue;
        private final boolean isFinalValue;
        private final Scope definingScope;
        private final Object defaultValue;

        protected AbstractSymbol(Scope definingScope, boolean isFinalValue, Object defaultValue) {
            this.definingScope = definingScope;
            this.isFinalValue = isFinalValue;
            this.defaultValue = defaultValue;
        }

        @Override
        public boolean isFinal() {
            return this.isFinalValue;
        }

        @Override
        public Object defaultInitValue() {
            return this.defaultValue;
        }

        @Override
        public Object constant() {
            return this.constantValue;
        }

        @Override
        public void setConstant(Object cv) {
            this.constantValue = cv;
        }

        @Override
        public Scope getDefiningScope() {
            return this.definingScope;
        }
    }

    public static interface Scope {
        public ScopeType type();

        public int allocateTempValue();

        public int getConstantValue(Object var1);

        public boolean isConstant(int var1);

        public Object getConstantObject(int var1);

        public void declare(CAstSymbol var1);

        public void declare(CAstSymbol var1, int var2);

        public boolean isCaseInsensitive(String var1);

        public boolean contains(String var1);

        public Symbol lookup(String var1);

        public Iterator<String> getAllNames();

        public int size();

        public boolean isGlobal(Symbol var1);

        public boolean isLexicallyScoped(Symbol var1);

        public CAstEntity getEntity();

        public Scope getParent();
    }

    protected static interface Symbol {
        public int valueNumber();

        public Scope getDefiningScope();

        public boolean isParameter();

        public Object constant();

        public void setConstant(Object var1);

        public boolean isFinal();

        public boolean isGlobal();

        public boolean isInternalName();

        public Object defaultInitValue();

        public CAstType type();
    }

    public static class InternalCAstSymbol
    extends CAstSymbolImplBase {
        public InternalCAstSymbol(String _name, CAstType type) {
            super(_name, type, false, false, null);
        }

        public InternalCAstSymbol(String _name, CAstType type, boolean _isFinal) {
            super(_name, type, _isFinal, false, null);
        }

        public InternalCAstSymbol(String _name, CAstType type, boolean _isFinal, boolean _isCaseInsensitive) {
            super(_name, type, _isFinal, _isCaseInsensitive, null);
        }

        public InternalCAstSymbol(String _name, CAstType type, boolean _isFinal, boolean _isCaseInsensitive, Object _defaultInitValue) {
            super(_name, type, _isFinal, _isCaseInsensitive, _defaultInitValue);
        }

        @Override
        public boolean isInternalName() {
            return true;
        }
    }

    protected static class FinalCAstSymbol
    implements CAstSymbol {
        private final String _name;
        private final CAstType type;

        public FinalCAstSymbol(String _name, CAstType type) {
            this._name = _name;
            this.type = type;
            assert (_name != null);
            assert (type != null);
        }

        @Override
        public CAstType type() {
            return this.type;
        }

        @Override
        public String name() {
            return this._name;
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public boolean isCaseInsensitive() {
            return false;
        }

        @Override
        public boolean isInternalName() {
            return false;
        }

        @Override
        public Object defaultInitValue() {
            return null;
        }
    }

    public static enum ScopeType {
        LOCAL,
        GLOBAL,
        SCRIPT,
        FUNCTION,
        TYPE;

    }

    protected static final class AstCFG
    extends AbstractCFG<SSAInstruction, PreBasicBlock> {
        private SSAInstruction[] instructions;
        private final int[] instructionToBlockMap;
        private final int[] pcMap;
        private final String functionName;
        private final SymbolTable symtab;

        private void transferEdges(Set<PreBasicBlock> blocks, IncipientCFG icfg, EdgeOperation normal, EdgeOperation except) {
            for (PreBasicBlock src : blocks) {
                for (PreBasicBlock dst : Iterator2Iterable.make(icfg.getSuccNodes(src))) {
                    if (this.isCatchBlock(dst.getNumber()) || dst.isExitBlock() && icfg.exceptionalToExit.contains(src)) {
                        except.act(src, dst);
                    }
                    if (!(dst.isExitBlock() ? icfg.normalToExit.contains(src) : !this.isCatchBlock(dst.getNumber()))) continue;
                    normal.act(src, dst);
                }
            }
        }

        private static boolean checkBlockBoundaries(IncipientCFG icfg) {
            MutableIntSet boundaries = IntSetUtil.make();
            for (PreBasicBlock b : icfg) {
                if (b.getFirstInstructionIndex() >= 0) {
                    if (boundaries.contains(b.getFirstInstructionIndex())) {
                        return false;
                    }
                    boundaries.add(b.getFirstInstructionIndex());
                }
                if (b.getLastInstructionIndex() < 0 || b.getLastInstructionIndex() == b.getFirstInstructionIndex()) continue;
                if (boundaries.contains(b.getLastInstructionIndex())) {
                    return false;
                }
                boundaries.add(b.getLastInstructionIndex());
            }
            return true;
        }

        AstCFG(CAstEntity n, IncipientCFG icfg, SymbolTable symtab, SSAInstructionFactory insts) {
            super(null);
            HashMap exceptionalEdges;
            boolean hasDeadBlocks;
            Set<PreBasicBlock> liveBlocks = DFS.getReachableNodes(icfg, Collections.singleton(icfg.entryBlock));
            List blocks = icfg.blocks;
            boolean bl = hasDeadBlocks = blocks.size() > liveBlocks.size();
            assert (AstCFG.checkBlockBoundaries(icfg));
            this.symtab = symtab;
            this.functionName = n.getName();
            this.instructionToBlockMap = new int[liveBlocks.size()];
            this.pcMap = hasDeadBlocks ? new int[icfg.currentInstruction] : null;
            HashMap normalEdges = hasDeadBlocks ? HashMapFactory.make() : null;
            HashMap hashMap = exceptionalEdges = hasDeadBlocks ? HashMapFactory.make() : null;
            if (hasDeadBlocks) {
                this.transferEdges(liveBlocks, icfg, (src, dst) -> {
                    if (!normalEdges.containsKey(src)) {
                        normalEdges.put(src, HashSetFactory.make());
                    }
                    ((Collection)normalEdges.get(src)).add(dst);
                }, (src, dst) -> {
                    if (!exceptionalEdges.containsKey(src)) {
                        exceptionalEdges.put(src, HashSetFactory.make());
                    }
                    ((Collection)exceptionalEdges.get(src)).add(dst);
                });
            }
            int instruction = 0;
            int blockNumber = 0;
            for (int i = 0; i < blocks.size(); ++i) {
                Object block = (PreBasicBlock)blocks.get(i);
                ((PreBasicBlock)block).setGraphNodeId(-1);
                if (!liveBlocks.contains(block)) continue;
                if (hasDeadBlocks) {
                    int oldPC = ((PreBasicBlock)block).getFirstInstructionIndex();
                    for (int offset = 0; offset < ((PreBasicBlock)block).instructions().size(); ++offset) {
                        this.pcMap[instruction + offset] = oldPC++;
                    }
                }
                if (((PreBasicBlock)block).getFirstInstructionIndex() >= 0) {
                    ((PreBasicBlock)block).setFirstIndex(instruction);
                    ((PreBasicBlock)block).setLastIndex((instruction += ((PreBasicBlock)block).instructions().size()) - 1);
                }
                this.instructionToBlockMap[blockNumber] = ((PreBasicBlock)block).getLastInstructionIndex();
                this.addNode(block);
                if (((PreBasicBlock)block).isCatchBlock()) {
                    this.setCatchBlock(blockNumber);
                }
                ++blockNumber;
            }
            this.init();
            if (hasDeadBlocks) {
                for (PreBasicBlock src2 : blocks) {
                    if (!liveBlocks.contains(src2)) continue;
                    if (normalEdges.containsKey(src2)) {
                        for (PreBasicBlock succ : (Collection)normalEdges.get(src2)) {
                            if (!liveBlocks.contains(succ)) continue;
                            this.addNormalEdge(src2, succ);
                        }
                    }
                    if (!exceptionalEdges.containsKey(src2)) continue;
                    for (PreBasicBlock succ : (Collection)exceptionalEdges.get(src2)) {
                        if (!liveBlocks.contains(succ)) continue;
                        this.addExceptionalEdge(src2, succ);
                    }
                }
            } else {
                this.transferEdges(liveBlocks, icfg, this::addNormalEdge, this::addExceptionalEdge);
            }
            int x = 0;
            this.instructions = new SSAInstruction[icfg.currentInstruction];
            for (Object block : blocks) {
                if (!liveBlocks.contains(block)) continue;
                List bi = ((PreBasicBlock)block).instructions();
                for (SSAInstruction inst : bi) {
                    Iterator succs;
                    if (inst instanceof SSAGetCaughtExceptionInstruction) {
                        SSAGetCaughtExceptionInstruction ci = (SSAGetCaughtExceptionInstruction)inst;
                        if (ci.getBasicBlockNumber() != ((PreBasicBlock)block).getNumber()) {
                            inst = insts.GetCaughtExceptionInstruction(x, ((PreBasicBlock)block).getNumber(), ci.getException());
                        }
                    } else if (inst instanceof SSAGotoInstruction) {
                        succs = this.getNormalSuccessors(block).iterator();
                        if (succs.hasNext()) {
                            PreBasicBlock target = (PreBasicBlock)((Object)succs.next());
                            assert (liveBlocks.contains(target));
                            assert (!succs.hasNext() || !liveBlocks.contains(succs.next())) : "unexpected successors for block " + block + ": " + this;
                            inst = insts.GotoInstruction(x, target.firstIndex);
                        } else {
                            inst = null;
                        }
                    } else if (inst instanceof SSAThrowInstruction) {
                        if (this.getExceptionalSuccessors(block).isEmpty()) {
                            this.addExceptionalEdge(block, this.exit());
                        }
                    } else if (inst instanceof SSAConditionalBranchInstruction) {
                        int target;
                        succs = this.getNormalSuccessors(block).iterator();
                        assert (succs.hasNext());
                        int t1 = ((PreBasicBlock)((Object)succs.next())).firstIndex;
                        if (succs.hasNext()) {
                            int t2 = ((PreBasicBlock)((Object)succs.next())).firstIndex;
                            target = t1 == x + 1 ? t2 : t1;
                        } else {
                            target = t1;
                        }
                        SSAConditionalBranchInstruction branch = (SSAConditionalBranchInstruction)inst;
                        inst = insts.ConditionalBranchInstruction(x, branch.getOperator(), branch.getType(), branch.getUse(0), branch.getUse(1), target);
                    }
                    this.instructions[x++] = inst;
                }
            }
            if (hasDeadBlocks) {
                for (int i = 0; i < this.instructions.length; ++i) {
                    if (this.instructions[i] == null || this.instructions[i].iIndex() == i) continue;
                    this.instructions[i].setInstructionIndex(i);
                }
            }
            if (this.instructions.length > x) {
                SSAInstruction[] ni = new SSAInstruction[x];
                System.arraycopy(this.instructions, 0, ni, 0, x);
                this.instructions = ni;
            }
        }

        @Override
        public int hashCode() {
            return this.functionName.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof AstCFG && this.functionName.equals(((AstCFG)o).functionName);
        }

        @Override
        public PreBasicBlock getBlockForInstruction(int index) {
            for (int i = 1; i < this.getNumberOfNodes() - 1; ++i) {
                if (index > this.instructionToBlockMap[i]) continue;
                return (PreBasicBlock)this.getNode(i);
            }
            return null;
        }

        public SSAInstruction[] getInstructions() {
            return this.instructions;
        }

        @Override
        public int getProgramCounter(int index) {
            return this.pcMap == null ? index : this.pcMap[index];
        }

        @Override
        public String toString() {
            int[] params;
            SSAInstruction[] insts = this.getInstructions();
            StringBuilder s2 = new StringBuilder("CAst CFG of " + this.functionName);
            for (int param : params = this.symtab.getParameterValueNumbers()) {
                s2.append(' ').append(param);
            }
            s2.append('\n');
            for (int i = 0; i < this.getNumberOfNodes(); ++i) {
                PreBasicBlock bb = (PreBasicBlock)this.getNode(i);
                s2.append(bb).append('\n');
                for (PreBasicBlock pbb : Iterator2Iterable.make(this.getSuccNodes(bb))) {
                    s2.append("    -->").append(pbb).append('\n');
                }
                for (int j = bb.getFirstInstructionIndex(); j <= bb.getLastInstructionIndex(); ++j) {
                    if (insts[j] == null) continue;
                    s2.append("  ").append(insts[j].toString(this.symtab)).append('\n');
                }
            }
            s2.append("-- END --");
            return s2.toString();
        }

        private static interface EdgeOperation {
            public void act(PreBasicBlock var1, PreBasicBlock var2);
        }
    }

    public final class IncipientCFG
    extends SparseNumberedGraph<PreBasicBlock> {
        private Unwind unwind = null;
        private final List<PreBasicBlock> blocks = new ArrayList<PreBasicBlock>();
        private PreBasicBlock entryBlock;
        private final Map<CAstNode, PreBasicBlock> nodeToBlock = new LinkedHashMap<CAstNode, PreBasicBlock>();
        private final Map<Object, Set<Pair<PreBasicBlock, Boolean>>> delayedEdges = new LinkedHashMap<Object, Set<Pair<PreBasicBlock, Boolean>>>();
        private final Object exitMarker = new Object();
        private final Set<PreBasicBlock> deadBlocks = new LinkedHashSet<PreBasicBlock>();
        private final Set<PreBasicBlock> normalToExit = new LinkedHashSet<PreBasicBlock>();
        private final Set<PreBasicBlock> exceptionalToExit = new LinkedHashSet<PreBasicBlock>();
        private CAstSourcePositionMap.Position[] linePositions = new CAstSourcePositionMap.Position[10];
        private CAstSourcePositionMap.Position[][] operandPositions = new CAstSourcePositionMap.Position[10][];
        private boolean hasCatchBlock = false;
        private boolean hasMonitorOp = false;
        private int currentInstruction = 0;
        private PreBasicBlock currentBlock;

        public int getCurrentInstruction() {
            return this.currentInstruction;
        }

        public PreBasicBlock getCurrentBlock() {
            return this.currentBlock;
        }

        boolean hasCatchBlock() {
            return this.hasCatchBlock;
        }

        boolean hasMonitorOp() {
            return this.hasMonitorOp;
        }

        void noteCatchBlock() {
            this.hasCatchBlock = true;
        }

        CAstSourcePositionMap.Position[] getLinePositionMap() {
            return this.linePositions;
        }

        public PreBasicBlock newBlock(boolean fallThruFromPrior) {
            if (fallThruFromPrior && !this.currentBlock.isEntryBlock() && this.currentBlock.instructions().size() == 0) {
                return this.currentBlock;
            }
            PreBasicBlock previous = this.currentBlock;
            this.currentBlock = new PreBasicBlock();
            this.addNode(this.currentBlock);
            this.blocks.add(this.currentBlock);
            if (fallThruFromPrior) {
                this.addEdge(previous, this.currentBlock);
            } else {
                this.deadBlocks.add(this.currentBlock);
            }
            return this.currentBlock;
        }

        private void addDelayedEdge(PreBasicBlock src, Object dst, boolean exception) {
            MapUtil.findOrCreateSet(this.delayedEdges, dst).add(Pair.make(src, exception));
        }

        void makeEntryBlock(PreBasicBlock bb) {
            this.entryBlock = bb;
            bb.makeEntryBlock();
        }

        void makeExitBlock(PreBasicBlock bb) {
            bb.makeExitBlock();
            for (PreBasicBlock p : Iterator2Iterable.make(this.getPredNodes(bb))) {
                this.normalToExit.add(p);
            }
            this.checkForRealizedExitEdges(bb);
        }

        public void setCurrentBlockAsHandler() {
            this.currentBlock.makeHandlerBlock();
        }

        boolean hasDelayedEdges(CAstNode n) {
            return this.delayedEdges.containsKey(n);
        }

        private void checkForRealizedEdges(CAstNode n) {
            if (this.delayedEdges.containsKey(n)) {
                for (Pair<PreBasicBlock, Boolean> s2 : this.delayedEdges.get(n)) {
                    PreBasicBlock src = (PreBasicBlock)s2.fst;
                    boolean exception = (Boolean)s2.snd;
                    if (this.unwind == null) {
                        this.addEdge(src, this.nodeToBlock.get(n));
                        continue;
                    }
                    PreBasicBlock target = this.nodeToBlock.get(n);
                    this.addEdge(src, this.unwind.findOrCreateCode(src, target, exception));
                }
                this.delayedEdges.remove(n);
            }
        }

        private void checkForRealizedExitEdges(PreBasicBlock exitBlock) {
            if (this.delayedEdges.containsKey(this.exitMarker)) {
                for (Pair<PreBasicBlock, Boolean> s2 : this.delayedEdges.get(this.exitMarker)) {
                    PreBasicBlock src = (PreBasicBlock)s2.fst;
                    boolean exception = (Boolean)s2.snd;
                    this.addEdge(src, exitBlock);
                    if (exception) {
                        this.exceptionalToExit.add(src);
                        continue;
                    }
                    this.normalToExit.add(src);
                }
                this.delayedEdges.remove(this.exitMarker);
            }
        }

        private void setUnwindState(CAstNode node, UnwindState context) {
            if (this.unwind == null) {
                this.unwind = new Unwind();
            }
            this.unwind.setUnwindState(node, context);
        }

        public void addPreNode(CAstNode n) {
            this.addPreNode(n, null);
        }

        public void addPreNode(CAstNode n, UnwindState context) {
            this.nodeToBlock.put(n, this.currentBlock);
            this.deadBlocks.remove(this.currentBlock);
            if (context != null) {
                this.setUnwindState(n, context);
            }
            this.checkForRealizedEdges(n);
        }

        public void addPreEdge(CAstNode src, CAstNode dst, boolean exception) {
            assert (this.nodeToBlock.containsKey(src));
            this.addPreEdge(this.nodeToBlock.get(src), dst, exception);
        }

        public void addPreEdge(PreBasicBlock src, CAstNode dst, boolean exception) {
            if (dst == CAstControlFlowMap.EXCEPTION_TO_EXIT) {
                assert (exception);
                this.addPreEdgeToExit(src, exception);
            } else if (this.nodeToBlock.containsKey(dst)) {
                PreBasicBlock target = this.nodeToBlock.get(dst);
                if (this.unwind == null) {
                    this.addEdge(src, target);
                } else {
                    this.addEdge(src, this.unwind.findOrCreateCode(src, target, exception));
                }
            } else {
                this.addDelayedEdge(src, dst, exception);
            }
        }

        public void addPreEdgeToExit(CAstNode src, boolean exception) {
            assert (this.nodeToBlock.containsKey(src));
            this.addPreEdgeToExit(this.nodeToBlock.get(src), exception);
        }

        public void addPreEdgeToExit(PreBasicBlock src, boolean exception) {
            PreBasicBlock handlers;
            if (this.unwind != null && (handlers = this.unwind.findOrCreateCode(src, null, exception)) != null) {
                this.addEdge(src, handlers);
                return;
            }
            this.addDelayedEdge(src, this.exitMarker, exception);
        }

        @Override
        public void addEdge(PreBasicBlock src, PreBasicBlock dst) {
            super.addEdge(src, dst);
            this.deadBlocks.remove(dst);
        }

        public boolean isDeadBlock(PreBasicBlock block) {
            return this.deadBlocks.contains(block);
        }

        public PreBasicBlock getBlock(CAstNode n) {
            return this.nodeToBlock.get(n);
        }

        private void noteLinePosition(int instruction) {
            this.ensurePositionSpace(instruction);
            this.linePositions[instruction] = AstTranslator.this.getCurrentPosition();
        }

        private void ensurePositionSpace(int instruction) {
            if (this.linePositions.length < instruction + 1) {
                this.linePositions = Arrays.copyOf(this.linePositions, instruction * 2 + 1);
                this.operandPositions = (CAstSourcePositionMap.Position[][])Arrays.copyOf(this.operandPositions, instruction * 2 + 1);
            }
        }

        public void noteOperands(int instruction, CAstSourcePositionMap.Position ... operands) {
            this.ensurePositionSpace(instruction);
            this.operandPositions[instruction] = operands;
        }

        public void addInstruction(SSAInstruction n) {
            this.deadBlocks.remove(this.currentBlock);
            int inst = this.currentInstruction++;
            this.noteLinePosition(inst);
            if (this.currentBlock.instructions().size() == 0) {
                this.currentBlock.setFirstIndex(inst);
            } else {
                for (SSAInstruction priorInst : this.currentBlock.instructions()) {
                    assert (!(priorInst instanceof SSAGotoInstruction));
                }
                assert (!(n instanceof SSAGetCaughtExceptionInstruction));
            }
            if (n instanceof SSAMonitorInstruction) {
                this.hasMonitorOp = true;
            }
            this.currentBlock.instructions().add(n);
            this.currentBlock.setLastIndex(inst);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            for (PreBasicBlock b : this.blocks) {
                if (b.firstIndex <= 0) continue;
                sb.append('\n').append(b);
                for (int i = 0; i < b.instructions.size(); ++i) {
                    sb.append('\n').append(b.instructions.get(i));
                }
            }
            return sb.toString();
        }

        public CAstSourcePositionMap.Position[][] getOperandPositionMap() {
            return this.operandPositions;
        }

        protected class Unwind {
            private final Map<PreBasicBlock, UnwindState> unwindData = new LinkedHashMap<PreBasicBlock, UnwindState>();
            private final Map<Pair<UnwindState, Pair<PreBasicBlock, Boolean>>, PreBasicBlock> code = new LinkedHashMap<Pair<UnwindState, Pair<PreBasicBlock, Boolean>>, PreBasicBlock>();

            protected Unwind() {
            }

            void setUnwindState(PreBasicBlock block, UnwindState context) {
                this.unwindData.put(block, context);
            }

            void setUnwindState(CAstNode node, UnwindState context) {
                this.unwindData.put((PreBasicBlock)IncipientCFG.this.nodeToBlock.get(node), context);
            }

            public PreBasicBlock findOrCreateCode(PreBasicBlock source, PreBasicBlock target, final boolean exception) {
                CAstNode dummy;
                UnwindState sourceContext = this.unwindData.get(source);
                CAstNode cAstNode = dummy = exception ? new CAstImpl().makeNode(19) : null;
                if (sourceContext == null) {
                    return target;
                }
                WalkContext astContext = sourceContext.astContext;
                UnwindState targetContext = null;
                if (target != null) {
                    targetContext = this.unwindData.get(target);
                }
                if (targetContext != null && targetContext.covers(sourceContext)) {
                    return target;
                }
                Pair<UnwindState, Pair<PreBasicBlock, Boolean>> key = Pair.make(sourceContext, Pair.make(target, exception));
                if (this.code.containsKey(key)) {
                    return this.code.get(key);
                }
                int e = -1;
                PreBasicBlock currentBlock = IncipientCFG.this.getCurrentBlock();
                if (!IncipientCFG.this.isDeadBlock(currentBlock)) {
                    IncipientCFG.this.addInstruction(AstTranslator.this.insts.GotoInstruction(IncipientCFG.this.currentInstruction, -1));
                    IncipientCFG.this.newBlock(false);
                }
                PreBasicBlock startBlock = IncipientCFG.this.getCurrentBlock();
                if (exception) {
                    IncipientCFG.this.setCurrentBlockAsHandler();
                    e = sourceContext.astContext.currentScope().allocateTempValue();
                    IncipientCFG.this.addInstruction(AstTranslator.this.insts.GetCaughtExceptionInstruction(IncipientCFG.this.currentInstruction, startBlock.getNumber(), e));
                    sourceContext.astContext.setCatchType(startBlock, AstTranslator.this.defaultCatchType());
                }
                while (!(sourceContext == null || targetContext != null && targetContext.covers(sourceContext))) {
                    final CAstRewriter.Rewrite ast = new CAstCloner(new CAstImpl()){

                        @Override
                        protected CAstNode flowOutTo(Map<Pair<CAstNode, CAstBasicRewriter.NoKey>, CAstNode> nodeMap, CAstNode oldSource, Object label, CAstNode oldTarget, CAstControlFlowMap orig, CAstSourcePositionMap src) {
                            if (exception && !AstTranslator.this.isExceptionLabel(label)) {
                                return dummy;
                            }
                            return oldTarget;
                        }
                    }.copy(sourceContext.unwindAst, sourceContext.astContext.getControlFlow(), sourceContext.astContext.getSourceMap(), sourceContext.astContext.top().getNodeTypeMap(), sourceContext.astContext.top().getAllScopedEntities(), sourceContext.astContext.top().getArgumentDefaults());
                    sourceContext.astVisitor.visit(ast.newRoot(), new DelegatingContext(sourceContext.astContext){

                        @Override
                        public CAstSourcePositionMap getSourceMap() {
                            return ast.newPos();
                        }

                        @Override
                        public CAstControlFlowMap getControlFlow() {
                            return ast.newCfg();
                        }
                    }, sourceContext.astVisitor);
                    sourceContext = sourceContext.getParent();
                }
                PreBasicBlock endBlock = IncipientCFG.this.getCurrentBlock();
                if (exception) {
                    assert (this.unwindData.get(endBlock) == null);
                    IncipientCFG.this.addPreNode(dummy);
                    AstTranslator.this.doThrow(astContext, e);
                } else {
                    IncipientCFG.this.addInstruction(AstTranslator.this.insts.GotoInstruction(IncipientCFG.this.currentInstruction, -1));
                }
                IncipientCFG.this.newBlock(false);
                if (target != null) {
                    IncipientCFG.this.addEdge(currentBlock, IncipientCFG.this.getCurrentBlock());
                    assert (this.unwindData.get(IncipientCFG.this.getCurrentBlock()) == null);
                    IncipientCFG.this.addEdge(endBlock, target);
                } else if (exception) {
                    IncipientCFG.this.addEdge(currentBlock, IncipientCFG.this.getCurrentBlock());
                } else {
                    IncipientCFG.this.addDelayedEdge(endBlock, IncipientCFG.this.exitMarker, exception);
                }
                this.code.put(key, startBlock);
                return startBlock;
            }
        }
    }

    protected static final class UnwindState {
        final CAstNode unwindAst;
        final WalkContext astContext;
        final CAstVisitor<WalkContext> astVisitor;

        UnwindState(CAstNode unwindAst, WalkContext astContext, CAstVisitor<WalkContext> astVisitor) {
            this.unwindAst = unwindAst;
            this.astContext = astContext;
            this.astVisitor = astVisitor;
        }

        public UnwindState getParent() {
            return this.astContext.getUnwindState();
        }

        public int hashCode() {
            return this.astContext.hashCode() * this.unwindAst.hashCode() * this.astVisitor.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof UnwindState) {
                if (((UnwindState)o).unwindAst != this.unwindAst) {
                    return false;
                }
                if (((UnwindState)o).astVisitor != this.astVisitor) {
                    return false;
                }
                if (this.getParent() == null) {
                    return ((UnwindState)o).getParent() == null;
                }
                return this.getParent().equals(((UnwindState)o).getParent());
            }
            return false;
        }

        boolean covers(UnwindState other) {
            if (this.equals(other)) {
                return true;
            }
            if (this.getParent() != null) {
                return this.getParent().covers(other);
            }
            return false;
        }
    }

    protected static final class PreBasicBlock
    implements IBasicBlock<SSAInstruction> {
        private static final int NORMAL = 0;
        private static final int HANDLER = 1;
        private static final int ENTRY = 2;
        private static final int EXIT = 3;
        private int kind = 0;
        private int number = -1;
        private int firstIndex = -1;
        private int lastIndex = -2;
        private final List<SSAInstruction> instructions = new ArrayList<SSAInstruction>();

        protected PreBasicBlock() {
        }

        @Override
        public int getNumber() {
            return this.getGraphNodeId();
        }

        @Override
        public int getGraphNodeId() {
            return this.number;
        }

        @Override
        public void setGraphNodeId(int number) {
            this.number = number;
        }

        @Override
        public int getFirstInstructionIndex() {
            return this.firstIndex;
        }

        void setFirstIndex(int firstIndex) {
            this.firstIndex = firstIndex;
        }

        @Override
        public int getLastInstructionIndex() {
            return this.lastIndex;
        }

        void setLastIndex(int lastIndex) {
            this.lastIndex = lastIndex;
        }

        void makeExitBlock() {
            this.kind = 3;
        }

        void makeEntryBlock() {
            this.kind = 2;
        }

        void makeHandlerBlock() {
            this.kind = 1;
        }

        @Override
        public boolean isEntryBlock() {
            return this.kind == 2;
        }

        @Override
        public boolean isExitBlock() {
            return this.kind == 3;
        }

        public boolean isHandlerBlock() {
            return this.kind == 1;
        }

        public String toString() {
            return "PreBB" + this.number + ':' + this.firstIndex + ".." + this.lastIndex;
        }

        private List<SSAInstruction> instructions() {
            return this.instructions;
        }

        @Override
        public boolean isCatchBlock() {
            return this.lastIndex > -1 && this.instructions.get(0) instanceof SSAGetCaughtExceptionInstruction;
        }

        @Override
        public IMethod getMethod() {
            return null;
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            return this.instructions.iterator();
        }
    }

    private static class AstDebuggingInformation
    implements AstMethod.DebuggingInformation {
        private final CAstSourcePositionMap.Position codeBodyPosition;
        private final CAstSourcePositionMap.Position codeBodyNamePosition;
        private final String[][] valueNumberNames;
        private final CAstSourcePositionMap.Position[] instructionPositions;
        private final CAstSourcePositionMap.Position[][] operandPositions;
        private final CAstSourcePositionMap.Position[] parameterPositions;
        private final SortedSet<CAstSourcePositionMap.Position> codePositions;

        AstDebuggingInformation(CAstSourcePositionMap.Position codeBodyNamePosition, CAstSourcePositionMap.Position codeBodyPosition, CAstSourcePositionMap.Position[] instructionPositions, CAstSourcePositionMap.Position[][] operandPositions, CAstSourcePositionMap.Position[] parameterPositions, String[] names, SortedSet<CAstSourcePositionMap.Position> codePositions) {
            this.codePositions = codePositions;
            this.codeBodyNamePosition = codeBodyNamePosition;
            this.codeBodyPosition = codeBodyPosition;
            this.instructionPositions = instructionPositions;
            this.operandPositions = operandPositions;
            this.parameterPositions = parameterPositions;
            this.valueNumberNames = new String[names.length][];
            for (int i = 0; i < names.length; ++i) {
                this.valueNumberNames[i] = names[i] != null ? new String[]{names[i]} : new String[0];
            }
        }

        @Override
        public CAstSourcePositionMap.Position getCodeBodyPosition() {
            return this.codeBodyPosition;
        }

        @Override
        public CAstSourcePositionMap.Position getCodeNamePosition() {
            return this.codeBodyNamePosition;
        }

        @Override
        public CAstSourcePositionMap.Position getInstructionPosition(int instructionOffset) {
            return this.instructionPositions[instructionOffset];
        }

        @Override
        public CAstSourcePositionMap.Position getOperandPosition(int instructionOffset, int operand) {
            if (this.operandPositions[instructionOffset] != null && this.operandPositions[instructionOffset].length > operand) {
                return this.operandPositions[instructionOffset][operand];
            }
            return null;
        }

        @Override
        public String[][] getSourceNamesForValues() {
            return this.valueNumberNames;
        }

        @Override
        public CAstSourcePositionMap.Position getParameterPosition(int param) {
            return this.parameterPositions[param];
        }

        private static boolean disjoint(CAstSourcePositionMap.Position a, CAstSourcePositionMap.Position b) {
            return a.getLastLine() < b.getFirstLine() || a.getLastLine() == b.getFirstLine() && a.getLastCol() < b.getFirstCol() || b.getLastLine() < a.getFirstLine() || b.getLastLine() == a.getFirstLine() && b.getLastCol() < a.getFirstCol();
        }

        private String getComment(int instructionOffset, Function<CAstSourcePositionMap.Position, SortedSet<CAstSourcePositionMap.Position>> set) throws IOException {
            final CAstSourcePositionMap.Position pos = this.getInstructionPosition(instructionOffset);
            if (pos == null) {
                return null;
            }
            SortedSet<CAstSourcePositionMap.Position> prevSet = set.apply(pos);
            if (prevSet != null && !prevSet.isEmpty()) {
                Comparable<IMethod.SourcePosition> second;
                Comparable first;
                Comparable ppos = null;
                for (CAstSourcePositionMap.Position other : prevSet) {
                    if (!AstDebuggingInformation.disjoint(other, pos)) continue;
                    ppos = other;
                    break;
                }
                if (ppos == null) {
                    return null;
                }
                if (ppos.compareTo(pos) < 0) {
                    first = ppos;
                    second = pos;
                } else {
                    first = pos;
                    second = ppos;
                }
                AbstractSourcePosition intermediate = new AbstractSourcePosition((CAstSourcePositionMap.Position)first, (CAstSourcePositionMap.Position)second){
                    final /* synthetic */ CAstSourcePositionMap.Position val$first;
                    final /* synthetic */ CAstSourcePositionMap.Position val$second;
                    {
                        this.val$first = position2;
                        this.val$second = position3;
                    }

                    @Override
                    public URL getURL() {
                        return pos.getURL();
                    }

                    @Override
                    public Reader getReader() throws IOException {
                        return pos.getReader();
                    }

                    @Override
                    public int getFirstLine() {
                        return this.val$first.getLastLine();
                    }

                    @Override
                    public int getLastLine() {
                        return this.val$second.getFirstLine();
                    }

                    @Override
                    public int getFirstCol() {
                        return this.val$first.getLastCol();
                    }

                    @Override
                    public int getLastCol() {
                        return this.val$second.getFirstCol();
                    }

                    @Override
                    public int getFirstOffset() {
                        return this.val$first.getLastOffset();
                    }

                    @Override
                    public int getLastOffset() {
                        return this.val$second.getFirstOffset();
                    }
                };
                return new SourceBuffer(intermediate).toString();
            }
            return null;
        }

        @Override
        public String getFollowingComment(int instructionOffset) throws IOException {
            return this.getComment(instructionOffset, this.codePositions::tailSet);
        }

        @Override
        public String getLeadingComment(int instructionOffset) throws IOException {
            return this.getComment(instructionOffset, this.codePositions::headSet);
        }
    }
}

