/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.translator;

import com.ibm.wala.cast.ir.translator.NativeBridge;
import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public abstract class NativeTranslatorToCAst
extends NativeBridge
implements TranslatorToCAst {
    protected final URL sourceURL;
    protected final String sourceFileName;

    protected NativeTranslatorToCAst(CAst Ast, URL sourceURL, String sourceFileName) {
        super(Ast);
        this.sourceURL = sourceURL;
        this.sourceFileName = sourceFileName;
    }

    protected String getLocalFile() {
        return this.sourceFileName;
    }

    protected String getFile() {
        return this.sourceURL.getFile();
    }

    protected CAstSourcePositionMap.Position makeLocation(final int fl, final int fc, final int ll, final int lc) {
        return new AbstractSourcePosition(){

            @Override
            public int getFirstLine() {
                return fl;
            }

            @Override
            public int getLastLine() {
                return ll;
            }

            @Override
            public int getFirstCol() {
                return fc;
            }

            @Override
            public int getLastCol() {
                return lc;
            }

            @Override
            public int getFirstOffset() {
                return -1;
            }

            @Override
            public int getLastOffset() {
                return -1;
            }

            @Override
            public URL getURL() {
                return NativeTranslatorToCAst.this.sourceURL;
            }

            public InputStream getInputStream() throws IOException {
                return new FileInputStream(NativeTranslatorToCAst.this.sourceFileName);
            }

            @Override
            public String toString() {
                String urlString = NativeTranslatorToCAst.this.sourceURL.toString();
                if (urlString.lastIndexOf(File.separator) == -1) {
                    return "[" + fl + ':' + fc + "]->[" + ll + ':' + lc + ']';
                }
                return urlString.substring(urlString.lastIndexOf(File.separator) + 1) + "@[" + fl + ':' + fc + "]->[" + ll + ':' + lc + ']';
            }

            @Override
            public Reader getReader() throws IOException {
                return new InputStreamReader(this.getInputStream());
            }
        };
    }

    @Override
    public abstract CAstEntity translateToCAst();
}

