/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.translator;

import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstControlFlowRecorder;
import com.ibm.wala.cast.tree.impl.CAstNodeTypeMapRecorder;
import com.ibm.wala.cast.tree.impl.CAstSourcePositionRecorder;
import com.ibm.wala.cast.tree.rewrite.CAstCloner;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.cast.tree.rewrite.CAstRewriterFactory;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.warnings.Warning;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface TranslatorToCAst {
    public <C extends CAstRewriter.RewriteContext<K>, K extends CAstRewriter.CopyKey<K>> void addRewriter(CAstRewriterFactory<C, K> var1, boolean var2);

    public CAstEntity translateToCAst() throws Error, IOException;

    default public <X extends WalkContext<X, Y>, Y> void pushSourcePosition(WalkContext<X, Y> context, CAstNode n, CAstSourcePositionMap.Position p) {
        if (!1.$assertionsDisabled && context.pos() == null) {
            throw new AssertionError();
        }
        if (n != null && context.pos().getPosition(n) == null && n.getKind() != 100 && n.getKind() != 13) {
            context.pos().setPosition(n, p);
            for (CAstNode child : n.getChildren()) {
                this.pushSourcePosition(context, child, p);
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class DoLoopTranslator {
        private final boolean replicateForDoLoops;
        private final CAst Ast;

        public DoLoopTranslator(boolean replicateForDoLoops, CAst ast) {
            this.replicateForDoLoops = replicateForDoLoops;
            this.Ast = ast;
        }

        public CAstNode translateDoLoop(CAstNode loopTest, CAstNode loopBody, CAstNode continueNode, CAstNode breakNode, WalkContext<?, ?> wc) {
            if (this.replicateForDoLoops) {
                loopBody = this.Ast.makeNode(3, loopBody, continueNode);
                CAstRewriter.Rewrite x = new CAstCloner(this.Ast, false).copy(loopBody, wc.cfg(), wc.pos(), wc.getNodeTypeMap(), null, null);
                CAstNode otherBody = x.newRoot();
                wc.cfg().addAll(x.newCfg());
                wc.pos().addAll(x.newPos());
                wc.getNodeTypeMap().addAll(x.newTypes());
                return this.Ast.makeNode(3, loopBody, this.Ast.makeNode(2, loopTest, otherBody), breakNode);
            }
            CAstNode header = this.Ast.makeNode(17, this.Ast.makeConstant("_do_label"), this.Ast.makeNode(19));
            CAstNode loopGoto = this.Ast.makeNode(18, loopTest);
            wc.cfg().map(header, header);
            wc.cfg().map(loopGoto, loopGoto);
            wc.cfg().add(loopGoto, header, Boolean.TRUE);
            return this.Ast.makeNode(3, header, this.Ast.makeNode(3, loopBody, continueNode), loopGoto, breakNode);
        }
    }

    public static class FunctionContext<C extends WalkContext<C, T>, T>
    extends DelegatingContext<C, T> {
        private final T topNode;
        private final CAstSourcePositionRecorder pos = new CAstSourcePositionRecorder();
        private final CAstControlFlowRecorder cfg = new CAstControlFlowRecorder(this.pos);
        private final Map<CAstNode, Collection<CAstEntity>> scopedEntities = HashMapFactory.make();

        protected FunctionContext(C parent, T s2) {
            super(parent);
            this.topNode = s2;
        }

        @Override
        public T top() {
            return this.topNode;
        }

        @Override
        public void addScopedEntity(CAstNode construct, CAstEntity e) {
            if (!this.scopedEntities.containsKey(construct)) {
                this.scopedEntities.put(construct, new HashSet(1));
            }
            this.scopedEntities.get(construct).add(e);
        }

        @Override
        public Map<CAstNode, Collection<CAstEntity>> getScopedEntities() {
            return this.scopedEntities;
        }

        @Override
        public CAstControlFlowRecorder cfg() {
            return this.cfg;
        }

        @Override
        public CAstSourcePositionRecorder pos() {
            return this.pos;
        }
    }

    public static class TryCatchContext<C extends WalkContext<C, T>, T>
    implements WalkContext<C, T> {
        private final Map<String, CAstNode> catchNode;
        private final WalkContext<C, T> parent;

        protected TryCatchContext(C parent, CAstNode catchNode) {
            this(parent, Collections.singletonMap(null, catchNode));
        }

        protected TryCatchContext(C parent, Map<String, CAstNode> catchNode) {
            this.parent = parent;
            this.catchNode = catchNode;
        }

        @Override
        public CAstNode getCatchTarget() {
            return this.getCatchTarget(null);
        }

        @Override
        public CAstNode getCatchTarget(String s2) {
            return this.catchNode.get(s2);
        }

        @Override
        public WalkContext<C, T> getParent() {
            return this.parent;
        }
    }

    public static class LoopContext<C extends WalkContext<C, T>, T>
    extends BreakContext<C, T> {
        private final T continueTo;

        protected LoopContext(C parent, T breakTo, T continueTo, String label) {
            super(parent, breakTo, label);
            this.continueTo = continueTo;
        }

        @Override
        public T getContinueFor(String l) {
            return l == null || l.equals(this.label) ? this.continueTo : super.getContinueFor(l);
        }
    }

    public static class BreakContext<C extends WalkContext<C, T>, T>
    extends DelegatingContext<C, T> {
        private final T breakTarget;
        protected final String label;

        protected BreakContext(C parent, T breakTarget, String label) {
            super(parent);
            this.breakTarget = breakTarget;
            this.label = label;
        }

        @Override
        public T getBreakFor(String l) {
            return l == null || l.equals(this.label) ? this.breakTarget : super.getBreakFor(l);
        }
    }

    public static class DelegatingContext<C extends WalkContext<C, T>, T>
    implements WalkContext<C, T> {
        protected final C parent;

        protected DelegatingContext(C parent) {
            this.parent = parent;
        }

        @Override
        public T top() {
            return this.parent.top();
        }

        @Override
        public WalkContext<C, T> getParent() {
            return this.parent;
        }
    }

    public static class RootContext<C extends WalkContext<C, T>, T>
    implements WalkContext<C, T> {
        @Override
        public Map<CAstNode, Collection<CAstEntity>> getScopedEntities() {
            assert (false);
            return Collections.emptyMap();
        }

        @Override
        public List<CAstNode> getNameDecls() {
            return null;
        }

        @Override
        public void addScopedEntity(CAstNode newNode, CAstEntity visit) {
            assert (false);
        }

        @Override
        public CAstControlFlowRecorder cfg() {
            assert (false);
            return null;
        }

        @Override
        public CAstSourcePositionRecorder pos() {
            assert (false);
            return null;
        }

        @Override
        public CAstNodeTypeMapRecorder getNodeTypeMap() {
            assert (false);
            return null;
        }

        @Override
        public T getContinueFor(String label) {
            assert (false);
            return null;
        }

        @Override
        public T getBreakFor(String label) {
            assert (false);
            return null;
        }

        @Override
        public T top() {
            assert (false);
            return null;
        }

        @Override
        public WalkContext<C, T> getParent() {
            assert (false);
            return null;
        }
    }

    public static interface WalkContext<C extends WalkContext<C, T>, T> {
        public WalkContext<C, T> getParent();

        default public void addNameDecl(CAstNode n) {
            this.getParent().addNameDecl(n);
        }

        default public List<CAstNode> getNameDecls() {
            return this.getParent().getNameDecls();
        }

        default public Map<CAstNode, Collection<CAstEntity>> getScopedEntities() {
            return this.getParent().getScopedEntities();
        }

        default public CAstNode getCatchTarget() {
            return this.getParent().getCatchTarget();
        }

        default public CAstNode getCatchTarget(String s2) {
            return this.getParent().getCatchTarget(s2);
        }

        default public T top() {
            return this.getParent().top();
        }

        default public void addScopedEntity(CAstNode newNode, CAstEntity visit) {
            this.getParent().addScopedEntity(newNode, visit);
        }

        default public CAstControlFlowRecorder cfg() {
            return this.getParent().cfg();
        }

        default public CAstSourcePositionRecorder pos() {
            return this.getParent().pos();
        }

        default public CAstNodeTypeMapRecorder getNodeTypeMap() {
            return this.getParent().getNodeTypeMap();
        }

        default public T getContinueFor(String label) {
            return this.getParent().getContinueFor(label);
        }

        default public T getBreakFor(String label) {
            return this.getParent().getBreakFor(label);
        }
    }

    public static class Error
    extends WalaException {
        private static final long serialVersionUID = -8440950320425119751L;
        public final Set<Warning> warning;

        public Error(Set<Warning> message) {
            super(message.iterator().next().getMsg());
            this.warning = message;
        }
    }
}

